C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c  Program smooth3d : 3D volume edge detector/smoother
c  Author: Paul Gutowski [Augt:1996]
c ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---
c
c usp system variables
c

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c -----
c basic usp variables
c -----

      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, nreco, irs, ire, iform
      integer     luin , lbytes, nbytes, luout, obytes
      integer     KK,JJ,argis

c -----
c program variables defined with dynamic memory allocation
c -----

      integer     RecordHeaders
      integer     errcd1,errcd2,errcd3,errcd4,abort
      integer     errcd5
      integer     itemHeader,itemRecord

      real        TimeSlice, Output, TI
      real        Filter
      real        WorkSpace,tri(SZLNHD)

      pointer     (wkadr1 , RecordHeaders(200000))
      pointer     (wkadr  , TimeSlice (200000))
      pointer     (wkadrt , TI  (200000))
      pointer     (wkadro , Output (200000))
      pointer     (wkadrf , Filter (200000))
      pointer     (wkadr4 , WorkSpace(200000))

c -----
c program variables defined with static memory allocation
c -----

      integer StartRec,EndRec,FilterLength,Xtaper,Ytaper,Xpad,Ypad 
      integer start,end,nxWork,nyWork,nWork

      real Intercept, CosTaper, wate (SZLNHD)

      character   name*8, ntap*256, otap*256

      logical verbos,pass,edge,EOF,bypass
      logical med, avmed, first, last, dup
      logical cosine, bart, box, bess, inv

c -----
c j0 is a fcn to calculate the bessel j0(r)
c -----
 
      external j0

c -----
c Initialize Required Variables
c -----

      data name/'SMOOTH3D'/,abort/0/,luin/1/,lbytes/0/,nbytes/0/
      verbos = .false.
      pass   = .true.
      first  = .true.
      last   = .false.
      EOF    = .false.
      bypass = .false.

c -----
c get online help if necessary
c -----

      if ( argis('-?') .gt.0 .or. 
     :     argis('-h') .gt.0 .or. 
     :     argis('-help') .gt.0) then
         call help ()
         stop
      endif

c -----
c open printout
c -----

#include <f77/open.h>

c -----
c read program parameters from command line argument string
c -----

      call cmdln (ntap,otap,irs,ire,StartRec,EndRec,FilterLength,
     :    Intercept,CosTaper,Xtaper,Ytaper,Xpad,Ypad,pass,verbos,a,
     :    edge,avmed,med,nts,fact,cosine,bart,box,bess,inv,dup)

  
c -----
c open input/output datasets
c -----

      call getln ( luin, ntap, 'r', 0)
      call getln ( luout, otap, 'w', 1)

c -----
c read and update line header,
c write line header, save key parameters.
c -----

      lbytes=0

      call rtape  ( luin, lhed, lbytes )

      if(lbytes .eq. 0) then
         write(LERR,*)'smooth3d: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)     

      call hlhprt ( lhed , lbytes, name, 8, LERR )

c -----
c  Check Defaults and validity of command line entries
c -----

      if(StartRec.le.nsi)then
         start = 1
      else
         start = StartRec
      endif

       if(EndRec.eq.0)then
         end = nrec
      else
         end = EndRec 
      endif

      nxWork = nsamp + 2*Xpad + FilterLength
      nyWork = ntrc + 2*Ypad + FilterLength

      nWork = nxWork*nyWork
      iwbytes = SZSMPD * nWork
      
      if(ire.eq.0)ire = nrec
      nreco = ire - irs + 1

c -----
c  update historical line header & output header
c -----

      obytes = SZTRHD + SZSMPD * nsamp

      call savew (lhed, 'NumRec' , nreco, LINHED)

      call savhlh ( lhed, lbytes, lbyout )
      call wrtape(luout,lhed,lbyout)

c -----
c  compute time weights
c -----
      call weights ( nts, wate, fact, cosine, bart, box, bess,
     1               J0, Intercept)

c -----
c  echo input parameters to printout
c -----

      call verbal(irs,ire,nsamp,ntrc,nsi,StartRec,EndRec,FilterLength,
     :     Xtaper,Ytaper,Xpad,Ypad,pass,ntap,otap,iform,
     :     CosTaper,verbos,edge,avmed,wate,nts,cosine,bart,box,bess,
     :     Intercept,inv,dup,med)

c -----
c  Dynamic Memory Allocation
c  note : SZSMPD is the native
c  size of a float or int in bytes
c -----

      itemHeader = ntrc * ITRWRD * SZSMPD
      itemFilter = nts * FilterLength**2 * SZSMPD
      itemRecord = nxWork*nyWork*SZSMPD
      itemTI     = nts * itemRecord

      call galloc (wkadr1 , itemHeader, errcd1, abort)
      call galloc (wkadr  , itemRecord, errcd2, abort)
      call galloc (wkadrt , itemTI    , errcd3, abort)
      call galloc (wkadro , itemRecord, errcd4, abort)
      call galloc (wkadrf , itemFilter, errcd5, abort)
      call galloc (wkadr4 , itemRecord, errcd6, abort)
 
      if (errcd1.ne.0 .or. errcd2.ne.0 .or. errcd3.ne.0
     :    .or. errcd4.ne.0 .or. errcd5.ne.0 .or. errcd6.ne.0
     :     ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) itemTI,'  bytes'
         write(LERR,*) nts*itemRecord,'  bytes'
         write(LERR,*) itemFilter,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemHeader,' bytes'
         write(LER ,*) itemTI,'  bytes'
         write(LER ,*) nts*itemRecord,'  bytes'
         write(LER ,*) itemFilter,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) itemTI,'  bytes'
         write(LERR,*) nts*itemRecord,'  bytes'
         write(LERR,*) itemFilter,'  bytes'
         write(LERR,*)' '
      endif

c -----
c Build Filter
c -----
      CosTaper = (100. - CosTaper)/100.
      call XYFilter(Intercept,CosTaper,FilterLength,nf,nf2,J0,
     2              Filter,a,edge,med,avmed,nts,wate)

c -----
c Skip Down to User Defined Start Time Slice
c -----

      call recskp(1,irs-1,luin,ntrc,lhed)

c -----
c Process Data 
c -----

      call vclr (TI, 1, nts*nxWork*nyWork)
      itim = 0
      ltim = 0
      ion  = nts / 2
      irec = irs - 1
      

      DO 1000 JJ = irs, ire

c -----
c if we're processing a subset of input recs then after the last desired
c rec has been processed we already have read the next input rec (to fill
c out the last 3-grp). So we just skip the next read since the input data
c is already in TimeSlice
c -----
         if (JJ .eq. end+ion) go to 1005

c -----
c initialize  arrays
c -----
c 
c replaced vclr calls with clr2D calls - 12/10/98 - jev
c
c        call vclr (TimeSlice , 1,nxWork*nyWork)
c        call vclr (WorkSpace , 1,nxWork*nyWork)

         call clr2D (TimeSlice ,nxWork,nyWork)
         call clr2D (WorkSpace ,nxWork,nyWork)
 
         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsamp

         DO 1001 KK = 1, ntrc

            nbytes = 0
            call rtape( luin, lhed, nbytes)

c -----
c unexpected end of data reached. We clear the input matrix, set the
c end-of-data flag, and skip out. At that point we never come back
c to this loop
c -----
            if(nbytes .eq. 0) then
               write(LERR,*)'Unexpected End Of File on input:'
               write(LERR,*)'at rec= ',jj,'  trace= ',kk
               call clr2D (TimeSlice ,nxWork,nyWork)
               EOF = .true.
               go to 1005
            endif

c -----
c     advance array indices for this trace
c -----

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsamp

c -----
c load headers 
c -----

            call vmov (lhed,1,RecordHeaders(IndexHeader),1,ITRWRD)

c -----
c load time series 
c -----

            call vmov(lhed(ITHWP1),1,TimeSlice(IndexTrace),1,nsamp)

 1001    CONTINUE

            call saver2 (lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   jrec, TRACEHEADER)

            if (.not. EOF) itim = itim + 1
            if (itim .gt. nts) then
               itim = nts
            else
               ibuf = itim
            endif


 1005    CONTINUE

c -----
c cut, pad and taper 
c -----
         call vclr  (WorkSpace, 1, nxWork*nyWork)
            
         IF (.not. EOF) THEN
            call CutPadTaper(TimeSlice,nsamp,ntrc,Xpad,Ypad,
     1           FilterLength,Xtaper,Ytaper,
     2           WorkSpace,nxWork,nyWork,inv,dup)
         ELSE
            itim = itim - 1
         ENDIF


            call vclr  (Output, 1, nxWork*nyWork)

c -----
c roll nts slices, apply 3D filtering, extract center slice output
c -----
            call edger (WorkSpace,nxWork,nyWork,nf,nf2,first,last,
     1                  TimeSlice,Output,Filter,TI,Xpad,Ypad,edge,
     2                  med,avmed,pass,nts,itim,wate,jrec,EOF)

c -----
c as we roll on we don't want to actually output anything until we have
c a half nts buffer (TI) full. When we reach the magic number of nts/2+1 we
c start outputting records and start up the record number counter
c -----
            if (itim .le. ion) then
                go to 1010
            else
                irec = irec + 1
            endif
            
c -----
c Remove Pad
c -----
c
c replaced vclr call with clr2D call - 12/10/98 - jev
c
c           call vclr (WorkSpace,1,nxWork*nyWork)

            call clr2D(WorkSpace,nxWork,nyWork)

            call PadOff(Output,nxWork,nyWork,WorkSpace,nsamp,ntrc,
     :           Xpad,Ypad,FilterLength)

c -----
c Output Record
c -----
         if (verbos) write(LER,*)'Output record=  ',irec-1

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsamp

         if (JJ .eq. ire) EOF = .true.

         DO 1002 KK = 1,ntrc

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsamp

c -----
c restore header
c -----

            call vmov (RecordHeaders(IndexHeader),1,lhed(1),1,ITRWRD)

c -----
c clear trace area
c -----

               call vclr(tri,1,nsamp)

c -----
c extract trace from WorkSpace 
c -----

               call SliceOut(WorkSpace,nxWork,nyWork,nsamp,KK,tri,
     1                       inv)

c ------
c load filtered trace to output time series array
c -----

               call vmov(tri,1,lhed(ITHWP1),1,nsamp)

c -----
c reset the record numbers since we're now nts / 2 out of sync
c -----
            call savew2 (lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   irec, TRACEHEADER)

            call wrtape(luout,lhed,obytes)

 1002    CONTINUE

c -----
c ... otherwise if we've reached the end of the input data (read last
c     rec) then go back and output the last nts/2 recs from the current
c     nts buffer TI
c -----
         if ( (JJ.eq.ire .AND. JJ.eq.ire) .OR. EOF ) then
             ltim = ltim + 1
             ibuf = ibuf - 1
             if (ltim .gt. ion) go to 999
             call clr2D (TimeSlice ,nxWork,nyWork)
             go to 1005
         endif

 1010    CONTINUE

c -----
c if we've hit an EOF within the process range of records then we have
c flushed the last 3-grp and we're ready to close out
         if (last) go to 999
c -----
 1000 CONTINUE

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'processed ',nreco,' record(s) with ',ntrc,' traces'

      stop
      end
      



 
