C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine weights ( nts, wate, amp, cosine, bart, box, bess,
     1                     J0, Intercept)

      real    wate (nts)
      integer nts
      real    amp, Intercept, J0
      logical cosine, bart, box, bess

      external J0

      pi  = 3.14159265
      ic1 = nts / 2
      ic2 = nts / 2 + 1

      do  i = 1, nts
          wate (i) = 1.0
      enddo

      if (cosine) then

         do  i = 1, ic1
             wc = cos ( float(i) * pi / float(ic2) )
             wt = .5 * (1. - wc)
             wate (i) = wt
             wate (nts - i + 1) = wt
         enddo
         xnorm = 0.
         do  i = 1, nts
             xnorm = xnorm + wate (i)
         enddo
         do  i = 1, nts
             wate (i) = wate (i) / xnorm
         enddo

      elseif (bart) then

         do  i = 1, ic1
             wt = float(i) / float(ic2)
             wate (i) = wt
             wate (nts - i + 1) = wt
         enddo
         xnorm = 0.
         do  i = 1, nts
             xnorm = xnorm + wate (i)
         enddo
         do  i = 1, nts
             wate (i) = wate (i) / xnorm
         enddo

      elseif (bess) then

         wate (ic2) = J0 (0.0)

         do  i = 1, ic1
             R = float(ic1 - i + 1) * Intercept
             wt = J0 (R)
             wate (i) = wt
             wate (nts - i + 1) = wt
         enddo
         do  i = 1, ic1
             wc = cos ( float(i) * pi / float(ic1) )
             wt = .5 * (1. - wc)
             wate (i) = wt * wate (i)
             wate (nts - i + 1) = wt * wate (nts - i + 1)
         enddo
         xnorm = 0.
         do  i = 1, nts
             xnorm = xnorm + wate (i)
         enddo
         do  i = 1, nts
             wate (i) = wate (i) / xnorm
         enddo

      else

         do  i = 1, nts
             wate (i) = 1 / float(nts)
         enddo

      endif

      return
      end
