C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( vverbos, verbos, stp, oline, go, off, 
     :     ntap, otap, dtap, ptap, num_sr3d2_vols, irt3d0, mode0, ilog, 
     :     nsampi, RI1, RIINCR, LINE1, LININC, DI1, DIINCR, isli, isdi, 
     :     ieli, iedi, dstmin, dstmax, dstdel, flexbin, nodead,
     :     restart, radius )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer num_sr3d2_vols, irt3d0, mode0, ilog, nsampi 
      integer RI1, RIINCR, LINE1, LININC, DI1, DIINCR
      integer isli, isdi, ieli, iedi

      real dstmin, dstmax, dstdel, radius

      character ntap*256, otap*256, dtap(1000)*256, ptap*256

      logical vverbos, verbos, stp, oline, go, off, flexbin
      logical nodead, restart

c declare local variables

      integer argis

c parse command line

      restart = (argis ('-moredata') .gt. 0)

      call argr4 ('-ddel', dstdel, 0.0, 0.0)
      call argi4 ('-dii', DIINCR, 0, 0)
      call argi4 ('-dis', DI1, 0, 0)
      call argr4 ('-dmax', dstmax, 0.0, 0.0)
      call argr4 ('-dmin', dstmin, 0.0, 0.0)

      num_sr3d2_vols = 0

      do  i = 1, 1000
         call argstr ('-D', dtap(i), ' ', ' ')
         if (dtap(i) .ne. ' ') then
            num_sr3d2_vols = i
         endif
      enddo

      call argi4 ('-eli', ieli, 99999999, 99999999)
      call argi4 ('-edi', iedi, 99999999, 99999999)

      flexbin = (argis ('-flexbin') .gt. 0)

      go      = (argis ('-go') .gt. 0)


      call argi4 ('-lii', LININC, 0, 0)
      call argi4 ('-lis', LINE1, 0, 0)
      call argi4  ('-log',ilog , -1, -1)
      oline   = (argis ('-L') .gt. 0)

      call argi4  ('-mode',mode0 , -1, -1)

      call argi4 ( '-nsamp', nsampi, 0, 0 )
      call argstr ('-N', ntap, ' ', ' ')

      off     = (argis ('-off') .gt. 0)
      call argstr ('-O', otap, ' ', ' ')

      call argstr ('-P', ptap, ' ', ' ')

      call argr4 ('-radius', radius, 1.e30, 1.e30)
      call argi4 ('-rii', RIINCR, 0, 0)
      call argi4 ('-ris', RI1, 0, 0)

      stp     = (argis ('-stop') .gt. 0)
      call argi4 ('-sdi', isdi, 1, 1)
      call argi4 ('-sli', isli, 1, 1)

      call argi4  ('-type',irt3d0, -999, -999)

      nodead  = (argis ('-nodead') .gt. 0)
      if ( off .and. nodead ) then
         nodead = .false.
         write(LERR,*)'WARNING from sr3d2:'
         write(LERR,*)'Cannot use -nodead for offset sorts'
         write(LERR,*)'-nodead ignored...'
         write(LER ,*)'WARNING from sr3d2:'
         write(LER ,*)'Cannot use -nodead for offset sorts'
         write(LER ,*)'-nodead ignored...'
      endif

      vverbos = (argis ('-VV') .gt. 0)
      verbos  = (argis ('-V') .gt. 0)


      return
      end
