C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Flex_O_Gram(itemi, trdist, FoldNm, noff, 
     :     num_flex_traces, flex_dist_required, flex_hist, 
     :     distmin, dstmax, dstdel  )

c declare variables passed from calling routine

      integer itemi, FoldNm, noff, num_flex_traces

      real trdist(itemi) 
      real flex_dist_required(noff), flex_hist(noff)
      real distmin, dstdel, dstmax

c declare local variables

c initialize variable

      num_flex_traces = 0

c create histogram of input trace distances using dmin, dmax, ddel from command line

      call vclr (flex_hist,1,noff)

      if ( FoldNm .gt. 0 ) then
         call hist ( trdist, 1, flex_hist, FoldNm, 
     :        noff, dstmax, distmin )

c look for unpopulated histogram bins and load same to output required array

         do i = 1, noff
            if ( flex_hist(i) .eq. 0 ) then
               num_flex_traces = num_flex_traces + 1
               flex_dist_required(num_flex_traces) = distmin + 
     :              ( i - 1 ) * dstdel
            endif
         enddo

      else

c we have a dead record so we need all traces from nearby records.  I do
c not know if we really want to do this so let us see what happens in 
c beta testing of the algorithm

         num_flex_traces = noff
         do i = 1, noff
            flex_dist_required(num_flex_traces) = distmin + i * 
     :           dstdel
         enddo
      endif

      return
      end

      
