C***********************************************************************00008270
C                                                                       00008280
C     SUBROUTINE NAME: XFORM  (TRANSFORM COORDINATE SYSTEMS)            00008290
C     ENTRY POINTS:    XFMI   (INITIALIZATION)                          00008300
C                      XFMFWD (COMPUTE NEW COORDINATES - FORWARD)       00008310
C                      XFMINV (COMPUTE NEW COORDINATES - INVERSE)       00008320
C                                                                       00008330
C     LANGUAGE: FORTRAN                                                 00008340
C                                                                       00008350
C     AUTHOR: ?.?????                                                   00008360
C                                                                       00008370
C     DATE WRITTEN: ??/??/??                                            00008380
C                                                                       00008390
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00008410
C     ABSTRACT: COMPUTE THE CONSTANTS NEEDED TO PERFORM THE FOLLOWING   00008440
C               TRANSFORMATION OF A PARALLELOGRAM TO A RECTANGLE:       00008450
C                 1- MAP CORNER 1 ONTO ORIGIN                           00008460
C                 2- MAP CORNER 2 ONTO POSITIVE Y-AXIS                  00008470
C                 3- MAP CORNER 3 ONTO QUADRANT 1                       00008480
C                 4- MAP CORNER 4 ONTO POSITIVE X-AXIS                  00008490
C               AND, GIVEN A PARTICULAR (X,Y), NEW COORDINATES (IN      00008500
C               LINE INDEX, DEPTH INDEX FORM) ARE RETURNED.             00008510
C                                                                       00008520
C     CALLING SEQUENCE: CALL XFMI  (IX1, IY1, IX2, IY2, IX3, IY3,       00008530
C                                   IX4, IY4, DY , DX , NX , NY ,       00008540
C                                   IER)                                00008550
C                WHERE: IX1 - X-COORDINATE OF CORNER 1                  00008560
C                       IY1 - Y-COORDINATE OF CORNER 1                  00008570
C                       IX2 - X-COORDINATE OF CORNER 2                  00008580
C                       IY2 - Y-COORDINATE OF CORNER 2                  00008590
C                       IX3 - X-COORDINATE OF CORNER 3                  00008600
C                       IY3 - Y-COORDINATE OF CORNER 3                  00008610
C                       IX4 - X-COORDINATE OF CORNER 4                  00008620
C                       IY4 - Y-COORDINATE OF CORNER 4                  00008630
C                       DY  - CELL DIMENSION  ALONG SIDE 1-2            00008640
C                       DX  - CELL DIMENSION  ALONG SIDE 2-3            00008650
C                       NX  - NUMBER OF CELLS ALONG SIDE 2-3            00008660
C                       NY  - NUMBER OF CELLS ALONG SIDE 1-2            00008670
C                       IER - ERROR STATUS                              00008680
C                               0 = NO ERRORS ENCOUNTERED               00008690
C                               1 = COORDINATES DON'T DESCRIBE A        00008700
C                                   PARALLELOGRAM                       00008710
C                                                                       00008720
C     CALLING SEQUENCE: CALL XFMFWD(XC  , YC  , ILI, IDI, XT , YT)      00008730
C                                   XTBC, YTBC, IWARN)                  00008740
C                WHERE: XC   - X-COORDINATE OF POINT IN QUESTION        00008750
C                       YC   - Y-COORDINATE OF POINT IN QUESTION        00008760
C                       ILI  - LINE  INDEX OF (XC,YC)                   00008770
C                       IDI  - DEPTH INDEX OF (XC,YC)                   00008780
C                       XT   - TRANSFORMED X-COORDINATE                 00008790
C                       YT   - TRANSFORMED Y-COORDINATE                 00008800
C                       XTBC - TRANSFORMED X-COORDINATE BIN CENTER      00008810
C                       YTBC - TRANSFORMED Y-COORDINATE BIN CENTER      00008820
C                       IWARN- WARNING FLAG                             00008830
C                                0 = ALL OK                             00008840
C                                1 = POINT NOT WITHIN GRID BOUNDARIES   00008850
C                                                                       00008860
C     CALLING SEQUENCE: CALL XFMINV(XC  , YC  , XT  , YT  ,             00008870
C                                   XBC , YBC , XTBC, YTBC, JERR)       00008880
C                WHERE: XC   - INVERSED X-COORDINATE                    00008890
C                       YC   - INVERSED Y-COORDINATE                    00008900
C                       XT   - X-COORDINATE IN QUESTION                 00008910
C                       YT   - Y-COORDINATE IN QUESTION                 00008920
C                       XBC  - INVERSED X-COORDINATE BIN CENTER         00008930
C                       YBC  - INVERSED Y-COORDINATE BIN CENTER         00008940
C                       XTBC - X-COORDINATE BIN CENTER IN QUESTION      00008950
C                       YTBC - Y-COORDINATE BIN CENTER IN QUESTION      00008960
C                       JERR - ERROR FLAG                               00008970
C                                 0 = NO ERRORS                         00008980
C                                 1 = ERRORS ENCOUNTERED - MATRIX IS    00008990
C                                     SINGULAR                          00009000
C                                                                       00009010
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE                00009020
C                           11/21/83  -  G.SHIBA                        00009030
C                           CALCULATE BIN CENTER COORDINATES.           00009040
C                           CALCULATE INVERSED COORDINATES.             00009050
C                                                                       00009060
C***********************************************************************00009070
C                                                                       00009080
C                                                                       00009090
      SUBROUTINE XFMI
     *            (IX1   , IY1   , IX2   , IY2   , IX3   , IY3   ,
     *             IX4   , IY4   , DY    , DX    , NX    , NY    ,
     *             IER   ,
     *             XX, XY, YX, YY, XXT, XYT, YXT, YYT)
C                                                                       00009140
C                                                                       00009150
C-----------------------------------------------------------------------00009160
C                                                                       00009170
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS                      00009180
C                                                                       00009190
C-----------------------------------------------------------------------00009200

      integer IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, NX, NY, IER

      real DY, DX
C                                                                       00009210
      REAL*8    P41L                                                    00009220
      REAL*8    COS0  , SIN0  , SCOS0 , SSIN0                           00009230
      REAL*8    TANPHI, DYCPHI, CPHI                                    00009240
      REAL*8    X     , Y     , XX    , XY    , YX    , YY
      REAL*8    XXT   , XYT   , YXT   , YYT, DDX, DDY
C                                                                       00009280
      IER               = 0                                             00009290
C                                                                       00009300
C-----------------------------------------------------------------------00009310
C                                                                       00009320
C     ENSURE THE COORDINATES DEFINE A PARALLELOGRAM                     00009330
C                                                                       00009340
C-----------------------------------------------------------------------00009350
C                                                                       00009360
      COS0              = IX4  - IX1                                    00009370
      SIN0              = IY4  - IY1                                    00009380
      P41L              = COS0 * COS0  +  SIN0 * SIN0                   00009390
      XX                = IX2  - IX1                                    00009400
      YY                = IY2  - IY1                                    00009410
      IX                = P41L + 0.5                                    00009420
      IY                = XX   * XX    +  YY   * YY    +  0.5           00009430

c     write(0,*)'IX, IY= ',ix,iy,xx,yy
C                                                                       00009440
c     IF(IX .EQ. (IX3-IX2) * (IX3-IX2) +  (IY3-IY2) * (IY3-IY2)  .AND.  00009450
c    *   IY .EQ. (IX4-IX3) * (IX4-IX3) +  (IY4-IY3) * (IY4-IY3)       ) 00009460
c    *   GO TO 100                                                      00009470
c     IER               = 1                                             00009480
c     GO TO 9999                                                        00009490
C                                                                       00009500
C-----------------------------------------------------------------------00009510
C                                                                       00009520
C     COMPUTE THE CONSTANTS TO PERFORM THE TRANSFORMATION               00009530
C                                                                       00009540
C-----------------------------------------------------------------------00009550
C                                                                       00009560
      DDX = DX
      DDY = DY
      P41L              = DSQRT(P41L)
      COS0              = COS0 / P41L
      SIN0              = SIN0 / P41L

c     write(0,*)'P41L,COS0,SIN0= ',P41L,COS0,SIN0
C                                                                       00009600
      ISIGN             =  1
      IF(XX*SIN0 .GT. YY*COS0) ISIGN = -1
C                                                                       00009630
      SCOS0             = ISIGN * COS0
      SSIN0             = ISIGN * SIN0
C                                                                       00009660
      X                 = YY * SIN0   +  XX * COS0
      Y                 = YY * SCOS0  -  XX * SSIN0

c     write(0,*)'X,Y,SCOS0,SSIN0= ',x,y,SCOS0,SSIN0,ISIGN
C                                                                       00009690
      TANPHI            = X / Y
      CPHI              =       DABS(Y)  / DSQRT(X*X  + Y*Y)
      DYCPHI            = DDY  * CPHI

c     write(0,*)'TANPHI,CPHI,DYCPHI= ',TANPHI,CPHI,DYCPHI
c     write(0,*)'COS0,SSIN0,TANPHI,SIN0,SCOS0,CPHI= ',
c    1 COS0,SSIN0,TANPHI,SIN0,SCOS0,CPHI

      XXT               = COS0 + SSIN0 * TANPHI
c     XYT               = SIN0 - SSIN0 * TANPHI
      XYT               = SIN0 - SCOS0 * TANPHI
      YXT               = -SSIN0        / CPHI
      YYT               =  SCOS0        / CPHI

c     write(0,*)'XXT= ',XXT,XYT,YXT,YYT, ddx,ddy
C                                                                       00009780
      XX                = XXT   / DDX
      XY                = XYT   / DDX
      YX                =-SSIN0 / DYCPHI
      YY                = SCOS0 / DYCPHI

c     write(0,*)'xx,xy,yx,yy= ',xx,xy,yx,yy
C                                                                       00009830
C-----------------------------------------------------------------------00009840
C                                                                       00009850
C     COMPUTE THE NUMBER OF IN-LINE CELLS & CROSS-LINE CELLS            00009860
C                                                                       00009870
C-----------------------------------------------------------------------00009880
c     write(0,*)'IX/Y ',ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4
C                                                                       00009890
      X                 = (IX4-IX1) * XX  +  (IY4-IY1) * XY  + 1
      NX                =  nint (sngl(X) )
      IF(X-NX .LT. 0.5)    NX = NX  - 1
      Y                 = (IX2-IX1) * YX  +  (IY2-IY1) * YY  + 1
      NY                =  nint (sngl(Y) )
      IF(Y-NY .LT. 0.5)    NY = NY  - 1

c     write(0,*)'X/Y ',xx,xy,yx,yy,x,y
C                                                                       00009960
C-----------------------------------------------------------------------00009970
C                                                                       00009980
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           00009990
C                                                                       00010000
C-----------------------------------------------------------------------00010010
C                                                                       00010020
      RETURN                                                            00010030
      END
C                                                                       00010040
C                                                                       00010050
C=======================================================================00010060
C                                                                       00010070
C                                                                       00010080
      SUBROUTINE
     *      XFMFWD(XC    , YC    , ILI   , IDI   , XT    , YT    ,
     *             XTBC  , YTBC  , IWARN , IX1   , IY1   ,
     *             XX, XY, YX, YY, XXT, XYT, YXT, YYT, DX, DY, NDI, NLI)

      REAL*8                    XX    , XY    , YX    , YY
      REAL*8                    XXT   , XYT   , YXT   , YYT


C                                                                       00010110
C                                                                       00010120
C=======================================================================00010130
C                                                                       00010140
      IWARN             = 0                                             00010150
C                                                                       00010160
      IXC               = XC + SIGN(0.5,XC)                             00010170
      IYC               = YC + SIGN(0.5,YC)                             00010180
C                                                                       00010190
      ILI               = (IXC-IX1) * XX  +  (IYC-IY1) * XY  + 0.999999 00010200
      IDI               = (IXC-IX1) * YX  +  (IYC-IY1) * YY  + 0.999999 00010210

c     IDI               = (IXC-IX1) * XX  +  (IYC-IY1) * XY  + 0.999999 00010200
c     ILI               = (IXC-IX1) * YX  +  (IYC-IY1) * YY  + 0.999999 00010210
C                                                                       00010220
      XT                = (IXC-IX1) * XXT +  (IYC-IY1) * XYT            00010230
      YT                = (IXC-IX1) * YXT +  (IYC-IY1) * YYT            00010240
C                                                                       00010250
      XTBC              = (DX * IDI) - (DX / 2.0)                       00010260
      YTBC              = (DY * ILI) - (DY / 2.0)                       00010270

c     write(0,*)'xc,xy= ',IXC,IYC,(IXC-IX1),(IYC-IY1)
c     write(0,*)'X,Y ',XX, XY, YX, YY, XXT, XYT, YXT, YYT
c     write(0,*)'DI,LI= ',IDI,ILI
C                                                                       00010280
C-----------------------------------------------------------------------00010290
C                                                                       00010300
C     SEE IF POINT IS WITHIN GRID BOUNDARIES                            00010310
C                                                                       00010320
C-----------------------------------------------------------------------00010330
C                                                                       00010340
      IF(ILI .LE. 0 .OR. ILI .GT. NLI) IWARN = 1
      IF(IDI .LE. 0 .OR. IDI .GT. NDI) IWARN = 1
C                                                                       00010370
C-----------------------------------------------------------------------00010380
C                                                                       00010390
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           00010400
C                                                                       00010410
C-----------------------------------------------------------------------00010420
C                                                                       00010430
      RETURN                                                            00010440
      END
C                                                                       00010450
C                                                                       00010460
C=======================================================================00010470
C                                                                       00010480
C                                                                       00010490
      SUBROUTINE
     *      XFMINV(XC    , YC    , XT    , YT    ,
     *             XBC   , YBC   , XTBC  , YTBC  , JERR,
     *             XX, XY, YX, YY, XXT, XYT, YXT, YYT, 
     *             DX, DY, IX1,IY1)

      REAL*8                    XX    , XY    , YX    , YY
      REAL*8                    XXT   , XYT   , YXT   , YYT
      REAL*8    A     , B     , C     , D     , E     , F

C                                                                       00010520
C                                                                       00010530
C=======================================================================00010540
C                                                                       00010550
      JERR              = 0                                             00010560
C                                                                       00010570
      A                 = XTBC                                          00010580
      B                 = IX1                                           00010590
      C                 = IY1                                           00010600
      D                 = YTBC                                          00010610
C     E                 = XTBC + (IX1 * XXT) + (IY1 * XYT)              00010620
C     F                 = YTBC + (IX1 * YXT) + (IY1 * YYT)              00010630
      E                 = A    + (B   * XXT) + (C   * XYT)              00010640
      F                 = D    + (B   * YXT) + (C   * YYT)              00010650
C                                                                       00010660
      CALL SIMLEQ(XXT   , XYT   , E     ,                               00010670
     *            YXT   , YYT   , F     , XBC   , YBC   , JERR)         00010680
C                                                                       00010690
      A                 = XT                                            00010700
      D                 = YT                                            00010710
C     E                 = XT   + (IX1 * XXT) + (IY1 * XYT)              00010720
C     F                 = YT   + (IX1 * YXT) + (IY1 * XYT)              00010730
      E                 = A    + (B   * XXT) + (C   * XYT)              00010740
      F                 = D    + (B   * YXT) + (C   * XYT)              00010750
C                                                                       00010760
      CALL SIMLEQ(XXT   , XYT   , E     ,                               00010770
     *            YXT   , YYT   , F     , XC    , YC    , JERR)         00010780
C                                                                       00010790
C-----------------------------------------------------------------------00010800
C                                                                       00010810
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           00010820
C                                                                       00010830
C-----------------------------------------------------------------------00010840
C                                                                       00010850
      RETURN                                                            00010860
      END                                                               00010870

C***********************************************************************00010880
C                                                                       00010890
C     SUBROUTINE NAME: SIMLEQ  (SIMULTANEOUS EQUATIONS)                 00010900
C                                                                       00010910
C     LANGUAGE: FORTRAN                                                 00010920
C                                                                       00010930
C     AUTHOR: ?.?????                                                   00010940
C                                                                       00010950
C     DATE WRITTEN: ??/??/??                                            00010960
C                                                                       00010970
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00010990
C |               copyright 2001, Amoco Production Company             |
C |                           All Rights Reserved                      |
C |                   an affiliate of BP America Inc.                  |
C                                                                       00011010
C     ABSTRACT: GIVEN TWO LINEAR EQUATIONS IN TWO UNKNOWNS, SOLVE       00011020
C               FOR THE TWO UNKNOWNS SIMULTANEOUSLY.                    00011030
C                                                                       00011040
C                               AX + BY = E                             00011050
C                               CX + DY = F                             00011060
C                                                                       00011070
C     CALLING SEQUENCE: CALL SIMLEQ(A , B , E , C , D , F , X , Y)      00011080
C                                                                       00011090
C                WHERE: A - COEFFICIENT OF FIRST  UNKNOWN IN FIRST  EQ. 00011100
C                       B - COEFFICIENT OF SECOND UNKNOWN IN FIRST  EQ. 00011110
C                       E - CONSTANT TERM OF FIRST  EQ.                 00011120
C                       C - COEFFICIENT OF FIRST  UNKNOWN IN SECOND EQ. 00011130
C                       D - COEFFICIENT OF SECOND UNKNOWN IN SECOND EQ. 00011140
C                       F - CONSTANT TERM OF SECOND EQ.                 00011150
C                       X - FIRST  UNKNOWN                              00011160
C                       Y - SECOND UNKNOWN                              00011170
C                    IERR - ERROR FLAG                                  00011180
C                              0 = NO ERRORS                            00011190
C                              1 = ERROR DETECTED - MATRIX IS SINGULAR  00011200
C                                                                       00011210
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE                00011220
C                                                                       00011230
C***********************************************************************00011240
C                                                                       00011250
C                                                                       00011260
      SUBROUTINE SIMLEQ(A, B, E, C, D, F, X, Y, IERR)
C                                                                       00011280
C                                                                       00011290
C-----------------------------------------------------------------------00011300
C                                                                       00011310
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS                      00011320
C                                                                       00011330
C-----------------------------------------------------------------------00011340
C                                                                       00011350
      REAL*8    A     , B     , C     , D     , E     , F               00011360
      REAL*8    XX    , YY                                              00011370
C                                                                       00011380
      REAL*4    X     , Y                                               00011390
C                                                                       00011400
      IERR              = 0                                             00011410
C                                                                       00011420
C-----------------------------------------------------------------------00011430
C                                                                       00011440
C     SEE IF MATRIX IS SINGULAR                                         00011450
C                                                                       00011460
C-----------------------------------------------------------------------00011470
C                                                                       00011480
      IF((A*D) .NE. (B*C)) GO TO 100                                    00011490
      IERR              = 1                                             00011500
      GO TO 200                                                         00011510
C                                                                       00011520
C-----------------------------------------------------------------------00011530
C                                                                       00011540
C     COMPUTE X & Y                                                     00011550
C                                                                       00011560
C-----------------------------------------------------------------------00011570
C                                                                       00011580
  100 XX                = ((B*F) -  (D*E)) / ((B*C) - (A*D))            00011590
C                                                                       00011600
      IF(B .EQ. 0.0D0)      GO TO 150                                   00011610
      YY                =  (E    - (A*XX)) /   B                        00011620
      GO TO 160                                                         00011630
C                                                                       00011640
  150 YY                =  (F    - (C*XX)) /   D                        00011650
C                                                                       00011660
  160 X                 = XX                                            00011670
      Y                 = YY                                            00011680
C                                                                       00011690
C-----------------------------------------------------------------------00011700
C                                                                       00011710
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           00011720
C                                                                       00011730
C-----------------------------------------------------------------------00011740
C                                                                       00011750
  200 RETURN                                                            00011760
      END                                                               00011770
