C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program STACK
c__________________________________________________________________________
c     STACK -- Stack/Add seismic traces using various weights.
c                                                            
c     Original Version by K. B. Taylor and R. B. Herrmann.
c
c     Additional options (Blackman, Hamming and Linear offset weights)
c     vectorization, restructuring and cleanup by K. J. Marfurt (11/2/92)
c__________________________________________________________________________
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <f77/pid.h>

      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      integer   hbegin
c     parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)


      integer     sheader (SZLNHD)
      integer     bufin(SZLNHD*2)
      integer     bufout(SZLNHD*2)
      integer     itr   (SZLNHD*2)
      integer     ARGIS, li1, li2, di1, di2
      real        power
 
      character   name * 7, ntap * 256, otap * 256
      character   type * 1, type1 * 1, type2 * 1
 
      logical     verbos, semb, semwt
      logical     dwgt,blackman,hamming,snorm,tnorm,BC
 
      data  name/'STACK3D'/, nbytes/0/, lbytes/0/
c-------------------------------------------------------------------
c     If '-?' flag is used in command line, execute query
c     loop and end program.
c-------------------------------------------------------------------
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help()
         stop
      endif
c-------------------------------------------------------------------
c     open printout file
c-------------------------------------------------------------------
#include <f77/open.h>
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ' )
c-------------------------------------------
c     Open input and output files
c-------------------------------------------
      call getln(luin,ntap,'r',0)
      call getln(luout,otap,'w',1)
c----------------------------------------------------
c     Read line header and save parameters
c----------------------------------------------------
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'STACK3D: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call hlhprt(sheader,lbytes,name,5,lerr)

      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumTrc',ntrc,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'Format',iform,LINEHEADER)

      call saver(sheader,'CDPFld',ifld ,LINEHEADER)
      call saver(sheader,'MnLnIn', li1 ,LINEHEADER)
      call saver(sheader,'MxLnIn', li2 ,LINEHEADER)
      call saver(sheader,'MnDpIn', di1 ,LINEHEADER)
      call saver(sheader,'MxDpIn', di2 ,LINEHEADER)

      call saver( sheader, 'APIWN9', type , LINHED)
      call saver( sheader, 'APIWNA', type1, LINHED)
      call saver( sheader, 'APIWNB', type2, LINHED)

      lenhed=ITRWRD
      hbegin=1-lenhed

      nli = li2 - li1 + 1
      ndi = di2 - di1 + 1
      ntr = ntrc
      ngath = ntr
      if     (type1 .eq. 'L' .AND. type2 .eq. 'D') then
              mgath = ifld
      elseif (type1 .eq. 'D' .AND. type2 .eq. 'L') then
              mgath = ifld
      else
              mgath = ntrc
      endif
c---------------------------------------------------------------------------
c     Read program input parameters from command line argument flags
c---------------------------------------------------------------------------
      call cmdln(d1pos,d2pos,d1neg,d2neg,
     1           power,semb,semwt,verbos,
     2           tnorm,snorm,dwgt,blackman,hamming,BC)
c---------------------------------------------------------------------------
c     print out parameters
c---------------------------------------------------------------------------
      write(LERR,*) ' Values read from command line'
      write(LERR,*) ' Nth root power          =  ', power
      write(LERR,*) ' Positive spread: near dist = ',d1pos
      write(LERR,*) ' Positive spread: far  dist = ',d2pos
      write(LERR,*) ' Negative spread: near dist = ',d1neg
      write(LERR,*) ' Negative spread: far  dist = ',d2neg
      write(LERR,*) ' weight traces by distance?       ',dwgt     
      write(LERR,*) ' Apply Hamming weights?           ',hamming  
      write(LERR,*) ' Apply Blackman weights?          ',blackman 
      write(LERR,*) ' Apply equal, normalized weights? ',tnorm
      write(LERR,*) ' Normalize by nonzero samps?      ',snorm
      write(LERR,*) ' Apply semblance weights?         ',semwt
      write(LERR,*) ' Output semblance?                ',semb
      if (BC)
     1write(LERR,*) ' Compute CDP XYs'
      write(LERR,*) ' Verbose output?                  ',verbos
      write(LERR,*) ' '
      write(LERR,*) ' Primary sort type   = ',type1
      write(LERR,*) ' Secondary sort type = ',type2
      write(LERR,*) ' '
c----------------------------------------------------
c     print out header parameters
c----------------------------------------------------
      write(LERR,*) ' '
      write(LERR,*) ' Values read from input data set lineheader'
      write(LERR,*) ' Number of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval         =  ', nsi
      write(LERR,*) ' Traces per Record       =  ', ntr
      write(LERR,*) ' Records per Line        =  ', nrec
      write(LERR,*) ' Format of Data          =  ', iform
      write(LERR,*) ' Traces/gather           =  ', ngath
      write(LERR,*) ' Max Traces/gather       =  ', mgath
      write(LERR,*) ' Max DI fold             =  ', ifld
      write(LERR,*) ' Min line (LI) index          =  ', li1
      write(LERR,*) ' Max line (LI) index          =  ', li2
      write(LERR,*) ' Number of lines              =  ', nli
      write(LERR,*) ' Min depth (DI) index         =  ', di1
      write(LERR,*) ' Max depth (DI) index         =  ', di2
      write(LERR,*) ' Number of DIs                =  ', ndi
      write(LERR,*) ' '
c---------------------------------------------------------------------------
c     Check bounds of input parameters and set values to defaults
c---------------------------------------------------------------------------
      ns = 1
      ne = ntrc
      irs = 1
      ire = nrec

c-------------------------------------------------------------
c        save key parameters in line header; save command
c        line in historical line header
c-------------------------------------------------------------

         if     (type1 .eq. 'L' .AND. type2 .eq. 'D') then

                call savew( sheader, 'NumTrc', ndi  , LINHED)
                call savew( sheader, 'NumRec', nli  , LINHED)
                ntpr = ndi

         elseif (type1 .eq. 'D' .AND. type2 .eq. 'L') then

                call savew( sheader, 'NumTrc', nli  , LINHED)
                call savew( sheader, 'NumRec', ndi  , LINHED)
                ntpr = nli

         else

                nrr = ntrc * nrec
                ntpr = ntrc
                call savew( sheader, 'NumTrc',  1   , LINHED)
                call savew( sheader, 'NumRec', nrec , LINHED)

         endif

      call savhlh( sheader, lbytes, lbyout)
      call WRTAPE (luout, sheader, lbyout)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_recind,ln_RecInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('FlReFN',ifmt_FlReFN,l_FlReFN,ln_FlReFN,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('ToTmAU',ifmt_ToTmAU,l_ToTmAU,ln_ToTmAU,TRACEHEADER)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('ugather',l_ugather,l_free,nsamp*mgath,lerr)
      call mapmem('weight',l_weight,l_free,nsamp*mgath,lerr)
      call mapmem('usum',l_usum,l_free,nsamp,lerr)
      call mapmem('udenom',l_udenom,l_free,nsamp,lerr)
      call mapmem('icount',l_icount,l_free,nsamp,lerr)
      call mapmem('taper',l_taper,l_free,mgath**2,lerr)
      call mapmem('xoff',l_xoff,l_free,mgath,lerr)
      call mapmem('theta',l_theta,l_free,mgath,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for STACK3D: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for STACK3D: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)
         write(lerr,*)'program STACK3D aborted'
         call exit(101)
      endif
c---------------------------------------------------------------------
c     get weights for all possible combination of live samples.
c     for non unitary weights, the traces should be sorted by distance,
c     be equally spaced, and have dead traces interpolated.
c---------------------------------------------------------------------
      call getwgt(s(l_taper),s(l_theta),s(l_xoff),mgath,
     1            lerr,hamming,blackman,tnorm,snorm,verbos)
c---------------------------------------------------------------------
c     Skip unwanted records if necessary.  Skipping is done
c     in groups of ntr traces per record.
c---------------------------------------------------------------------
      call recskp(1,irs-1,luin,ntr,bufin)    
c
      ic=1
      icc = 0
      irec = 1
      do 10000 i=irs,ire
c-----------------------------------------------------------------------------
c      if no. traces in gather is not input no. traces/gath we may have some 
c      traces in input left over, i.e. partial gather
c-----------------------------------------------------------------------------
       call stacksub(bufin,bufin,bufout,bufout,lntrhd,SZLNHD,itr,BC,
     1               nsamp,nbytes,type1,type2,mgath,nli,ndi,
     2               s(l_ugather),s(l_usum),s(l_udenom),
     3               s(l_weight),s(l_xoff),s(l_taper),s(l_icount),
     4               power,ic,icc,irec,ngath,ntpr,ifmt_CDPBCX,
     5               hbegin,luin,luout,lerr,verbos,ifmt_CDPBCY,
     6               semb,semwt,snorm,dwgt,l_CDPBCX,ln_CDPBCX,ln_CDPBCY,
     7               d1neg,d2neg,d1pos,d2pos,l_SrRcMX,l_SrRcMY,l_CDPBCY,
     8               l_FlReFN,l_ToStUn,l_ToTmAU,l_RecNum,l_TrcNum,
     9               l_RecInd,l_DphInd,l_SrcLoc,l_SrcPnt,
     a               l_StaCor,l_DstSgn,l_LinInd,l_SoPtNm,ln_SrRcMX,
     8               ln_FlReFN,ln_ToStUn,ln_ToTmAU,ln_RecNum,ln_TrcNum,
     9               ln_RecInd,ln_DphInd,ln_SrcLoc,ln_SrcPnt,
     a               ln_StaCor,ln_DstSgn,ln_LinInd,ln_SoPtNm,ln_SrRcMY,
     8               ifmt_FlReFN,ifmt_ToStUn,ifmt_ToTmAU,ifmt_RecNum,
     9               ifmt_TrcNum,ifmt_RecInd,ifmt_DphInd,ifmt_SrcLoc,
     a               ifmt_SrcPnt,ifmt_StaCor,ifmt_DstSgn,
     b               ifmt_LinInd,ifmt_SoPtNm,ifmt_SrRcMX,ifmt_SrRcMY,
     c  ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,
     d  ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     d  ifmt_FoldNm,l_FoldNm,ln_FoldNm)

10000 continue

c-------------------------------------------
c     Close files and end program
c-------------------------------------------
      call lbclos(luin)
      call lbclos(luout)

      write(lerr,*)'Normal completion of routine STACK3D'
      close(lerr)  
      write(ler,*)'Normal completion of routine STACK3D'

      call exit(0)
      end


c-------------------------------------------
c        online help
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     1 '***************************************************************'
         write(LER,*)
     1 'Run this program by typing: stack3d and the following arguments'
         write(LER,*) ' '
         write(LER,*)
     1 ' -N[ntap]    (no default)      : Input data file name'
         write(LER,*)
     1 ' -O[otap]    (no default)      : Output data file name'
         write(LER,*)
     1 ' -d2neg[d2neg] far distance  - negative side of spread (-ve #)'
         write(LER,*)
     1 ' -d1neg[d1neg] near distance - negative side of spread (-ve #)'
         write(LER,*)
     1 ' -d1neg[d1neg] near distance - positive side of spread'
         write(LER,*)
     1 ' -d2neg[d2neg] far distance  - positive side of spread'

         write(LER,*)
     1 ' -pw[power] nth root power (default = 1.0)'
         write(LER,*) ' '
         write(LER,*)
     1 ' -H        if present, weight stack with hamming taper'         
         write(LER,*)
     1 ' -B        if present, weight stack with blackman taper'         
         write(LER,*)
     1 ' -D        if present, weight stack with receiver offset'        
         write(LER,*)
     1 ' -swt      if present, weight stack with semblance'      
         write(LER,*)
     1 ' -sem      if present, output semblance'
         write(LER,*)
     1 ' -S        if present, gen weights to reflect live traces' 
     2             //' in the gather (same for all times)'
         write(LER,*)
     1 ' -L        if present, gen weights to reflect live samples'
     2             //' at each time'
         write(LER,*)
     1 ' -BC       if present, compute CDP XYs from S/R XYs'
         write(LER,*)
     1 ' -V  Verbose mode.  All command line and lineheader parameters'
         write(LER,*)
     1 '                    printed to standard error output'
         write(LER,*) ' '
         write(LER,*)
     : 'USAGE:  ' 
         write(LER,*)
     : 'stack3d -N[ntap] -O[otap] -d2neg[] -d1neg[] -d1pos[] -d2pos[]'
         write(LER,*)
     : '       [-H -B -D -sem -swt -L -BC  -V]'
         write(LER,*)
     1 '***************************************************************'

      return
      end

      subroutine cmdln(d1pos,d2pos,d1neg,d2neg,
     1                 power,semb,semwt,verbos,
     2                 tnorm,snorm,dwgt,blackman,hamming,BC)
c-----
c     get command arguments
c
c    d1pos  - R      min distance to stack (positive side of spread)
c    d2pos  - R      max distance to stack (negative side of spread)
c    d1neg  - R      min distance to stack (positive side of spread)
c    d2neg  - R      max distance to stack (negative side of spread)
c     power  - R      take nth nth root, stack, then nth power
c   snorm   - L      normalize stacked trace by # live samples
c    semb   - L      output semblance
c    semwt  - L      output semblance weghted stack
c    verbos - L      verbose output or not
c-----
#include <f77/iounit.h>
      integer   argis
      real      d1pos,d2pos,d1neg,d2neg,power
      logical   semb,semwt,verbos
      logical   dwgt,blackman,hamming,snorm,tnorm,BC
c----------------------------------------------------------------------------
c        ARGXXX has parameters
c             ( flag, variable name, default value, format error value )
c-----------------------------------------------------------------------------
      call ARGR4  ('-d2neg', d2neg, -99999., -99999.)
      call ARGR4  ('-d1neg', d1neg, -00000., -00000.)
      call ARGR4  ('-d1pos', d1pos,  00000.,  00000.)
      call ARGR4  ('-d2pos', d2pos,  99999.,  99999.)
      call ARGR4  ('-pw', power, 1.0, 1.0)
 
      BC    = ( argis ('-BC') .gt. 0 )
      tnorm = ( argis ('-S') .gt. 0 )
      snorm = ( argis ('-L') .gt. 0 )
      semb  = ( argis ('-sem') .gt. 0 )
      semwt = ( argis ('-swt') .gt. 0 )
      dwgt  = ( argis ('-D') .gt. 0 )
      blackman=( argis ('-B') .gt. 0 )
      hamming=( argis ('-H') .gt. 0 )

      ierror=0

      if (power .eq. 0.0) power = 1.0

      noption=0
      if(semb) noption=noption+1
      if(semwt) noption=noption+1
      if(power .ne. 1.) noption=noption+1
      if(blackman) noption=noption+1
      if(hamming) noption=noption+1
c
      if(noption .gt. 1) then
         write(lerr,*) 'command line error in routine STACK3D!'
         write(lerr,*) 'can only invoke one of the following options:'
         write(lerr,'(a10,l10)') '-sem',semb,'-swt',semwt,
     1                     '-B',blackman,'-H',hamming
         write(lerr,'(a10,f10.1)') '-pw',power           
         write(lerr,*) 'number of options chosen = ',noption
         ierror=ierror+1
      endif
 
      verbos = ( argis ('-V') .gt. 0 )
c---------------------------------------------
c     check range limiting parameters
c---------------------------------------------
      if(d1neg .lt. d2neg) then
        write(LERR,*)'d1neg should be near range negative side of spread
     1(a -ve number)'
        write(LERR,*)'d2neg should be far range negative side of spread
     1(a -ve number)'
        write(LERR,*)'Check command line arguments & rerun'
        ierror=ierror+1
      endif
      if(d1pos .gt. d2pos) then
        write(LERR,*)'d1pos should be near range '
     1                //'positive side of spread'
        write(LERR,*)'d2pos should be far range '                       
     1                //'positive side of spread'
        write(LERR,*)'Check command line arguments & rerun'
        ierror=ierror+1
      endif
c
      if(ierror .ne. 0) then
         write(lerr,*) 'routine STACK3D aborted due to ',ierror,
     1                 ' command line errors!'
         call exit(666)
      endif

      return
      end
