C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lanmrk (lupik, times, IX1, IY1,
     1                   XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI, minli, maxli,
     3                   mindi, maxdi, xyscl, notrp, vverbos, RC,
     4                   verbos, lidel, didel, noedge)

#include <f77/iounit.h>

      real        times (ndi, nli)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     minli, maxli, mindi, maxdi, li, di
      integer     limin, limax, dimin, dimax, lidel, didel
      character   card * 80
      logical     verbos, vverbos, notrp, RC, noedge

         do  j = 1, nli
             do  i = 1, ndi
                 times (i,j) = 0.
             enddo
         enddo

      limin =  9999999
      limax = -9999999
      dimin =  9999999
      dimax = -9999999
      timin =  9999999.
      timax = -9999999.

C**********************************************************************C
C     read input workstation pick file
C**********************************************************************C
      il = 0
      nl = 0
      lc = 0
      DO while (1.eq.1)
 
         read (lupik, '(a80)', end=10, err=666) card
 
         go to 12
10       continue
 
         if (il .eq. 0) then
           write(LERR,*)' '
           write(LERR,*)'ERROR in tim2hed3d:'
           write(LERR,*)'Hit end of file without reading any picks'
           write(LERR,*)'within survey coordinates'
           write(LER ,*)' '
           write(LER ,*)'ERROR in tim2hed3d:'
           write(LER ,*)'Hit end of file without reading any picks'
           write(LER ,*)'within survey coordinates'
           stop 666
         else
           write(LERR,*)' '
           write(LERR,*)'Return from LandMark file reader:'
           write(LERR,*)'Found ',il,' picks within survey coordinates'
           go to 999
         endif

12       continue
 
         nl = nl + 1
         lc = lc + 1

         call fsscnf (card,'%f %f %f %f %f',
     1                aline,xline,CX,CY,time)
         IWRN = 0
 
         if ( RC ) then
            LI = (aline - float(minli)) / float(lidel) + 1
            DI = (xline - float(mindi)) / float(didel) + 1
            CX = aline
            CY = xline
            IF (LI .LT.     1) IWRN = 1
            IF (LI .GT.   NLI) IWRN = 1
            IF (DI .LT.     1) IWRN = 1
            IF (DI .GT.   NDI) IWRN = 1
         else
            CX = xyscl * CX
            CY = xyscl * CY
            CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                   IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI)
            IF (LI .LT. MINLI) IWRN = 1
            IF (LI .GT. MAXLI) IWRN = 1
            IF (DI .LT. MINDI) IWRN = 1
            IF (DI .GT. MAXDI) IWRN = 1
         endif

            IF (IWRN .eq. 0) THEN

               il = il + 1
               if ( RC ) then
                  jj = LI
                  ii = DI
               else
                  jj = LI - minli + 1
                  ii = DI - mindi + 1
               endif
               times (ii, jj) = nint ( time )
               if (LI .le. limin) limin = LI
               if (LI .ge. limax) limax = LI
               if (DI .le. dimin) dimin = DI
               if (DI .ge. dimax) dimax = DI
               if (time .le. timin) timin = time
               if (time .ge. timax) timax = time

               if ( verbos ) then
               ICX = CX
               ICY = CY
               itime = time
               write(LERR,777)ICX,ICY,itime,LI,DI
777            format('Line ',3(i8,2x),' LI/DI= ',2(i8,2x),
     1         ' inside survey bdry')
               endif

            ELSE

               if ( vverbos ) then
               ICX = CX
               ICY = CY
               itime = time
               write(LERR,778)ICX,ICY,itime,LI,DI
778            format('Line ',3(i8,2x),' LI/DI= ',2(i8,2x),
     1         ' out of survey bdry')
               endif

            ENDIF
 
      ENDDO

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in tim2hed3d:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nl,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in tim2hed3d:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nl,' line was:',card
 
999   continue

      write(LERR,*)' '
      write(LERR,*)'Minimum LI read from horizon file = ',limin
      write(LERR,*)'Maximum LI read from horizon file = ',limax
      write(LERR,*)'Minimum DI read from horizon file = ',dimin
      write(LERR,*)'Maximum DI read from horizon file = ',dimax
      write(LERR,*)'Minimum time read from horizon file = ',timin
      write(LERR,*)'Maximum time read from horizon file = ',timax
      write(LERR,*)' '

      write(LER,*)'notrp, noedge= ',notrp,noedge
	
      if (notrp) then
          write(LERR,*)'No horizon file interpolation'
          write(LER ,*)'No horizon file interpolation'
          return
      else
          write(LERR,*)'Horizon file interpolation of zeros'
          write(LER ,*)'Horizon file interpolation of zeros'
      endif

      if ( noedge ) then
         write(LERR,*)'Interpolating out to survey edges'
         write(LER ,*)'Interpolating out to survey edges'
         call trp2d (1, nli, 1, ndi, nli, ndi, times)
      else
         write(LERR,*)'No interpolation out to survey edges'
         write(LER ,*)'No interpolation out to survey edges'
         call trp2de (1, nli, 1, ndi, nli, ndi, times)
      endif

c     do  j = 1, nli
c     do  i = 1, ndi
c         write(20,*)i,j,times (i,j)
c     enddo
c     enddo
c     if (nli .gt. 0) stop

      return
      end
