C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----
c   build matrix of times (nli by ndi) from the times read
c   from the pick file (that fall within the given coords)
c----
      subroutine timmat (lupik, minli, maxli, mindi, maxdi, nli, ndi,
     1                   IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, times, xyscl, nsi, notrp, vverbos, xsd,
     3                   QC, RC, verbos, lidel, didel, noedge, luqc,
     4                   QCUSP, luusp, lbyout, itr, SZSMPD, SZTRHD,
     5                   HSTOFF, SZHFWD, ITHWP1, smooth, fit, ftap, usp,
     6                   ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     7                   ifmt_RecNum,l_RecNum,ln_RecNum,tscl)


      character ftap*(*)
      real      times (ndi, nli)
      real      DX, DY, tscl
      real * 8  XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer   lupik, minli, maxli, mindi, maxdi, nli, ndi
      integer   IX1, IY1, lidel, didel
      integer   luqc
      integer   itr(*)
      integer   luusp, lbyout, SZSMPD, SZTRHD, HSTOFF, SZHFWD
      integer   obytes, ITHWP1
      logical   verbos, vverbos, notrp, xsd, QC, QCUSP, RC, noedge
      logical   smooth, fit, usp

      rewind lupik

      if (xsd) then
              call xsd_xy (lupik, nsi, nf, times, IX1, IY1,
     1                     XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                     DX, DY, NDI, NLI, minli, maxli,
     3                     mindi, maxdi, xyscl, notrp, verbos,
     4                     lidel, didel, RC, noedge)

      elseif (usp) then

              call usp_xy (lupik, nsi, nf, times,
     2                     NDI, NLI, minli, maxli,
     3                     mindi, maxdi, xyscl, notrp, verbos,
     4                     lidel, didel, RC, noedge)

      else

              call lanmrk (lupik, times, IX1, IY1,
     1                     XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                     DX, DY, NDI, NLI, minli, maxli,
     3                     mindi, maxdi, xyscl, notrp, vverbos, RC,
     4                     verbos, lidel, didel, noedge)
      endif

      do  J = 1, NLI
          do  I = 1, NDI
              times (I,J) = tscl * times (I,J)
          enddo
      enddo

      IF (QC) THEN
         open (luqc,file=ftap,status='unknown')
         do  j = 1, nli
         do  i = 1, ndi
            write(luqc,*)j,i,times(i,j)
         enddo
         enddo
         if (.not. smooth .AND. .not. fit) close (luqc)

      ELSEIF (QCUSP) THEN
         obytes = SZTRHD + ndi * SZSMPD
         nrec   = 1
         unitsc = 1
         itscl  = tscl
         if (smooth .or. fit) nrec = 2
         call savew( itr, 'NumTrc',  nli  , 0)
         call savew( itr, 'NumRec', nrec  , 0)
         call savew( itr, 'SmpInt',    1  , 0)
         call savew( itr, 'NumSmp',   ndi , 0)
         call savew( itr, 'Format',     3 , 0)
         call savew( itr, 'UnitSc', unitsc, 0)
         call savew( itr, 'T_Unit', itscl , 0)
         obytes = SZTRHD + SZSMPD * ndi
         lbytes = HSTOFF
         nbyt = 2 * SZHFWD
         call savew( itr, 'HlhEnt',  0   , 0)
         call savew( itr, 'HlhByt', nbyt , 0)
         call savhlh( itr, lbytes, lbyout )
         call wrtape (luusp, itr, lbyout)
         call savew2 (itr,ifmt_RecNum,l_RecNum,ln_RecNum,1,1)
         DO  J = 1, nli
             call vmov (times(1, J), 1, itr(ITHWP1), 1, ndi)
             call savew2 (itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,J,1)
             call wrtape (luusp, itr, obytes)
         ENDDO
         if (.not. smooth .AND. .not. fit) call lbclos (luusp)
      ENDIF

      return
      end

