C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine timmod (nli, ndi, nf, filter, times, work, QC, diff,
     1                   smooth, fit, iord, irtype, ilim, luqc,
     2                   QCUSP, luusp, lbyout, itr, SZSMPD, SZTRHD,
     3                   HSTOFF, SZHFWD, ITHWP1,
     4                   ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     5                   ifmt_RecNum,l_RecNum,ln_RecNum)

#include <f77/iounit.h>

      real     filter (nf*nf), times (ndi, nli), work (ndi, nli)
      integer  nli, ndi, nf, SZSMPD, luqc

      
      real*8   space, trace, sample, ampls
      pointer  (wkspace, space (1))
      pointer  (wkampls, ampls (1))
      pointer  (wktrace, trace (1))
      pointer  (wksample, sample (1))
      integer  irtype,limord,ndf1(14),ndf2(14),ndf3,minord
      integer  if1max,ifumax,ipoly,ilim,ierr,itrial(14)

      real*8   coef(680),reg(14),ssr(14),ssd(14),sst,f1(14)
      real*8   delta

      integer  itr(*)
      integer  luusp, lbyout, SZTRHD, HSTOFF, SZHFWD
      integer  obytes, ITHWP1
      logical  QC, QCUSP, fit, smooth, diff


      IF (fit) THEN

         delta = 1.0d-6

         item  = 2 * nli * ndi + 2
         items = 2 * item + 680 * 2

         call galloc (wkspace,  items * SZSMPD, ierr1, iab)
         call galloc (wkampls,  item  * SZSMPD, ierr1, iab)
         call galloc (wktrace,  item  * SZSMPD, ierr2, iab)
         call galloc (wksample, item  * SZSMPD, ierr3, iab)
         if (ierr1.ne.0 .or. ierr2.ne.0 .or. ierr3.ne.0) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR'
            write(LERR,*)'Unable to allocate workspace (tim2hed3d):'
            write(LERR,*)items * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'FATAL ERROR'
            write(LER ,*)'Unable to allocate workspace (tim2hed3d):'
            write(LERR,*)items * SZSMPD,'  bytes'
            write(LER ,*)item * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            stop
         endif

         ic = 0
         do  j = 1, nli
             do  i = 1, ndi
                 ic = ic + 1
                 sample (ic) = dble (i)
                 trace  (ic) = dble (j)
                 ampls  (ic) = dble (times(i,j))
             enddo
         enddo
         nlidi = nli * ndi

         limord = 14
         isord  = iord

         call rob3sb(Trace,Sample,ampls,nlidi,irtype,limord,
     1               coef,reg,ssr,ssd,sst,ndf1,ndf2,ndf3,f1,minord,
     2               if1max,ifumax,ipoly,ilim,delta,ierr,itrial,
     3               space,isord)

         write(LERR,*)' '
         write(LERR,*)'Fit completed:'
         write(LERR,*)'min significant order  = ',minord
         write(LERR,*)'max significant order  = ',ifumax
         write(LERR,*)'recommended surf order = ',ipoly
         write(LERR,*)' '
         if (QC) then
            write(LER,*)' '
            write(LER,*)'Fit completed:'
            write(LER,*)'min significant order  = ',minord
            write(LER,*)'max significant order  = ',ifumax
            write(LER,*)'recommended surf order = ',ipoly
            write(LER,*)' '
         endif
         if (ipoly .eq. 0) then
            write(LER,*)'FATAL ERROR in tim2hed3d surface fit:'
            write(LER,*)'Something bad happened in the fit, ierr= ',
     1      ierr
            write(LER,*)'ierr=1: insufficient data points to fit'
            write(LER,*)'ierr=2: no significant polynomial relationship 
     1found'
            stop 666
         endif

         iloc = ipoly*(ipoly+1) * (ipoly +2)/6

         call surfgen (ipoly,coef(iloc),ndi,nli,work)

         call gfree (wkspace)
         call gfree (wkampls)
         call gfree (wktrace)
         call gfree (wksample)

      ELSEIF (smooth) THEN

         nfc = nf / 2 + 1

         DO  IY = 1, nli
             DO  IX = 1, ndi

                 ic = 0
                 do  j = 1, nf
                 do  i = 1, nf
 
                     IYj = IY - nfc + j
                     IXi = IX - nfc + i

                     if (IYj .ge. 1 .AND. IYj .le. nli .AND.
     1                   IXi .ge. 1 .AND. IXi .le. ndi)     then
                         amp = times (IXi, IYj)
                         if (amp .ne. 0.0) then
                            ic = ic + 1
                            filter (ic) = amp
                         endif
                     endif
                enddo
                enddo
 
                if (ic .gt. 1) then
                   call median (filter, ic, xmed)
                elseif (ic .eq. 1) then
                   xmed = filter (1)
                else
                   xmed = 0.
                endif

                work (IX,IY) = xmed
 
             ENDDO
         ENDDO


      ENDIF

      IF (diff) THEN
         do  j = 1, nli
         do  i = 1, ndi
            times (i,j) = times (i,j) - work (i,j)
         enddo
         enddo
      ELSE
         do  j = 1, nli
         do  i = 1, ndi
            times (i,j) = work (i,j)
         enddo
         enddo
      ENDIF

      IF (QC) THEN
         write(luqc,777)
777      format(/)
         do  j = 1, nli
         do  i = 1, ndi
            write(luqc,*)j,i,times (i,j)
         enddo
         enddo
         close (luqc)
      ELSEIF (QCUSP) THEN
         obytes = SZTRHD + ndi * SZSMPD
         call savew2 (itr,ifmt_RecNum,l_RecNum,ln_RecNum,2,1)
         DO  J = 1, nli
             call vmov (times(1, J), 1, itr(ITHWP1), 1, ndi)
             call savew2 (itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,J,1)
             call wrtape (luusp, itr, obytes)
         ENDDO
         call lbclos (luusp)
      ENDIF


      return
      end
