C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE vfilt3da
C**********************************************************************C
C
C vfilt3da reads the frequency sliced data [ as output by fftpack ] , 
c transforms it, filters using a variety of velocity, azimuth and frequency
c parameters with tapers , and does the inverse transform.
C
c Author P.G.A. Garossino [original code D. Yanchak]
c
c - Added FFTW routines B.E. Helvey
c command line upgrades:
c
c     -v1     ...........             In all cases the taper occurs between
c     -v2    .           .            the 1 --> 2  and 3 --> 4 parameters with      
c     -v3   .             .           full pass or reject between 2 --> 3
c     -v4  .               .     
c          1  2         3  4
c
C
c     -a1     ...........             [v] specifies conic velocity
c     -a2    .           .            [a] aperture azimuth in kx,ky [0 is North]
c     -a3   .             .           [f] specifies temporal frequency
c     -a4  .               .     
c          1  2         3  4
c
C
c     -f1     ...........
c     -f2    .           .                  
c     -f3   .             .       
c     -f4  .               .     
C
c          1  2         3  4
c
c
C
c     -r1     ...........           This radial stuff is heavily dispersive and is
c     -r2    .           .          an experimental wild ass Garossino Scheme only at
c     -r3   .             .         present.  If it proves usefull it will be advertised
c     -r4  .               .        to the user.
C
c          1  2         3  4
c
c
c     -dt if present defines temporal sample interval in dataset going into fftpack
c
c     -dz if present indicates that input dataset is DEPTH and all other parameters
c         should be treated appropriately
c
c     -pass if present pass data as defined rather than reject.
c
c     if no variable is explicitly defined on the command line that option is left
c     wide open.  [i.e.  if no -a parameters ALL azimuths are passed or rejected.
c
c CHANGES:
c
c     Jun 9, 1998: fixed -dz option to use meters or feet not kilofeet.  This allows
c                  velocity parameterization to use 1 / tan(deg) with steepest angle
c                  from the horizontal going into v1 and shallowest into v4.
c     Garossino
c
c     May 20,1998: fixed -pass option when using only -v3 -v4. The code would not
c                  pass anything as the taper logic was buggered for this one instance.
c     Garossino
c
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c Standard USP variable

      integer lhed(SZLNHD)
      integer luin, luout, nbytes, obytes, argis
      integer nsamp, nsi, nrec, ntrc, iform, lbytes
      integer nsampo, ntrco, lbyout
      
      character   name * 8, ntap * 255, otap * 255

      logical verbos

c variables used with dynamic memory allocation

      integer errcd1, errcd2, errcd3 
      integer abort, itemHeader, itemSpace
      integer headers

      real work

      complex Cwork

      pointer ( wkadr1, headers(1) )
      pointer ( wkadr2, work(1) )
      pointer ( Cwkadr, Cwork(1) )

c mixed radix stuff.  Here we must carry sine and cosine tables
c for the forward and reverse transforms separately.  This will
c prevent us from having to continually calculate them.  A lot
c of overhead.  I hope the memory efficiencies are worth it.

      integer  ipwrx (4), ipwry (4)
      integer  forward_initx, forward_inity
      integer  inverse_initx, inverse_inity

      integer  nfftxmin, nfftymin
      integer lenitabx, lenitaby, lenrtabx, lenrtaby

c mixed radix dynamic memory stuff

      integer errcd4, errcd5, errcd6, errcd7
      integer errcd8, errcd9, errcd10, errcd11
      integer forward_itabx, forward_itaby, inverse_itabx, inverse_itaby

      real  forward_rtabx, forward_rtaby, inverse_rtabx, inverse_rtaby

      pointer     (wkfitabx, forward_itabx(1))
      pointer     (wkfitaby, forward_itaby(1))
      pointer     (wkfrtabx, forward_rtabx(1))
      pointer     (wkfrtaby, forward_rtaby(1))
      pointer     (wkiitabx, inverse_itabx(1))
      pointer     (wkiitaby, inverse_itaby(1))
      pointer     (wkirtabx, inverse_rtabx(1))
      pointer     (wkirtaby, inverse_rtaby(1))

c non-standard keyword variables used on the command line

      real      v1, v2, v3, v4
      real      a1, a2, a3, a4
      real      a1_sym, a2_sym, a3_sym, a4_sym
      real      f1, f2, f3, f4, Exponent
      real      dt, dz

      logical   pass

c program dependant variables

      integer NextPowerOf2, size, JJ, KK, KX, KY
      integer RecNum, l_RecNum, ifmt_RecNum, ln_RecNum
      integer nslices
      integer trndx, hdrndx
      integer ordfft, ifreq, nfreq

      real    pi, deltaF, factor, delta_Kx, delta_Ky, dkx, dky
      real    vel, Azimuth, radius
      real    Taper, Ataper, Vtaper, Ftaper, Rtaper, freq

c initialize variables

      data  nbytes / 0 /
      data  lbytes / 0 /
      data  abort / 0 /
      data  name/'VFILT3DA'/
      pi =  4. * atan(1.0)
      data pass/.false./

C get help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

C read command line parameters

      call cmdln ( ntap, otap, dt, dx, dy, dz, v1, v2, v3, v4, 
     :     a1, a2, a3, a4, f1, f2, f3, f4, Exponent, r1, r2, r3, r4, 
     :     pass, verbos )

c Define symetrical filter points

      a1_sym = a1 + 180.
      a2_sym = a2 + 180.
      a3_sym = a3 + 180. 
      a4_sym = a4 + 180.

c watch out for wrap-around
      
      if ( a1_sym .ge. 360.0 ) a1_sym = a1_sym - 360.
      if ( a2_sym .gt. 360.0 ) a2_sym = a2_sym - 360.
      if ( a3_sym .gt. 360.0 ) a3_sym = a3_sym - 360.
      if ( a4_sym .gt. 360.0 ) a4_sym = a4_sym - 360.

c Policemen

      if ( v1 .gt. v2 .or. v3 .gt. v4 ) then
         write(LERR,*)' Error: v1, v2, v3, v4 must be increasing'
         write(LERR,*)'        Here is what I got off the command line'
         write(LERR,*)'        v1 = ',v1
         write(LERR,*)'        v2 = ',v2
         write(LERR,*)'        v3 = ',v3
         write(LERR,*)'        v4 = ',v4
         write(LERR,*)'  '
         write(LERR,*)' Fatal  '
         write(LER,*)' VFILT3DA: v1, v2, v3, v4 must be increasing'
         write(LER,*)'          Here is what I got off the command line'
         write(LER,*)'          v1 = ',v1
         write(LER,*)'          v2 = ',v2
         write(LER,*)'          v3 = ',v3
         write(LER,*)'          v4 = ',v4
         write(LER,*)'  '
         write(LER,*)' Fatal  '
         stop

      elseif ( a1 .gt. a2 .or. a3 .gt. a4 ) then

c do not allow tapering across the 0/360 boundary as there is no
c logic in this routine to allow this.  The logic required to allow
c this would be volumnuous.  I think that the average user can just
c move his/her taper to one side or the other of the boundary.

         write(LERR,*)' '
         write(LERR,*)' Error: You have defined a taper that crosses '
         write(LERR,*)'        the 0/360 boundary.  Vfilt3da cannot '
         write(LERR,*)'        handle this situation.  Resubmit with '
         write(LERR,*)'        your taper on one side or the other of'
         write(LERR,*)'        the boundary.  Current parameters are:'
         write(LERR,*)'        a1 = ',a1
         write(LERR,*)'        a2 = ',a2
         write(LERR,*)'        a3 = ',a3
         write(LERR,*)'        a4 = ',a4
         write(LERR,*)'  '
         write(LERR,*)' Fatal  '
         write(LER,*)' '
         write(LER,*)' VFILT3DA: Error: You have defined a taper that '
         write(LER,*)'        crosses  the 0/360 boundary.  Vfilt3da '
         write(LER,*)'        cannot  handle this situation.  Resubmit'
         write(LER,*)'        with your taper on one side or the other '
         write(LER,*)'        of the boundary.  Current values are:'
         write(LER,*)'        a1 = ',a1
         write(LER,*)'        a2 = ',a2
         write(LER,*)'        a3 = ',a3
         write(LER,*)'        a4 = ',a4
         write(LER,*)'  '
         write(LER,*)' Fatal  '
         stop
      elseif( a1_sym .gt. a2_sym .or. a3_sym .gt. a4_sym ) then
         write(LERR,*)' '
         write(LERR,*)' Error: You have defined a taper that crosses '
         write(LERR,*)'        the 0/360 boundary.  Vfilt3da cannot '
         write(LERR,*)'        handle this situation.  Resubmit with'
         write(LERR,*)'        your taper on one side or the other of'
         write(LERR,*)'        the boundary.  Current parameters are:'
         write(LERR,*)'        a1 = ',a1
         write(LERR,*)'        a2 = ',a2
         write(LERR,*)'        a3 = ',a3
         write(LERR,*)'        a4 = ',a4
         write(LERR,*)'        a1 symmetrical = ',a1_sym
         write(LERR,*)'        a2 symmetrical = ',a2_sym
         write(LERR,*)'        a3 symmetrical = ',a3_sym
         write(LERR,*)'        a4 symmetrical = ',a4_sym
         write(LERR,*)'  '
         write(LERR,*)' Fatal  '
         write(LER,*)' '
         write(LER,*)' VFILT3DA: Error: You have defined a taper that '
         write(LER,*)'        crosses  the 0/360 boundary.  Vfilt3da '
         write(LER,*)'        cannot  handle this situation.  Resubmit'
         write(LER,*)'        with your taper on one side or the other '
         write(LER,*)'        of the boundary.  Current values are:'
         write(LER,*)'        a1 = ',a1
         write(LER,*)'        a2 = ',a2
         write(LER,*)'        a3 = ',a3
         write(LER,*)'        a4 = ',a4
         write(LER,*)'        a1 symmetrical = ',a1_sym
         write(LER,*)'        a2 symmetrical = ',a2_sym
         write(LER,*)'        a3 symmetrical = ',a3_sym
         write(LER,*)'        a4 symmetrical = ',a4_sym
         write(LER,*)'  '
         write(LER,*)' Fatal  '
         stop
      elseif ( f1 .gt. f2 .or. f3 .gt. f4 ) then
         write(LERR,*)' Error: f1, f2, f3, f4 must be increasing'
         write(LERR,*)'        Here is what I got off the command line'
         write(LERR,*)'        f1 = ',f1
         write(LERR,*)'        f2 = ',f2
         write(LERR,*)'        f3 = ',f3
         write(LERR,*)'        f4 = ',f4
         write(LERR,*)'  '
         write(LERR,*)' Fatal  '
         write(LER,*)' VFILT3DA: f1, f2, f3, f4 must be increasing'
         write(LER,*)'          Here is what I got off the command line'
         write(LER,*)'          f1 = ',f1
         write(LER,*)'          f2 = ',f2
         write(LER,*)'          f3 = ',f3
         write(LER,*)'          f4 = ',f4
         write(LER,*)'  '
         write(LER,*)' Fatal  '
         stop
      elseif ( r1 .gt. r2 .or. r3 .gt. r4 ) then
         write(LERR,*)' Error: r1, r2, r3, r4 must be increasing'
         write(LERR,*)'        Here is what I got off the command line'
         write(LERR,*)'        r1 = ',r1
         write(LERR,*)'        r2 = ',r2
         write(LERR,*)'        r3 = ',r3
         write(LERR,*)'        r4 = ',r4
         write(LERR,*)'  '
         write(LERR,*)' Fatal  '
         write(LER,*)' VFILT3DA: r1, r2, r3, r4 must be increasing'
         write(LER,*)'          Here is what I got off the command line'
         write(LER,*)'          r1 = ',r1
         write(LER,*)'          r2 = ',r2
         write(LER,*)'          r3 = ',r3
         write(LER,*)'          r4 = ',r4
         write(LER,*)'  '
         write(LER,*)' Fatal  '
         stop
      endif

c open input and output datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c verify input dataset

      lbytes=0
      call rtape  ( luin, lhed, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'VFILT3DA: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence/permissions of file & rerun'
         stop
      endif

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
  
      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'OrNTRC', nslices, LINHED)
      call saver(lhed, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lhed, 'UnitSc', unitsc, LINHED)
      endif

c dt comes in on the command line in units of the dataset and is converted to
c seconds here

      if ( dz .lt. 1e-32 ) dt = dt * unitsc
     
c define byte size of output data trace

      obytes = SZTRHD + SZSMPD * nsamp

c get power of 2, 3, or 5 from input X & Y dimensions for mixed radix FFTs

      nfftxmin = 1.01 * nsamp
      nfftymin = 1.01 * ntrc

      call ncfft ( nfftxmin, 5, nsampo , ipwrx )
      call ncfft ( nfftymin, 5, ntrco , ipwry )
      
      nx    = nsampo
      nx2   = 2 * nsampo
      ny    = ntrco

c determine number of frequencies being used

      nfreq = nint ( 1.0 / (2. * dt ) )
      NextPowerOf2 = ordfft(nfreq)
      nfreq = 2 ** NextPowerOf2

c lengths of sine & cos tables 

      lenitabx = 2 * nsampo + 34
      lenrtabx = 2 * nsampo + 13
      lenitaby = 2 * ntrco + 34
      lenrtaby = 2 * ntrco + 13

c the following is the power of 2 stuff for fft.  I am commenting this 
c all out and using mixed radix fft.  If some time in the future I need
c power of 2 fft here it is.
c
c      NextPowerOf2 = ordfft(nsamp)
c      nsampo = 2 ** NextPowerOf2
c
c      NextPowerOf2 = ordfft(ntrc)
c      ntrco = 2 ** NextPowerOf2

      if(nsampo .gt. 8192) then
         write(LERR,*) 'VFILT3DA: Trace length too long to transform'
         write(LERR,*) '          Be sure next power of 2 is less than'
         write(LERR,*) '          8192 or contact the USP guys at ATTC'
         write(LERR,*) '          for a program change'
         write(LERR,*) 'Fatal'  
         write(LERR,*) ' '
      
         write(LER,*) 'VFILT3DA: Trace length too long to transform'
         write(LER,*) '          Be sure next power of 2 is less than'
         write(LER,*) '          8192 or contact the USP guys at ATTC'
         write(LER,*) '          for a program change'
         write(LER,*) 'Fatal'        
         write(LER,*) ' '
         stop
      endif
      
c dynamic memory allocation

      itemHeader = ntrco * ITRWRD * SZSMPD
      size = (ntrco+2) * 2 * (nsampo+2) 
      itemSpace = size  * SZSMPD
    
      call galloc (wkadr1, itemHeader, errcd1, abort)
      call galloc (wkadr2, itemSpace, errcd2, abort)
      call galloc (Cwkadr, itemSpace, errcd3, abort)
      call galloc (wkfitabx, lenitabx*SZSMPD, errcd4, abort)
      call galloc (wkfitaby, lenitaby*SZSMPD, errcd5, abort)
      call galloc (wkfrtabx, lenrtabx*SZSMPD, errcd6, abort)
      call galloc (wkfrtaby, lenrtaby*SZSMPD, errcd7, abort)
      call galloc (wkiitabx, lenitabx*SZSMPD, errcd8, abort)
      call galloc (wkiitaby, lenitaby*SZSMPD, errcd9, abort)
      call galloc (wkirtabx, lenrtabx*SZSMPD, errcd10, abort)
      call galloc (wkirtaby, lenrtaby*SZSMPD, errcd11, abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.  
     :     errcd3 .ne. 0 .or.  
     :     errcd4 .ne. 0 .or.  
     :     errcd5 .ne. 0 .or.  
     :     errcd6 .ne. 0 .or.  
     :     errcd7 .ne. 0 .or.  
     :     errcd8 .ne. 0 .or.  
     :     errcd9 .ne. 0 .or.  
     :     errcd10 .ne. 0 .or.  
     :     errcd11 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 2*itemSpace,' bytes'
         write(LERR,*) 2*lenitabx,' bytes'
         write(LERR,*) 2*lenitaby,' bytes'
         write(LERR,*) 2*lenrtabx,' bytes'
         write(LERR,*) 2*lenrtaby,' bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'VFILT3DA: Unable to allocate workspace:'
         write(LER,*) itemHeader,' bytes'
         write(LER,*) 2*itemSpace,' bytes'
         write(LER,*) 2*lenitabx,' bytes'
         write(LER,*) 2*lenitaby,' bytes'
         write(LER,*) 2*lenrtabx,' bytes'
         write(LER,*) 2*lenrtaby,' bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 2*itemSpace,' bytes'
         write(LERR,*) 2*lenitabx,' bytes'
         write(LERR,*) 2*lenitaby,' bytes'
         write(LERR,*) 2*lenrtabx,' bytes'
         write(LERR,*) 2*lenrtaby,' bytes'
         write(LERR,*)' '
      endif

c update HLH

      call hlhprt ( lhed , lbytes, name, 8, LERR )
  
c modify header as needed

      call savew ( lhed, 'NumSmp', nsamp, LINHED )
      call savew ( lhed, 'NumTrc', ntrc, LINHED )
      call savew ( lhed, 'NumRec', nrec, LINHED )
      call savhlh ( lhed, lbytes, lbyout )

C write out modified line header

      call wrtape(luout, lhed, lbyout)

c verbal printout

      call verbal( ntap, otap, nsamp, ntrc, nrec, dt, dx, dy, dz, 
     :     v1, v2, v3, v4, a1, a2, a3, a4, f1, f2, f3, f4, Exponent, 
     :     r1, r2, r3, r4, pass, verbos ) 

c the following assumes that the input to this routine is 
c frequency slices from dc to Nyquist in packed format from
c QTC rfft.  In this format the first slice is DC, the next
c Nyquist followed by pairs of real,imaginary slices.  Delta
c frequency in this case is Nyquist / 2*total number of slices


       deltaF = 1.0 / ( dt * float(nslices) )

       delta_Kx = 1.0 / ( float ( nsampo ) * dx )
       delta_Ky = 1.0 / ( float ( ntrco ) * dy ) 

c start processing frequency slices

c initialize mixed radix sine and cosine table building variables
c if set to unity the initial tables will be constructed

         forward_initx = 1
         forward_inity = 1
         inverse_initx = 1
         inverse_inity = 1

      DO JJ = 1, nrec

c clear workspace

         call vclr ( work, 1, size )

c load next record
         
         do KK = 1, ntrc

c set data and header index

            trndx = (KK-1) * 2 * nsampo + 1
            hdrndx = (KK-1) * ITRWRD + 1
            
            nbytes = 0
            call rtape ( luin, lhed, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            
c get frequency slice number from trace header of first trace only
            
            if ( KK .eq. 1 ) call saver2( lhed, ifmt_RecNum, l_RecNum, 
     :           ln_RecNum, RecNum, TRACEHEADER )

            call vmov ( lhed(ITHWP1), 1, work(trndx), 1, nsamp )
            call vmov ( lhed, 1, headers(hdrndx), 1, ITRWRD )
         enddo
            
c debug --> take a look at what is loaded
c         call look2D(work,2*nsampo,ntrco)

c do foward mixed radix 2d fft

         call vclr ( Cwork, 1, size )
         call fft2dee (work, nsamp, ntrc, nsampo, nsampo*2, ntrco, 
     :        lenitabx, lenrtabx, lenitaby, lenrtaby, 
     :        forward_rtabx, forward_rtaby, forward_itabx, 
     :        forward_itaby, Cwork, forward_initx, forward_inity)

c do the forward 2d fft 
c this is the fft stuff which I am commenting out but leaving in the code
c for future reference
c         call vclr ( Cwork, 1, size )
c         call fft2dee ( work, nsamp, ntrc, nsampo, 2*nsampo, ntrco, 
c     :        Cwork ) 

c debug --> take a look at the transform
c         call look2D(work,2*nsampo,ntrco)

c  calculate the frequency --> determine if in window otherwise zero everything
c  out. 
c 
c  remember that the first slice is frequency  = 0
c                the second slice is frequency = nyquist
c  the frequency for pairs of slices after that (records) is the same as they
c  represent the real and imaginary part from fftpack

         ifreq = (RecNum-1) / 2
         freq = float(ifreq) * deltaF
         if(RecNum.eq.2) freq = float(nrec/2) * deltaF 

c determine frequency taper if required

         Ftaper = 1.0

         if ( abs(f1) .gt. 1.e-30 .or.
     :        abs(f2) .gt. 1.e-30 .or. 
     :        abs(f3) .gt. 1.e-30 .or. 
     :        abs(f4) .gt. 1.e-30 ) then

            call Single_Taper ( freq, f1, f2, f3, f4, 1, pi, Ftaper )
         endif
         
c do azimuthal and / or velocity filtering as required

         IF ( abs(v1) .gt. 1.e-30 .or. 
     :        abs(v2) .gt. 1.e-30 .or. 
     :        abs(v3) .gt. 1.e-30 .or. 
     :        abs(v4) .gt. 1.e-30 .or.
     :        abs(a1) .gt. 1.e-30 .or. 
     :        abs(a2) .gt. 1.e-30 .or. 
     :        abs(a3) .gt. 1.e-30 .or. 
     :        abs(a4) .gt. 1.e-30 ) then
            
            do KY = 1, ntrco

               do KX = 1, nsampo

                  factor = 1.0

c determine trace index of this sample
                  
                  trndx = (KY-1) * 2 * nsampo + KX

c determine kx and ky for current sample, remember center of fftxy amplitude 
c display is at (nsamp/2, ntrc/2 + 1)

                  dkx = float( (nsampo / 2) - KX ) * delta_Kx

                  dky = float( (KY - 1) - (ntrco / 2) ) *  delta_Ky

c determine azimuth 

                  if ( abs(a1) .gt. 1.e-30 .or.
     :                 abs(a2) .gt. 1.e-30 .or.
     :                 abs(a3) .gt. 1.e-30 .or.
     :                 abs(a4) .gt. 1.e-30 ) then
                     
c determine azimuth of sample from origin, Azimuth at origin is flagged
c 999.99, if azimuth option is not specified and user wants radial
c symmetry Azimuth is flagged -999.99
                     
                     call GetAzimuth ( dkx, dky, pi, Azimuth )
                  else
                     Azimuth = -999.99
                  endif

c determine velocity if requested, if not requested vel is flagged
c -999.99

                  if ( abs(v1) .gt. 1.e-30 .or.
     :                 abs(v2) .gt. 1.e-30 .or.
     :                 abs(v3) .gt. 1.e-30 .or.
     :                 abs(v4) .gt. 1.e-30 )then

c determine frequency dependant velocity for this sample

                     call GetVelocity ( dkx, dky, freq, vel )
                  else
                     vel = -999.99
                  endif

c for the following if both vel and Azimuth are defined then both 
c boundary conditions must be examined, otherwise only one or the
c other need be considered.  If neither are set then the radial option
c is in place or we are at Kx = Ky = 0.0 and Taper can be set to unity.

c initialize velocity and azimuthal tapers

                  Vtaper = -999.99
                  Ataper = -999.99

c determine velocity taper

                  if ( vel .gt. 0.0 ) then
                     call Single_Taper ( vel, v1, v2, v3, v4, pass, 
     :                    pi, Vtaper )
                  endif

c determine azimuthal taper

                  if ( Azimuth .ge. 0.0 ) then
                     call Azimuth_Taper ( Azimuth, a1, a2, a3, a4, 
     :                    a1_sym, a2_sym, a3_sym, a4_sym, pass, 
     :                    pi, Ataper )
                  else
                     if (pass) Ataper = 1.0
                  endif

c ------------------------------
c determine combined taper value
c ------------------------------

                  IF (pass) then

                     Taper = 0.0

c radial mix required  
c    0.0 < Vtaper < 1.0 
c    0.0 < Ataper < 1.0

                     if ( ( Vtaper .gt. 1.e-30 .and. 
     :                    abs ( 1.0 - Vtaper ) .gt. 1.e-30 ) .and.
     :                    ( Ataper .gt. 1.e-30 .and.
     :                    abs ( 1.0 - Ataper ) .gt. 1.e-30 ) ) then

c the radial mix doesn't work in the pass case as you end up with the
c maximum taper [either V or A] dominating the mix in an inappropriate way.
c the following works quite well and is faster.

                        if ( Ataper .le. Vtaper ) then 
                           Taper = Ataper
                        else
                           Taper = Vtaper
                        endif


c Vtaper required
c 0.0 < Vtaper < = 1.0
c Ataper = 1.0

                     elseif ( ( abs(Ataper - 1.0 ) .le. 1.e-30 ) .and.
     :                       ( Vtaper .gt. 1.e-30 ) ) then  
                        Taper = Vtaper

c Ataper required
c Vtaper = 1.0
c 0.0 < Ataper < 1.0

                     elseif ( ( abs(Vtaper - 1.0 ) .le. 1.e-30 ) .and.
     :                       ( Ataper .gt. 1.e-30 .and.
     :                       abs ( 1.0 - Ataper ) .gt. 1.e-30 ) ) then
                        Taper = Ataper

c Taper = unity if
c Vtaper = 1.0
c Ataper = 1.0
                        
                     elseif  ( ( abs(Ataper - 1.0 ) .le. 1.e-30 ) .and.
     :                       ( abs(Vtaper - 1.0 ) .le. 1.e-30 ) ) then
                        Taper = 1.0
                     endif

                  ELSE

                     Taper = 1.0

c radial mix required  
c    0.0 < Vtaper < 1.0 
c    0.0 < Ataper < 1.0

                     if ( ( Vtaper .gt. 1.e-30 .and. 
     :                    abs ( 1.0 - Vtaper ) .gt. 1.e-30 ) .and.
     :                    ( Ataper .gt. 1.e-30 .and.
     :                    abs ( 1.0 - Ataper ) .gt. 1.e-30 ) ) then
                        Taper = ( Vtaper**2 + Ataper**2 ) ** 0.5

c Vtaper required
c 0.0 < Vtaper <= 1.0
c Ataper = 0.0

                     elseif ( ( Ataper .le. 1.e-30 ) .and.
     :                       ( Vtaper .gt. 1.e-30 ) ) then  
                        Taper = Vtaper

c Ataper required
c Vtaper = 0.0
c 0.0 < Ataper <= 1.0

                     elseif ( ( Vtaper .le. 1.e-30 ) .and.
     :                       ( Ataper .gt. 1.e-30 ) ) then
                        Taper = Ataper

c Taper = zero if
c Vtaper = 0.0
c Ataper = 0.0
                        
                     elseif ( ( Ataper .le. 1.e-30 ) .and.
     :                       ( Vtaper  .le. 1.e-30 ) ) then
                        Taper = 0.0
                     endif

                  ENDIF

c scale sample

                  factor = factor *  Taper  *  Ftaper
                  work(trndx) = work(trndx) * factor

               enddo
            enddo

         ELSEIF ( abs(r1) .gt. 1.e-30 .or.
     :            abs(r2) .gt. 1.e-30 .or.
     :            abs(r3) .gt. 1.e-30 .or.
     :            abs(r4) .gt. 1.e-30 )then

c this stuff is for testing dispersive type filters.  The users
c do NOT know this is here.  They do not know about the -r entries
c on the command line.  After I have fully tested the pros and cons
c of noise rejection using dispersive filters I will either turn
c this on or get rid of it.

            do KY = 1, ntrco
               do KX = 1, nsampo

                  factor = 1.0
                  
c determine trace index of this sample

                  trndx = (KY-1) * 2 * nsampo + KX

c determine kx and ky for current sample, remember center of fftxy amplitude 
c display is at (nsamp/2, ntrc/2 + 1)

                  dkx = float( (nsampo / 2) - KX ) * 
     :                 ( 1. / ( float(nsampo) * dx ) )
                  dky = float( (KY - 1) - ntrco / 2 ) * 
     :                 ( 1. / ( float(ntrco) * dy ) )

c do radial [dispersive] filtering [ this is experimental ]

                  radius = (dky**2 + dkx**2) ** 0.5

                  call Single_Taper ( radius, r1, r2, r3, r4, pass, pi, 
     :                 Rtaper )
           
                  factor = factor * Rtaper * Ftaper
                  work(trndx) = work(trndx) * factor

               enddo
            enddo
            
         ELSEIF ( abs(f1) .gt. 1.e-30 .or.
     :           abs(f2) .gt. 1.e-30 .or. 
     :           abs(f3) .gt. 1.e-30 .or. 
     :           abs(f4) .gt. 1.e-30 ) then

c do frequency tapering only, will only get here if none of the r's, a's or v's 
c have been included on the command line while the f's have been included

            do KY = 1, ntrco
               do KX = 1, nsampo

c determine trace index of this sample

                  trndx = (KY-1) * 2 * nsampo + KX
                  work(trndx) = work(trndx) * Ftaper
               enddo
            enddo
                  
         ENDIF

c debug --> take a look at the filtered transform
c         call look2D(work,2*nsampo,ntrco)

c inverse mixed radix 2D fft

          call vclr ( Cwork, 1, size )
          call fft2ree (work, nsamp, ntrc, nsampo, nsampo*2, ntrco,
     :         lenitabx, lenrtabx, lenitaby, lenrtaby,
     :         inverse_rtabx, inverse_rtaby, 
     :         inverse_itabx, inverse_itaby, Cwork, inverse_initx, 
     :         inverse_inity)

c Inverse fft2d 
c this stuff commented out but left for future reference
c         call vclr ( Cwork, 1, size )
c         call fft2ree ( work, nsamp, ntrc, nsampo, 2*nsampo, ntrco, 
c     :        Cwork )

c debug --> take a look at the result
c          call look2D(work,2*nsampo,ntrco)
         
c output the filtered data

         do KK = 1, ntrc
            trndx = (KK-1) * 2 * nsampo + 1
            hdrndx = (KK-1) * ITRWRD + 1
            call vmov ( headers(hdrndx), 1, lhed, 1, ITRWRD )
            call vmov ( work(trndx), 1, lhed(ITHWP1), 1, nsamp )
            call wrtape( luout, lhed, obytes)
         enddo

c go to next frequency slice

      ENDDO

c finished processing, close all attached files and terminate

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)' Normal Termination'
      write(LER,*)'VFILT3DA: Normal Termination'
      stop

 999  continue

c something abnormal occured, usually premature eof

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)' Abormal Termination'
      write(LER,*)'VFILT3DA: Abnormal Termination'
      stop
      END
