C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Build_Trace ( time_depth, velocity, nsi, npairs, 
     :     USP_trace, nsampo )

c routine to build a USP trace from an input velocity function.  The
c time_depth[] array contains npairs of sample values, the velocity[] array
c contains the corresponding npairs of velocity data.  The output trace
c is contained in the USP_trace[] array and is made up of nsampo 
c entries with a sample interval of nsi.
  
c declare variables passed from calling routine

      integer nsi, npairs, nsampo

      real time_depth(npairs), velocity(npairs), USP_trace(nsampo)

c declare local variables

      integer i, j

      real getvel, fac, Time

      DO i = 1, nsampo

c assign time from 1st sample at Time = zero to be compatible with
c ProMax, CogniSeis, Ilis, MBS, PPRED etc.

          Time  = float ( nsi * (i-1))
         
          if ( (Time - time_depth(1) ) .le. 1.e-4 ) then

c first velocity will be used from time zero down to and including 
c first function time

             getvel = velocity(1)
          elseif ( (Time - time_depth(npairs)) .ge. 1.e-4 ) then

c last velocity will be used from last function time to end of trace
c if not specified

             getvel = velocity(npairs)
          else

c do linear interpolation of velocity such that a given velocity will
c only appear at the time specified in the function.

             do j = 2, npairs

                if( ( Time - time_depth(j-1)) .ge. 1.e-4
     :               .and. (Time - time_depth(j)) .le. 1.e-4 ) then

                   fac = ( Time - time_depth(j-1) ) / 
     :                  ( time_depth(j) - time_depth(j-1) )

                   getvel = velocity(j-1) + fac * 
     :                  ( velocity(j) - velocity(j-1) )

                   go to 1002 
                endif
             enddo

          endif

 1002     continue

          USP_Trace(i) = getvel

       ENDDO
       
       return
       end
