C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************** 
C 
C     SUBROUTINE NAME: SRTIDX  (SORT INDEXES) 
C     ENTRY POINT:     SRTBUF  (SORT BUFFER) 
C 
C     LANGUAGE: FORTRAN 
C 
C     AUTHOR: ?.????? 
C 
C     DATE WRITTEN: ??/??/?? 
C 
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE 
C 
C     ABSTRACT: SORTS AN ARRAY OF NUMBERS IN INCREASING ORDER OF 
C               MAGNITUDE. THIS SUBROUTINE SORTS THE INDEXES 
C               POINTING TO THE ELEMENTS IN THE ARRAY ('SRTIDX'), 
C               OR SORTS THE ELEMENTS IN THE ARRAY ('SRTBUF'). 
C               SORTING IS PERFORMED USING THE "SHELL SORT". 
C 
C     CALLING SEQUENCE: CALL SRTIDX(ARRAY, INDEX, KOUNT) 
C                WHERE:    ARRAY - BUFFER OF NUMBERS TO BE SORTED 
C                          INDEX - BUFFER OF SORTED INDEXES POINTING 
C                                  TO "ARRAY" 
C                          KOUNT - NUMBER OF ELEMENTS IN "ARRAY" 
C                                  & "INDEX" 
C 
C     CALLING SEQUENCE: CALL SRTBUF(IBUF, ICOUNT) 
C                WHERE:   IBUF   - BUFFER OF NUMBERS TO BE SORTED 
C                         ICOUNT - NUMBER OF ELEMENTS IN "IBUF" 
C 
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE 
C 
C*********************************************************************** 
C 
C 
      SUBROUTINE SRTIDX(ARRAY, INDEX, KOUNT) 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C 
C 
C----------------------------------------------------------------------- 
C 
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS 
C 
C----------------------------------------------------------------------- 
C 
      REAL*4    ARRAY 
C 
      INTEGER INDEX 
      INTEGER IBUF 
C 
      DIMENSION ARRAY (KOUNT), INDEX (KOUNT) 
      DIMENSION IBUF  (    1) 
C 
C----------------------------------------------------------------------- 
C 
C     SET UP BUFFER OF INDEXES IF SORTING BY INDEXES 
C 
C----------------------------------------------------------------------- 
C 
      ITYPE             = 0 
C 
      DO 100 I = 1,KOUNT 
         INDEX(I)       = I 
  100 CONTINUE 
C 
      GO TO 150 
C 
C======================================================================= 
C 
C 
      ENTRY SRTBUF(IBUF, ICOUNT) 
C 
C 
C======================================================================= 
C 
C     SET FLAG FOR SORTING BUFFER EXACTLY 
C 
C----------------------------------------------------------------------- 
C 
      ITYPE             = 1 
      KOUNT             = ICOUNT 
C 
C----------------------------------------------------------------------- 
C 
C     PERFORM THE 'SHELL SORT' 
C 
C----------------------------------------------------------------------- 
C 
  150 CONTINUE 
C 
      N                 = KOUNT 
      M                 = N 
C 
  200 CONTINUE 
C 
      M                 = M / 2 
      IF(M .EQ. 0)        GO TO 600 
      K                 = N - M 
      J                 = 1 
C 
  300 CONTINUE 
C 
      I                 = J 
C 
  400 CONTINUE 
C 
C----------------------------------------------------------------------- 
C 
C     SORT THE INDEXES 
C 
C----------------------------------------------------------------------- 
C 
      IF(ITYPE           .NE.                 0) GO TO 410 
      IF(ARRAY(INDEX(I)) .LE. ARRAY(INDEX(I+M))) GO TO 500 
      ISAVE             = INDEX(I) 
      INDEX(I)          = INDEX(I+M) 
      INDEX(I+M)        = ISAVE 
      GO TO 450 
C 
C----------------------------------------------------------------------- 
C 
C     SORT THE BUFFER ELEMENTS 
C 
C----------------------------------------------------------------------- 
C 
  410 CONTINUE 
C 
      IF(IBUF(I) .LE. IBUF(I+M)) GO TO 500 
      ISAVE             = IBUF(I) 
      IBUF(I)           = IBUF(I+M) 
      IBUF(I+M)         = ISAVE 
C 
  450 CONTINUE 
C 
      I                 = I - M 
      IF(I .GE. 1)        GO TO 400 
C 
  500 CONTINUE 
C 
      J                 = J + 1 
C 
      IF(J .GT. K)        GO TO 200 
      GO TO 300 
C 
C----------------------------------------------------------------------- 
C 
C     THAT'S ALL -- RETURN TO CALLING ROUTINE 
C 
C----------------------------------------------------------------------- 
C 
  600 CONTINUE 
C 
      RETURN 
      END 
