C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c pick up command line arguments 

      subroutine cmdln ( trace_length, nsi, otap, ntap, cell_X, cell_Y, 
     :     minLI, minDI, maxLI, maxDI, LIincr, DIincr, tol, tdfn, name, 
     :     TrcNum_start, RecNum_start, delta_TrcNum, delta_RecNum, 
     :     Cosine, min_num_desired, vel_scalar, exponent, median,
     :     scoping, verbos )

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer trace_length, nsi, minLI, minDI, maxLI, maxDI
      integer LIincr, DIincr, RecNum_start, TrcNum_start
      integer min_num_desired, delta_TrcNum, delta_RecNum

      real    cell_X, cell_Y, tol, vel_scalar, exponent

      character  ntap*(*), otap*(*), name(*)

      logical tdfn, Cosine, median, scoping, verbos

c declare local variables

      integer argis

c initialize variables

      tdfn = .false.

c parse command line
 
      call argr4 ( '-cellx', cell_X, 0., 0. )
      call argr4 ( '-celly', cell_Y, 0., 0. )
      Cosine = ( argis('-C') .gt. 0 )

      call argi4 ( '-drec', delta_RecNum, 1, 1 )
      call argi4 ( '-dtrc', delta_TrcNum, 1, 1 )
      call argi4 ( '-ddi', DIincr, -9999, -9999 )
      call argi4 ( '-dli', LIincr, -9999, -9999 )
      call argi4 ( '-dt', nsi, 0, 0 )

      call argr4 ( '-exp', exponent, 0., 0. )
      call argi4 ( '-e',trace_length, 0, 0 )
 
      median = ( argis('-median') .gt. 0 )
      call argi4 ( '-maxdi', maxDI, -9999, -9999 )
      call argi4 ( '-maxli', maxLI, -9999, -9999 )
      call argi4 ( '-mindi', minDI, -9999, -9999 )
      call argi4 ( '-minli', minLI, -9999, -9999 )

      call argi4 ( '-num', min_num_desired, 5, 5 )
      call argstr ( '-N', ntap, ' ', ' ' ) 
 
      call argstr ( '-O', otap, ' ', ' ' ) 
      
      call argi4 ( '-rec1', RecNum_start, -9999, -9999 )

      scoping = ( argis('-scoping') .gt. 0 )

      tdfn = ( argis('-tdfn') .gt. 0 )
      call argr4 ('-tol', tol, 0., 0.)
      call argi4 ( '-trc1', TrcNum_start, -9999, -9999 )
 
      call argr4 ( '-vs', vel_scalar, 100., 100. )
      verbos = ( argis('-V') .gt. 0 )
 
c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, LER, .FALSE., .FALSE. )
      call xtrarg ( name, LERR, .FALSE., .TRUE. )
           
      return
      end
