C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  vi3d1 ( minLI, minDI, cell_X, cell_Y, LI, DI, 
     :     X, Y, MaxNumFunctions, time_depth, velocity, npairs,  
     :     USP_trace, MAXVEL, nsampo, nsi, velocity_fcns, nfunc )

C  routine to load the velocity function data as a USP trace into the 
c  velocity_fcns[] array with coordinate information placed in the
c  X[] and Y[] arrays for use in interpolation.

c algorithm is:
C       1- relative coordinates are computed for the specific
c          location of a velocity function.

C       2- input velocity functions are sampled and linearly
c          interpolated.

C       3- final velocity function is saved in velocity_fcn[]
c          array with DI coordinates in X[] and LI coordinates
c          in Y[]

c declare variables passed from calling routine

      integer minLI, minDI, LI, DI, npairs, MaxNumFunctions
      integer MAXVEL, nsampo, nsi, nfunc

      real velocity_fcns(MAXVEL), USP_TRACE(nsampo)
      real cell_X, cell_Y, velocity(npairs), time_depth(npairs)
      real X(MaxNumFunctions), Y(MaxNumFunctions)

c declare local variables

      integer pointer

c Variable Definitions
c 
C     minLI  - minimum LI in the output grid
C     minDI  - minimum DI in the output grid
C     cell_X  - in-line cell increment
C     cell_Y  - cross-line cell increment
C     LI     - line  index of velocity function
C     DI     - depth index of velocity function
C     X[]      - buffer of relative X coordinates
C     Y[]      - buffer of relative Y coordinates
C     MaxNumFunctions - Total number of velocity functions to be read
C     time_depth[]  - TDFN function times
C     velocity[]    - TDFN function velocities
C     npairs - number of entries in TDFN function
C     USP_trace[] - buffer of sampled & interpolated velocity function
C     MAXVEL - SIZE of velocity_fcn[] array
C     nsampo - number of samples in output trace
C     nsi    - output sample interval
C     velocity_fcns[] - USP velocity trace database
C     nfunc  - number of velocity functions input so far
c     pointer - a pointer to the current trace location in velocity_fcns[]

c initialize variables

      pointer = ( nfunc - 1 ) * nsampo + 1

c compute a relative coordinate for a given LI, DI

      X(nfunc) = cell_X * float( DI - minDI )
      Y(nfunc) = cell_Y * float( LI - minLI )
      
c time sample the velocity function & linear interpolate
c call velint for velocity function

      call Build_Trace( time_depth, velocity, nsi, npairs, USP_trace, 
     :     nsampo )

c write the USP_trace to the velocity_fcns database

      call vmov ( USP_Trace, 1, velocity_fcns(pointer), 1, nsampo )

      return
      end
