C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----
c   routine to read a line of disco3d HANDVEL format time-velocity
c   pairs and pack them into the proper absolute positions of T & V
c   arrays.  "i" contains the starting pointer into these arrays,
c   e.g. for the first card i=1; for the second card i=5, etc
c----
      subroutine glineh (card, i, time, vels)

#include <f77/iounit.h>

      integer    time (*)
      integer    vels (*)
      character  card * 80

       iw = iwcount (card, 80)
       if (mod(iw,2) .ne. 0) then
          write(LER,*)'FATAL ERROR in vi3din disco3d option:'
          write(LER,*)'Found ',iw,' columns of data in file'
          write(LER,*)'Check input vel file'
          call ccexit (666)
       endif
       iw = iw / 2

       if (iw .eq. 4) then
       call fsscnf (card,'%d %d %d %d %d %d %d %d',
     1      time(i),vels(i), time(i+1),vels(i+1), time(i+2),vels(i+2),
     2      time(i+3),vels(i+3) )
       elseif (iw .eq. 3) then
       call fsscnf (card,'%d %d %d %d %d %d',
     1      time(i),vels(i), time(i+1),vels(i+1), time(i+2),vels(i+2))
       elseif (iw .eq. 2) then
       call fsscnf (card,'%d %d %d %d',
     1      time(i),vels(i), time(i+1),vels(i+1))
       elseif (iw .eq. 1) then
       call fsscnf (card,'%d %d',
     1      time(i),vels(i))
       endif

      ii = 0
      do  k = 1, 4
          if (vels(i+k-1) .ne. 0) ii = ii + 1
      enddo
       i = i + ii

      return

      end
