C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----
c   routine to read a line of GECO migration format time-velocity
c   pairs and pack them into the proper absolute positions of T & V
c   arrays.  "i" contains the starting pointer into these arrays,
c   e.g. for the first card i=1; for the second card i=6, etc
c----
      subroutine glinem (card, i, time, vels)

      real       time (*), vels (*)
      character  card * 80

c----
c   determine number of T-V pairs on this card (go by "." decimals)
c----
      ipair = 0
      do  ic = 1, 80
          if (card(ic:ic) .eq. '.') ipair = ipair + 1
      enddo
      ipair = ipair / 2

c----
c   depending on how many pairs we have, read the values from
c   the card and pack them into the T & V vectors
c----
      if     (ipair .eq. 5) then

                      call fsscnf (card,'%f %f %f %f %f %f %f %f %f %f',
     1      time(i),vels(i),
     2      time(i+1),vels(i+1), time(i+2),vels(i+2),
     3      time(i+3),vels(i+3), time(i+4),vels(i+4))
            i = i + 5

      elseif (ipair .eq. 4) then

                      call fsscnf (card,'%f %f %f %f %f %f %f %f',
     1      time(i),vels(i),
     2      time(i+1),vels(i+1), time(i+2),vels(i+2),
     3      time(i+3),vels(i+3)                             )
            i = i + 4

      elseif (ipair .eq. 3) then

                      call fsscnf (card,'%f %f %f %f %f %f',
     1      time(i),vels(i),
     2      time(i+1),vels(i+1), time(i+2),vels(i+2))
            i = i + 3

      elseif (ipair .eq. 2) then

                      call fsscnf (card,'%f %f %f %f',
     1      time(i),vels(i), time(i+1),vels(i+1))
            i = i + 2

      elseif (ipair .eq. 1) then

                      call fsscnf (card,'%f %f',
     1      time(i),vels(i)                                 )
            i = i + 1

      endif

      return
      end
