C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  vi3din: read velocity flat files for 3D
C                     and using XY info and LI/DI limits output
c                            of given ampl. at specified times

c     currently reads the following format styles:
c     digicon
c     bfile
c     geco
C
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     LUOUT, LBYTES
      integer     argis
#include <f77/pid.h>
      INTEGER     ivel(SZLNHD), itim(SZLNHD), key(SZLNHD), itmp(SZLNHD)
      REAL        vv(SZLNHD), tt(SZLNHD)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     limin, limax, dimin, dimax
      
      CHARACTER   NAME * 6, otap * 256, vtap * 256
      CHARACTER   mcard * 80
      logical     verbos,query,gecovel,bfilevel,g2d,shot,cdp
      logical     western, gecomig, RC, virf, frost, hand3d, promax
      logical     promax3d
 
      DATA NAME     /'VI3DIN'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./

c--------------------------------
c  get online help if necesssary
c--------------------------------
      query = ( argis( '-?' ) .gt. 0 )
      if ( query ) then
           call help()
           stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(otap,vtap,limin,limax,dimin,dimax,iend,verbos,
     1           IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,luin,luout,
     2           gecomig,gecovel,bfilevel,g2d,shot,cdp,RC,western,
     3           virf,scl,frost,tscl,itmax,hand3d,promax,promax3d)

      IF ( .not. g2d) THEN

C**********************************************************************C
C     BUILD vi3d FIRST CARD ( 1MC3D card )
C**********************************************************************C
      
      call bldcrd ( luout, mcard )

C**********************************************************************C
C     build LI/DI coordinates
C**********************************************************************C

      IF ( .not. RC ) THEN

         CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1               IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

         if (limax .eq. 0) then
             maxli = NX
         else
             maxli = limax
         endif
         if (limin .eq. 0) then
             minli = 1
         else
             minli = limin
         endif
         if (dimax .eq. 0) then
             maxdi = NY
         else
             maxdi = dimax
         endif
         if (dimin .eq. 0) then
             mindi = 1
         else
             mindi = dimin
         endif

      ELSE

         mindi = dimin
         maxdi = dimax
         minli = limin
         maxli = limax

      ENDIF

      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1


      ELSE

          mindi = dimin
          maxdi = dimax
 
      ENDIF

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'*********************************'
      write(LER,*)' '

C**********************************************************************C
C     read input vel files for various formats:
c
c     There are 2 basic format types:
c     (1) digicon format - which is column arranged, i.e. the vel
c         functions are ll streamed together one velocity per line
c         in the file. Functions are separated by line or trace number.
c     (2) geco - here the velocity functions are more like a TDFN 
c         function where the time velocity pairs are all together in
c         several lines. bfile format is very similar to geco
C**********************************************************************C

      IF     (gecovel) THEN

              call geco    (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, tt, vv, key, itmp, verbos,
     4                      RC, scl, tscl, itmax)

      ELSEIF (gecomig) THEN

              call gecom   (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, tt, vv, key, itmp, verbos,
     4                      RC, scl, tscl, itmax)

      ELSEIF (bfilevel) THEN

              call bfile   (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, tt, vv, key, itmp, 
     4                      scl, tscl, itmax, verbos)

      ELSEIF (western) THEN

              call westrn  (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, tt, vv, key, itmp, 
     4                      scl, tscl, itmax, verbos)

      ELSEIF (hand3d) THEN
 
              call handvel3d  (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, tt, vv, key, itmp,
     4                      scl, tscl, itmax, verbos, RC)

      ELSEIF (g2d) THEN

              call geco2d  (luin, luout, ivel, itim, tt, vv, key, 
     1                      mindi, maxdi, itmp, shot, cdp, verbos,
     2                      scl, tscl, itmax)

      ELSEIF (virf) THEN

              call virfvds (luin, luout, ivel, itim, minli, maxli,
     1                      mindi, maxdi, key, itmp, verbos, scl,
     2                      tscl, itmax)

      ELSEIF (frost) THEN

              call frostfmt (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, key, itmp, verbos,
     4                      RC, scl, tscl, itmax)

      ELSEIF (promax) THEN

              call promfmt (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, key, itmp, verbos,
     4                      RC, scl, tscl, itmax)

      ELSEIF (promax3d) THEN

              call prom3d  (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, key, itmp, verbos,
     4                      RC, scl, tscl, itmax)

      ELSE

              call digicon (luin, luout, ivel, itim, IX1, IY1,
     1                      XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                      DX, DY, NDI, NLI, minli, maxli,
     3                      mindi, maxdi, key, itmp, verbos,
     4                      RC, scl, tscl, itmax)

      ENDIF

999   continue
      close (luout)
      close (luin)

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for vi3din: read flat file'
        write(LER,*)'3D velocity functions of various formats with XYs'
        write(LER,*)'and convert to vi3d TDFN format'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-v[vtap]   -- input velocity flat file name'
        write(LER,*)'-O[otap]   -- output TDFN vi3d format file name'
        write(LER,*)' '
        write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1'
        write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1'
        write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
        write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
        write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
        write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
        write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
        write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
        write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
        write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'
      write(LER,*)' '
      write(LER,*)'(optional LI/DI box definition)'
        write(LER,*)'-RC        -- define survey using LI/DI'
      write(LER,*)
     :' -dmin[dmin]  (def = 1)     : minimum DI in survey box'
      write(LER,*)
     :' -dmax[dmax]  (def = none)  : maximum DI in survey box'
      write(LER,*)
     :' -dmin[dmin]  (def = 1)     : minimum LI in survey box'
      write(LER,*)
     :' -dmax[dmax]  (def = none)  : maximum LI in survey box'
        write(LER,*)
     :' -scl[scl]  (def = 1.0)     : scale factor for velocities'
        write(LER,*)
     :' -tmax[tmax]  (def = ignore): max time allowed'

      write(LER,*)' '
      write(LER,*)' '

        write(LER,*)'-geco      -- input velocity file is GECO format'
        write(LER,*)'-gecom     -- velocity file is GECO migration fmt'
        write(LER,*)'-g2d       -- input velocity file is GECO fmt'
        write(LER,*)'              but for 2D data (shot or cdp #s)'
        write(LER,*)'              Use -dimin[] & -dimax[] for limits'
        write(LER,*)'-cdp       -- for 2D option: key off CDP number'
        write(LER,*)'-shot      -- for 2D option: key off SP number'
        write(LER,*)'-bfile     -- input velocity file is BFILE format'
        write(LER,*)'-western   -- input velocity file western format'
        write(LER,*)'-frost     -- input velocity is Robert Frost fmt'
        write(LER,*)'-disco3d   -- input velocity is disco3d (handvel)'
        write(LER,*)'-virf      -- input velocity file Amoco VDS fmt'
        write(LER,*)'-promax    -- input velocity file promax fmt'
        write(LER,*)'-promax3d  -- input velocity file 3d promax fmt'
        write(LER,*)'              otherwise file is DIGICON format'
        write(LER,*)' '
        write(LER,*)'-f2m       -- scale XYs from feet to meters'
        write(LER,*)'-m2f       -- scale XYs from meters to feet'
        write(LER,*)'              otherwise no XY scaling'
        write(LER,*)'-ms        -- times are in seconds'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   vi3din -v[] -O[] [ -x1[] -y1[] -x2[] -y2[]'
        write(LER,*)'          -x3[] -y3[] -x4[] -y4[] -ildm[] -icdm[]'
        write(LER,*)'          [-dimin[] -dimax[] -limin[] -limax[]'
        write(LER,*)'          -RC ] [ -gecom -geco -bfile -western'
        write(LER,*)'          -g2d -virf -frost -disco3d -promax'
        write(LER,*)'          -promax3d'
        write(LER,*)'          -tmax[] -scl[] -f2m -m2f -ms'
        write(LER,*)'          [ -cdp -shot ] -V ] ]'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of spikes
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(otap,vtap,minli,maxli,mindi,maxdi,iend,verbos,
     1                 IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,
     2                 luin,luout,gecomig,gecovel,bfilevel,g2d,shot,cdp,
     3                 RC,western,virf,scl,frost,tscl,itmax,hand3d,
     4                 promax,promax3d)

#include <f77/iounit.h>
      character  otap*(*), vtap*(*)
      integer    argis
      integer    minli,maxli,iend
      logical    verbos,gecovel,bfilevel,g2d,shot,cdp,gecomig,RC
      logical    western, digicon, virf, frost, f2m, m2f, hand3d
      logical    promax, promax3d

      fmscl = 0.30480
      mfscl = 3.28084

         call argstr('-O',otap,' ',' ')
         call argstr('-v',vtap,' ',' ')

         if (otap(1:1) .eq. ' ') then
            luout = LOT
         else
            call alloclun ( luout )
         endif
         if (vtap(1:1) .eq. ' ') then
            luin  = LIN
         else
            call alloclun ( luin )
         endif

         open (luin, file = vtap, status = 'old', iostat = ierr)
         if(ierr .ne. 0) then
            write(LER,*)'vi3din: Could not open velocity input ',
     :           vtap
            write(LER,*)'       Check permissions/spelling and rerun '
            write(LER,*)'FATAL'
            stop
         endif

         open (luout, file = otap, status = 'unknown', iostat = ierr)
         if(ierr .ne. 0) then
            write(LER,*)'vi3din: Could not open velocity output ',
     :           otap
            write(LER,*)'       Check permissions/spelling and rerun '
            write(LER,*)'FATAL'
            stop
         endif

         call argi4 ('-tmax',itmax,10000,10000)
         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )
 
         call argr4 ('-cldm', dx, 0., 0.)
         call argr4 ('-ildm', dy, 0., 0.)

         call argi4 ('-dimin', MINDI , 1 , 1 )
         call argi4 ('-dimax', MAXDI , 0 , 0 )
         call argi4 ('-limin', MINLI , 1 , 1 )
         call argi4 ('-limax', MAXLI , 0 , 0 )

         g2d       = ( argis( '-g2d' ) .gt. 0 )
         shot      = ( argis( '-shot' ) .gt. 0 )
         cdp       = ( argis( '-cdp' ) .gt. 0 )
         gecomig   = ( argis( '-gecom' ) .gt. 0 )
         gecovel   = ( argis( '-geco' ) .gt. 0 )
         bfilevel  = ( argis( '-bfile' ) .gt. 0 )
         western   = ( argis( '-western' ) .gt. 0 )
         digicon   = ( argis( '-digicon' ) .gt. 0 )
         RC        = ( argis( '-RC' ) .gt. 0 )
         virf      = ( argis( '-virf' ) .gt. 0 )
         frost     = ( argis( '-frost' ) .gt. 0 )
         hand3d    = ( argis( '-disco3d' ) .gt. 0 )
         promax3d  = ( argis( '-promax3d' ) .gt. 0 )
         promax    = ( argis( '-promax' ) .gt. 0 )
         verbos    = ( argis( '-V' ) .gt. 0 )

         if (virf ) RC = .true.
         if (promax) RC = .true.
         call argr4 ('-scl', scl, 1., 1.)
         f2m       = ( argis( '-f2m' ) .gt. 0 )
         m2f       = ( argis( '-m2f' ) .gt. 0 )

         if ( f2m ) scl = fmscl
         if ( m2f ) scl = mfscl
           
         ms        = ( argis( '-ms' ) .gt. 0 )
         tscl = 1.0
         if ( western .or. frost ) ms = .true.
         if ( ms ) tscl = 1000.
 
         IF ( RC ) THEN

            if (maxdi .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'Fatal Error in vi3din:'
               write(LERR,*)'Must enter proper max DI to define survey'
               write(LER ,*)' '
               write(LER ,*)'Fatal Error in vi3din:'
               write(LER ,*)'Must enter proper max DI to define survey'
               stop
            endif

            if (maxli .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'Fatal Error in vi3din:'
               write(LERR,*)'Must enter proper max LI to define survey'
               write(LER ,*)' '
               write(LER ,*)'Fatal Error in vi3din:'
               write(LER ,*)'Must enter proper max LI to define survey'
               stop
            endif
         ENDIF
       
         IF (.not. g2d) THEN
 
         if ( .not. RC ) then
         if (dx .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in vi3din:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in vi3din:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif
 
         if (dy .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in vi3din:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in vi3din:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif
         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in vi3din:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in vi3din:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif
         endif

         ELSE

         if (.not.shot .AND. .not.cdp) then
            write(LERR,*)' '
            write(LERR,*)'WARNING from vi3din - 2D option:'
            write(LERR,*)'-shot or -cdp not set. Will set cdp'
            write(LER ,*)' '
            write(LER ,*)'WARNING from vi3din - 2D option:'
            write(LER ,*)'-shot or -cdp not set. Will set cdp'
            cdp = .true.
         endif

         ENDIF

      return
      end
