C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C---
c   routine to read western format velocity functions and convert
c   them using their XY position into TDFN cards suitable for
c   vi3d
c   The hook is here to roll your own XY transform but we assume
c   that the XYs are in UTM (ft or m) and any transforms required
c   to get there have already been done.
c----
      subroutine westrn (luin, luout, ivel, itim, IX1, IY1,
     1                  XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                  DX, DY, NDI, NLI, minli, maxli,
     3                  mindi, maxdi, tt, vv, key, itmp, 
     4                  scl, tscl, itmax, verbos)

#include <f77/iounit.h>

      integer     itim (*), ivel (*), key (*), itmp (*)
      real        tt (*)
      integer     vv (*)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     minli, maxli, mindi, maxdi, li, di
      character   card * 80
      logical     verbos, newf, EOF

c----
c   set up constants for TDFN cards
c----
      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9
      newf = .true.
      EOF  = .false.
C**********************************************************************C
C     read input vel file until the end
C**********************************************************************C
      nf = 0
      jf = 0
      if = 1

C**********************************************************************C
C     read down to start of first function
C**********************************************************************C
      DO while (1.eq.1)
         read (luin, '(a80)', end=10, err=666) card
         if (card(1:3) .eq. 'WGC') then
            nf = 1
            go to 111
         endif
      Enddo
111   continue
 
c----
c   read every line in input velocity file. Check for EOF and if so
c   make sure we have at least 1 valid function, otherwise emit error
c   message
c----
      DO while (1.eq.1)

c----
c   start of new function: read line containign XYs
c----
         if = 1
         nf = nf + 1
         read (luin, '(a80)',  err=666) card
         call fsscnf (card,'%f %f %f %f',dm1,dm2,CX,CY)
 
c----
c   XY info looks ok. Determine if the XY point is within the survey
c   boundaries. If not then go read input to start of next function.
c   If it is inside then start reading the current function
c----
            CX = CX * scl
            CY = CY * scl

            IWRN = 0
            CALL XFMFWD (CX, CY, LI, DI, CXT, CYT, BXT, BYT, IWRN,
     1                   IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                   DX, DY, NDI, NLI)
 
            IF (LI .LT. MINLI) IWRN = 1
            IF (LI .GT. MAXLI) IWRN = 1
            IF (DI .LT. MINDI) IWRN = 1
            IF (DI .GT. MAXDI) IWRN = 1

            if (IWRN .eq. 1) then
            write(LERR,*)'Function located at ',ICX,ICY,' out of bounds'
            else
            write(LERR,*)'Function located at ',ICX,ICY,' inside box'
            endif

            if (IWRN .eq. 1) then
               Do while (1.eq.1)
                  read (luin, '(a80)', end=21, err=666) card
                  go to 31
21                continue
                  go to 999
31                continue

                  if (card(1:3) .eq. 'WGC') then
                     go to 100
                  endif
               Enddo
            endif

            if (verbos) then
               write(LERR,*)'ICX,ICY,LI,DI= ',ICX,ICY,LI,DI
            endif

c-----
c   read lines of current function
c-----
            Do while (1.eq.1)

               read (luin, '(a80)', end=20, err=666) card
               go to 30
20             continue
               EOF = .true.
30             continue

               IF (card(1:3) .eq. 'WGC' .OR. EOF) then
c----
c   We've completed reading the current function and about to start
c   the next.  Change time to ms and check for zero velocity signaling
c   the end of the function. Build TDFN output.
c----
                  if = if - 1
                  if (if .le. 0) then
                     Do while (1.eq.1)
                        read (luin, '(a80)', end=22, err=666) card
                        go to 32
22                      continue
                        go to 999
32                      continue
                        if (card(1:3) .eq. 'WGC') then
                           go to 100
                        endif
                     Enddo
                  endif

 
                  iff = 0
                  do  i = 1, if
                      itimi = nint (tscl * tt(i))
                      if (itimi .lt. itmax .AND. vv(i) .gt. 0) then
                         iff = iff + 1
                         ivel (iff) = vv(iff)
                         itim (iff) = itimi
                      endif
                  enddo
                  if = iff
                        call sort (itim, key, if)
                        do  i = 1, if
                            itmp (i) = ivel (key(i))
                        enddo
                        do  i = 1, if
                            ivel (i) = itmp (i)
                        enddo
 
                  if (verbos) then
                     write(LERR,*)'Function ',jf,' Number pairs ',if
                     write(LERR,*)(itim(ii),ii=1,if)
                     write(LERR,*)(ivel(ii),ii=1,if)
                  endif
 
                  xcards = float (if) / 7.0
                  ncards = ifix  (xcards - .001)
                  left = if - 7 * ncards
                  i1 = 7 * ncards + left + 1
                  i2 = 7 * (ncards + 1)
                  do  i = i1, i2
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
 
                  write (luout,555) ir0, tag, li, di
555               format (i1, a4, 2i5)
 
                  ih = -7
                  itag = 0
                  if (ncards .gt. 0) then
                     do  i = 1, ncards
                         itag = itag + 1
                         if (itag .ge. 9) itag = 1
                         ih = (i-1) * 7
                         write (luout,777) itag, tag,
     1                   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
                     enddo
                  endif
                  ih = ih + 7
                  write (luout,777) i9, tag,
     1            (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
777               format (i1, a4, 7(I4,I5), 7X, I5)

c----
c   If we're at the very end of the input file then exit routine
c----
                  if ( EOF ) go to 999
c----
c   Initialize T-V and character arrays for next function then
c   reset number of pairs counter, update, number of function
c   counter, and set new function flag true
c----
                  do  i = 1, if+1
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
                  do  i = 1, 80
                      card (i:i) = ' '
                  enddo

                  go to 100

               ELSE
                  call glinew (card, if, tt, vv)
               ENDIF

            Enddo


100      CONTINUE
         
      ENDDO

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din WESTERN reader:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din WESTERN reader:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card

10       continue
 
            write(LERR,*)'FATAL ERROR in vi3din WESTERN format:'
            write(LERR,*)'Found no functions. Check input file format'
            call ccexit (666)
 
999   continue
            write (LERR,*)'WESTERN format input file:'
            write (LERR,*)'Hit end of file finding ',nf,' functions'
            write (LERR,*)'within survey boundaries'

      return
      end
