C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE KAISER(WC,LW,W)                                        
C        A CONFIDENTIAL AMOCO SUBROUTINE                                
C             FORTRAN BY KEN PEACOCK  (DATE UNKNOWN)                    
C     KAISER COMPUTES A 2-SIDED BESSEL WEIGHT FUNCTION.                 
C     INPUTS ARE...                                                     
C        WC, STRENGTH OF WEIGHTING, A VALUE ABOUT 4 YIELDS TYPICAL      
C           WEIGHT STRENGTH.                                            
C        LW, LENGTH OF OUTPUT ARRAY.                                    
C     OUTPUT IS...                                                      
C        W, THE LW-LENGTH BESSEL FUNCTION.                              
C     CODED FOR THE IBM 3090.                                           
C     VERSION AS OF 2-2-86.                                             
C                                                                       
      DIMENSION W(1)                                                    
      N = LW/2                                                          
      CALL INO(WC,DEN)                                                  
      KSTA = N+2                                                        
      DO 10 K = KSTA,LW                                                 
      GE = WC*SQRT(1.-((K+1.-KSTA)/N)**2)                               
      CALL INO(GE,E)                                                    
   10 W(K) = E/DEN                                                      
      DO 20 I=1,N                                                       
      K = N+1+I                                                         
      J = N+1-I                                                         
   20 W(J) = W(K)                                                       
      W(N+1) = 1.                                                       
      RETURN                                                            
      END                                                               
