C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C-----------------------------------------------------------------------
c Program sunsort is designed to provide sorted output from TVD 
c files for compatability with TVDIN and TVDNMO
c
C-----------------------------------------------------------------------
C Program written by P.G.A. Garossino, Cairo, Feb/90
C-----------------------------------------------------------------------
C
C Variable Declaration
C
C-----------------------------------------------------------------------
      INTEGER NSP,SP(1000),I,count,lel
C-----------------------------------------------------------------------
      REAL*4 maxtim                                                 
C-----------------------------------------------------------------------TEN00180
      CHARACTER*80 JUNK                                                 TEN00190
      CHARACTER*1 COLOR
      CHARACTER*4 LINE,TEST
      CHARACTER fname*100
C-----------------------------------------------------------------------TEN00270
C INTEGER Variables                                                     TEN00280
C-----------------------------------------------------------------------TEN00290
C NSP : number of shot points                                           TEN00300
C NFCN : number of elements in any given function                       TEN00310
C SP(I) : array to contain shot point numbers                           TEN00320
c count : used to equate sp with opers record number
c nhor : number of horizons per function (used in TVDIN later)
C-----------------------------------------------------------------------TEN00330
C REAL Variables                                                        TEN00340
C-----------------------------------------------------------------------TEN00350
C TIME(I) : array of event times                                        TEN00360
C-----------------------------------------------------------------------TEN00370
C CHARACTER Variables                                                   TEN00380
C-----------------------------------------------------------------------TEN00390
C JUNK : line read utility                                              TEN00400
C DIP(I,J) : array to hold event dips                                   TEN00410
C VEL(I,J) : array to hold event velocities                             TEN00420
C ASP(I,J) : array to hold input shot points                            TEN00470
C COLOR : event colour                                                  TEN00490
C LINE : utility variable                                               TEN00500
C TEST : utility variable                                               TEN00510
C fname : filename of input file
C-----------------------------------------------------------------------TEN00530
C initialization of variables
      LINE = 'LINE'
      count = 1
      do 5 I=1,1000
         SP(I) = 0
 5    continue
C-----------------------------------------------------------------------TEN00530
C                                                                       TEN00540
C Start of Main Program                                                 TEN00550
C                                                                       TEN00560
C -------- Open input file ----------
	call cmdln(fname,lel,maxtim)
c ----- debug -----
c	write(*,*) 'fname(1:lel)',fname(1:lel),' lel:',lel
c ----- ----- -----
      Open(2,file=fname(1:lel),status='old',err=8888)
C-----------------------------------------------------------------------TEN01230
C GET COLOR DATA                                                        TEN01280
C-----------------------------------------------------------------------TEN01290
      READ(2,1110)COLOR                                                 TEN01300
1110  FORMAT(/////////////////////,23X,A1)
      REWIND 2                                                          TEN01320
c---------------------------------------------------------------------- TEN01330
C READ AND WRITE HEADER                                                 TEN01340
C-----------------------------------------------------------------------TEN01350
      DO 2 I=1,17 
      READ(2,10) JUNK      
10    FORMAT(A80)      
c      if(I.le.16) WRITE(3,10) JUNK 
2     CONTINUE      
C-----------------------------------------------------------------------TEN01450
C DETERMINE IF SHOT POINTS INCREASE OR DECREASE IN FILE                 TEN01460
C-----------------------------------------------------------------------TEN01470
      NSP=0                                                             TEN01480
      DO 20 I=1,1000                                                    TEN01490
C-----------------------------------------------------------------------TEN01500
C READ INPUT SHOT POINT NUMBER                                          TEN01510
C-----------------------------------------------------------------------TEN01520
         READ(2,30) SP(I)                                               TEN01530
30       FORMAT(13X,I6)                                                 TEN01540
C--DEBUG--                                                              TEN01550
c      WRITE(*,*) SP(I),I                                                
C---------                                                              TEN01570
         NSP=NSP+1                                                      TEN01580
C-----------------------------------------------------------------------TEN01590
C IF AT LEAST TWO SHOT POINTS READ, COMPARE VALUE                       TEN01600
C-----------------------------------------------------------------------TEN01610
         IF(I.GT.1) THEN                                                TEN01620
C-----------------------------------------------------------------------TEN01630
C IF INCREASING THEN                                                    TEN01640
C-----------------------------------------------------------------------TEN01650
              IF(SP(I).GT.SP(I-1)) THEN
              	write(*,*)' No sorting required'
                write(*,*) 'Program SUNSORT Terminated'
                write(*,*) 'Normal Completion'
             	stop 
              ELSE                                                      TEN01710
C-----------------------------------------------------------------------TEN01720
C IF DECREASING THEN DETERMINE THE NUMBER OF SHOTS AND REORDER THE      TEN01730
C INPUT FILE                                                            TEN01740
C-----------------------------------------------------------------------TEN01750
16                 READ(2,19,END=50)TEST                                TEN01760
                   IF(TEST.NE.LINE)GOTO 16                              TEN01770
                   NSP=NSP+1                                            TEN01780
                   READ(2,30) SP(NSP)                                   TEN01790
                   GOTO 16                                              TEN01800
              ENDIF                                                     TEN01810
         ENDIF                                                          TEN01820
C-----------------------------------------------------------------------TEN01830
C ADVANCE TO NEXT SHOT POINT                                            TEN01840
C-----------------------------------------------------------------------TEN01850
17       READ(2,19)TEST                                                 TEN01860
19       FORMAT(1X,A4)                                                  TEN01870
         IF(TEST.NE.LINE)GOTO 17                                        TEN01880
20    CONTINUE                                                          TEN01890
C-----------------------------------------------------------------------TEN01900
C STOP SHOULD NEVER OCCUR HERE                                          TEN01910
C-----------------------------------------------------------------------TEN01920
      STOP                                                              TEN01930
C-----------------------------------------------------------------------TEN01940
C CALL SUBROUTINE SRTOUT TO RE-SORT INPUT FILE                          TEN01950
C IF SRTOUT IS CALLED PROGRAM CONTROL WILL NOT RETURN TO MAIN ROUTINE   TEN01960
C-----------------------------------------------------------------------TEN01970
50    Open(3,file=fname(1:lel)//'.sort',status='unknown',err=8889)
      CALL SRTOUT(NSP,maxtim)
c ----- program termination -----
999   CLOSE(2)                                                          
      write(*,*) 'Program SUNSORT Terminated'
      write(*,*) 'Normal Completion'
      STOP
c-----------------------------------------------------------------------
8888  write(*,888)fname
888   format(' Cannot find input file ',a48,/,' Check your pathname.')
      stop
8889  write(*,899) fname
899   format(' error openning output file form.',a48)
      stop
      END                                                               TEN03210
C-----------------------------------------------------------------------TEN03220
C END OF MAIN PROGRAM                                                   TEN03230
C-----------------------------------------------------------------------TEN03250
C START OF SUBROUTINE SRTOUT WHICH RESORTS A TVD FUNCTION FILE INTO     TEN03260
C INCREASING RATHER THAT DECREASING SHOT POINT ORDER                    TEN03270
C-----------------------------------------------------------------------TEN03280
      SUBROUTINE SRTOUT(NSP,maxtim)                                            TEN03290
C-----------------------------------------------------------------------TEN03300
      INTEGER NSP,SPT(1000),NFCN(1000),I,NFCNMX,nhor(1000)
      INTEGER K,INDEX
      REAL*4 TIME(1000),DIP(1000),VEL(1000),tweak(1000),STIME(15000)
      real*4 sdip(15000),stwek(15000),svel(15000),maxtim
      CHARACTER*80 JUNK 
      character*1 color(1000),scolr(15000)
      character*14 line
C-----------------------------------------------------------------------TEN03400
C INITIALIZE                                                            TEN03410
C-----------------------------------------------------------------------TEN03420
      NFCNMX=0
      DO 1 I=1,1000                                                     TEN03440
         nhor(I) = 0
         SPT(I)=0                                                       TEN03450
         NFCN(I)=0                                                      TEN03460
         TIME(I)=0.                                                     TEN03470
         DIP(I)=0.                                                      TEN03480
         VEL(I)=0.
         tweak(I) = 0.
         color(I) = 'Z'
1     CONTINUE                                                          TEN03600
C-----------------------------------------------------------------------TEN03610
C REWIND INPUT FILE TO START READING ALL SHOT POINT INFORMATION         TEN03620
C-----------------------------------------------------------------------TEN03630
      REWIND 2                                                          TEN03640
C---------------------------------------------------------------------- TEN01330
C READ AND WRITE HEADER                                                 TEN01340
C-----------------------------------------------------------------------TEN01350
      DO 2 I=1,17                                                       TEN01360
       READ(2,1127) JUNK    
1127   FORMAT(A80)           
       if(I.le.16) WRITE(3,1127) JUNK
2     CONTINUE                                                          TEN01410
       rewind 2
c -----
c read past header to first shot point
c ----
      read(2,5) junk
5     format(///////////////,a80)
C-----------------------------------------------------------------------TEN01450
C LOOP 10 WILL CYCLE THROUGH ENTIRE OUTPUT FILE FROM SP 1 TO SP N       TEN03710
C-----------------------------------------------------------------------TEN03720
      DO 10 I=1,NSP
      	read(2,107)line
107	format(15x,a14)
c ----- debug -----
c	write(*,*) ' line:',line
         READ(2,110)SPT(I),nhor(I)                                              
110      FORMAT(13X,I6,16x,i8,///)
c ----- debug -----
c	write(*,*) ' SPT :',SPT(I),' nhor :',nhor(I),' i = ',I
c ----- ----- -----
C-----------------------------------------------------------------------TEN03760
C LOOP 400 READS IN INDUVIDUAL TVD FUNCTION FOR SPT(I)                  TEN03770
C-----------------------------------------------------------------------TEN03780
      DO 400 K=1,1000                                                   TEN03790
         NFCN(I)=NFCN(I)+1                                              TEN03800
200      READ(2,210)TIME(K),DIP(K),VEL(K),color(K),tweak(k) 
210      FORMAT(F6.3,F6.0,F8.0,3x,a1,3x,f10.7)                                      
         IF((maxtim-TIME(K)).lt.1.e-6) GOTO 500                                   
400   CONTINUE                                                          TEN03890
C-----------------------------------------------------------------------TEN03900
C PROGRAM CONTROL SHOULD NEVER GET HERE, IF IT DOES EXECUTION WILL STOP TEN03910
C-----------------------------------------------------------------------TEN03920
      STOP                                                              TEN03930
C-----------------------------------------------------------------------TEN03940
C SORT DATA INTO BUFFER ARRAYS, IF MORE THAN 1500 TVD TRIPLETS ARE      TEN03950
C REQUIRED, THE INDEX AND S(ARRAYS) WILL HAVE TO BE INCREASED IN SIZE   TEN03960
C-----------------------------------------------------------------------TEN03970
500      INDEX=15000-(I*30)+1                                           TEN03980
C-----------------------------------------------------------------------TEN03990
C KEEP TRACK OF LARGEST NUMBER OF HORIZONS AT AN ANALYSIS LOCATION      TEN04000
C-----------------------------------------------------------------------TEN04010
         IF(NFCN(I).GT.NFCNMX)NFCNMX=NFCN(I)                            TEN04020
              DO 550 K=1,NFCN(I)                                        TEN04030
                   STIME(INDEX)=TIME(K)
                   sdip(INDEX) = DIP(K)
                   svel(INDEX) = VEL(K)
                   scolr(INDEX) = color(K)
                   stwek(INDEX) = tweak(K)
                   INDEX=INDEX+1                                        TEN04070
550           CONTINUE                                                  TEN04080
C-----------------------------------------------------------------------TEN04090
C ADVANCE INPUT FILE TO NEXT SHOT POINT                                 TEN04100
C-----------------------------------------------------------------------TEN04110
c              READ(2,555,END=556)JUNK                                   
c555           FORMAT(A80)                                               
10    CONTINUE                                                          TEN04140
C-----------------------------------------------------------------------TEN04190
C AFTER LOOP 10 INDEX = 15000-(NSP*30)+1+NFCN(NSP) THEREFORE TO START   TEN04200
C OUTPUT AT TOP OF SORTED FILE SET INDEX=INDEX-NFCN(NSP)                TEN04210
C-----------------------------------------------------------------------TEN04220
556   INDEX=INDEX-NFCN(NSP)                                             TEN04230
C
C ----- Output data to  sorted file -----    
C
      DO 20 I=1,NSP
      	write(3,22) LINE,SPT(NSP-I+1),nhor(NSP-I+1)
22    FORMAT(' LINE NUMBER:',2X,A14,/,' SHOT POINT',2X,I6,' Number horiz
     *ons',2x,i6,
     *//,
     *' TIME    DIP   VSTAK  COLOR  TWEAK MS ',/,
     *' ----    ---   -----  -----  --------')      
         DO 30 K=1,NFCN(NSP-I+1)
              WRITE(3,23) STIME(INDEX),sdip(INDEX),svel(INDEX),scolr(IND
     *EX),stwek(INDEX)              
23    FORMAT(F6.3,2(F6.0,2X),1X,A1,3X,F10.7,4X,F5.0,12X,F5.0)              
              INDEX=INDEX+1                                             TEN04330
30       CONTINUE                                                       TEN04340
         INDEX=INDEX+30-NFCN(NSP-I+1)                                   TEN04350
20    CONTINUE    
      close(3)
      write(*,*) 'Program SUNSORT Terminated'
      write(*,*) 'Normal Completion'
      STOP                                                              TEN05500
C-----------------------------------------------------------------------TEN05510
C END OF SUBROUTINE SRTOUT                                              TEN05520
C-----------------------------------------------------------------------TEN05530
      END                                                               TEN05540
C-----------------------------------------------------------------------TEN05510
C SUBROUTINE clscrn                                                     TEN05520
C-----------------------------------------------------------------------TEN05530
      subroutine clscrn
      write(6,10)
 10   format('    ',/////////////////////////////////////////////,'  ')
      return
      end
c
c ----- Routine cmdln -----
c
c  read in command line arguments for program 
c
c-------------------------------------------------------------
      subroutine cmdln(linein,lel,max)

#include <f77/iounit.h>

c     include           'iounit.h'
      integer    	lel
      real*4		max
      character         linein*100
 
c------------------------------------------------
c  get line id & find string length

      call argstr ('-N',linein,' ',' ')
      lel = lenth(linein)
      call argr4('-mt',max,4.800,4.800)
c ----- debug -----
c	write(LOT,*) ' In cmdln: linein(1:lel) =',linein(1:lel)
c	write(LOT,*) '           lel = ',lel
c	write(LOT,*) ' max in cmsld = ',max

c------------------------------------------------

      if(linein .eq. ' ') then
         write(LOT,*)'You must enter an input filename '
         write(LOT,*)'FATAL'
         stop
      endif
      return
      end
      
