C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PsdmMap ( trace, MapTrace, index, rectrc, picks, nsegs,
     *     nsamp, remove, nsi, total_picks, hpicks )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer index(5000,1),nsegs,nsamp,trace,nsi
      integer pointer,hpicks,dpicks,i,j,k, total_picks

      real    MapTrace(nsamp),rectrc(total_picks),picks(total_picks)
      real    DatumStorage(SZSMPM),HorizonStorage(SZSMPM)
      real    last_trace,next_trace,last_pick,next_pick
      real    slope,this_pick,SI
      real    tsamp,DatumLast,DatumNext,Horizonlast,HorizonNext

      logical remove

c ----- initialize variables -----

      pointer = 0
      hpicks = 0
      dpicks = 0

c ----- position trace within rectrc(),picks() and interpolate -----
c       horizon and datum values for each horizon datum pair.
c       first handle horizon values then datum values.  To do
c       this cycle through rectrc using every other segment 
c       starting first from 1 then from 2.
c

      do 10 i=1,nsegs,2

c scan horizon segments to get pick values either side of this trace

         pointer = pointer + 1

c see if current location is before 1st pick in segment

         if(float(trace).lt.rectrc(pointer))then

c move pointer past segment and datum and get ready to read next horizon.

            pointer = pointer + index(i,1) + index(i+1,1) -1
            goto 10
            
         endif           

c read through horizon and find entries before and after current
c trace to use in interpolation of horizon value at current trace.

         do 20 j=2,index(i,1)

c move pointer to next pick on horizon 

            pointer = pointer + 1
               
            if(float(trace).le.rectrc(pointer))then

               last_trace = rectrc(pointer-1)
               next_trace = rectrc(pointer)
               last_pick = picks(pointer-1)
               next_pick = picks(pointer)

               slope = (next_pick - last_pick)/(next_trace - last_trace)
                  
c calculate the value of the horizon at this trace using linear interpolation 
c y = mx + b

               this_pick = slope*(float(trace) - last_trace) + last_pick
               hpicks = hpicks + 1
               HorizonStorage(hpicks) = this_pick

c advance pointer to end of horizon

               pointer = pointer + index(i,1) - j

c search for associated datum entry, if you don't find one then delete
c the above horizon entry and reset hpicks to hpicks - 1

               do 40 k=1,index(i+1,1)

                  pointer = pointer + 1
               
                  if(float(trace).le.rectrc(pointer))then

                     last_trace = rectrc(pointer-1)
                     next_trace = rectrc(pointer)
                     last_pick = picks(pointer-1)
                     next_pick = picks(pointer)

                     slope = (next_pick - last_pick)/(next_trace - 
     *                    last_trace)

c calculate the value of the horizon at this trace 
c using linear interpolation y = mx + b

                     this_pick=slope*(float(trace)-last_trace)+last_pick
                     dpicks = dpicks + 1
                     DatumStorage(dpicks) = this_pick

c advance pointer to end of datum and advance to next horizon -----

                     pointer = pointer + index(i+1,1) - k
                     goto 10


                  endif

 40            continue

c no datum entry found, kill current horizon by reducing hpick
c and go to next horizon

               hpicks = hpicks - 1
               goto 10

            endif

c advance to next horizon element

 20      continue

c advance to next horizon, make sure to advance past datum picks as well
c so that next check will be on a horizon definition and not mixed between
c a horizon and a datum

         if ( i .le. ( nsegs - 1 ) ) then

            pointer = 0
         
            do l = 1,i+1
               pointer = pointer + index(i,1)
            enddo
         endif

 10   continue

c
c ----- determine if same number of picks made for horizon and datum. -----
c       If not this is a fatal error for somehow each horion entry 
c       does not have a datum to be shifted to.  Abort the routine and
c       warn the user.
c

      if(dpicks.ne.hpicks)then

         write(LERR,*)' '
         write(LERR,*)'FATAL ......................................'
         write(LERR,*)'Something fishy at trace ',trace,' number of'
         write(LERR,*)'horizons different than number of datums'
         write(LERR,*)' '
         stop

      endif

c if hpicks = 0 then output the input trace

      if ( hpicks .eq. 0 ) return

c
c ----- sort HorizonStorage file based on increasing times, make -----
c       same changes to DatumStorage to keep horizons and associated
c       datums together
c

      if(hpicks.gt.1) call hsort2 (hpicks,HorizonStorage,DatumStorage)

c
c ----- build the psdm function map for application/removal of -----
c       psdm stretch/squeeze.  The map will be contained in the
c       MapTrace array.
c

      pointer = 1
      SI = float(nsi)

      do i=1,nsamp

         tsamp = float(i)*SI

         IF(.not.remove)then

c ----- apply shift -----
         
            
            if( tsamp .lt. DatumStorage(pointer)
     :           .and.
     :           tsamp .lt. DatumStorage(dpicks)
     :           .and.
     :           pointer .eq. 1 ) then

               DatumLast = SI
               DatumNext = DatumStorage(pointer)
               HorizonLast = DatumLast
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               

            elseif( tsamp .lt. DatumStorage(pointer)
     :              .and.
     :              tsamp .lt. DatumStorage(dpicks) ) then
               
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               
            elseif( tsamp .ge. DatumStorage(pointer)
     :              .and.
     :              pointer .lt. dpicks ) then
               
               pointer = pointer + 1
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)


            elseif( tsamp .ge. DatumStorage(pointer)
     :              .and.
     :              pointer.eq.dpicks ) then
               
               DatumLast = DatumStorage(pointer)
               DatumNext = float(nsamp) * SI
               HorizonLast = HorizonStorage(pointer)
               HorizonNext = DatumNext
               MapTrace(i) = HorizonLast +  (HorizonNext - HorizonLast)*
     :              (tsamp - DatumLast)/(DatumNext-DatumLast)
               
            endif
            
         ELSE

c ----- remove shift -----

            if( tsamp .lt. HorizonStorage(pointer)
     :           .and.
     :           tsamp .lt. HorizonStorage(hpicks)
     :           .and.
     :           pointer .eq. 1 ) then
               
               HorizonLast = SI
               HorizonNext = HorizonStorage(pointer)
               DatumLast = HorizonLast
               DatumNext = DatumStorage(pointer)
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)

            elseif( tsamp .lt. HorizonStorage(pointer)
     :              .and.
     :              tsamp .lt. HorizonStorage(hpicks) ) then
               
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
            elseif( tsamp .ge. HorizonStorage(pointer)
     :              .and.
     :              pointer .lt. hpicks ) then
               
               pointer = pointer + 1
               DatumLast = DatumStorage(pointer-1)
               DatumNext = DatumStorage(pointer)
               HorizonLast = HorizonStorage(pointer-1)
               HorizonNext = HorizonStorage(pointer)
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
            elseif( tsamp .ge. HorizonStorage(pointer)
     :              .and.
     :              pointer.eq.hpicks ) then
               
               DatumLast = DatumStorage(pointer)
               DatumNext = float(nsamp) * SI
               HorizonLast = HorizonStorage(pointer)
               HorizonNext = DatumNext
               MapTrace(i) = DatumLast +  (DatumNext - DatumLast)*
     :              (tsamp - HorizonLast)/(HorizonNext-HorizonLast)
               
            endif

         ENDIF

         MapTrace(i) = MapTrace(i) / SI

      ENDDO

      return
      end
