C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine avgvel ( lim, time, vstak, va )
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c routine to convert a stacking velocity function to average velocity

      integer lim, end, i

      real time(lim), vstak(lim), root

      real*8 t, z
      real*8 vint(SZLNHD), zint(SZLNHD)
      real*8 tint(SZLNHD), va(SZLNHD)

      end = lim - 1

      do i = 1, end

c ------------------------------------------------------------------------
c  check if root is negative
c ------------------------------------------------------------------------

         root = ( vstak(i+1)**2 * time(i+1) - vstak(i)**2 * 
     :        time(i) ) / ( time(i+1) - time(i) )

         if ( root .lt. 0. ) then

            if ( vstak(i) .gt. vstak(i+1) ) then

               write(LERR,*)' '
               write(LERR,*)' vstak(I) =',VSTAK(I)
               write(LERR,*)' vstak(I+1) =',VSTAK(I+1)
               write(LERR,*)' you have a stacking velocity inversion '
               write(LERR,*)' of sufficient magnitude to cause a '
               write(LERR,*)' negative square root in the DIX '
               write(LERR,*)' estimate of average velocity at the '
               write(LERR,*)' function location.  Fix this and rerun'
               write(LERR,*)' FATAL'
               write(LERR,*)' '
               write(LER,*)' '
               write(LER,*)'TVD: '
               write(LER,*)' vstak(I) =',VSTAK(I)
               write(LER,*)' vstak(I+1) =',VSTAK(I+1)
               write(LER,*)' you have a stacking velocity inversion '
               write(LER,*)' of sufficient magnitude to cause a '
               write(LER,*)' negative square root in the DIX '
               write(LER,*)' estimate of average velocity at the '
               write(LER,*)' function location.  Fix this and rerun'
               write(LER,*)' FATAL'
               stop
            endif
         endif

         vint(i+1) = dble ( sqrt ( ( vstak(i+1)**2 * time(i+1) - 
     :        vstak(i)**2 * time(i) ) / ( time(i+1) - time(i) ) ) )
         tint(i+1) = dble ( ( time(i+1) - time(i) ) / 2. )
         zint(i+1) = vint(i+1) * tint(i+1)

      enddo


      tint(1) = dble ( time(1) )
      zint(1) = tint(1) * dble ( vstak(1) )
      vint(1) = dble ( vstak(1) )
      va(1) = dble ( vstak(1) )
      
      t = 0.d0
      z = 0.d0

      do i = 2, lim

         z = z + zint(i)
         t = t + tint(i)
         if ( t .lt. 0.d0000001 ) t = 0.d0000001
         va(i) = ( z / t )

      enddo

      return
      end
      
