C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine DipVstack( fx, vel_NumFcns, vel_size, vel_NumPoints, 
     :     vel_times, vel_x_coords, vel_velocities, tx, dx, dt, 
     :     dip, vstk )

c a routine to return a value of dip and stacking velocity on the
c horizon at the analysis location.  Algorithm is to determine
c a stacking and average velocity value at the current analysis 
c location.  Using the average velocity calculate a dip on the
c horizon using the information returned from the subroutine
c SlopeTime.

#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer vel_NumFcns, vel_size
      integer vel_NumPoints(SZLNHD)

      real vel_times(vel_size), vel_velocities(vel_size)
      real vel_x_coords(vel_size)

      real*8 fx, tx, dx, dt, dip, vstk

c declare local variables

      integer i, pointer, pointer1, pointer2, max_pointer
      integer num_vels1, num_vels2

      real*8 vel_avg(SZLNHD), vel_avg1(SZLNHD), vel_avg2(SZLNHD)
      real*8 vavg, vavg1, vavg2, vstk1, vstk2

c initialize variables

      max_pointer = 0

      do i = 1, vel_NumFcns
         max_pointer = max_pointer + vel_NumPoints(i)
      enddo

      do i = 1, SZLNHD
         vel_avg(i) = 0.d0
         vel_avg1(i) = 0.d0
         vel_avg2(i) = 0.d0
      enddo

c identify velocity functions to be involved in calculation.  If
c we are at one edge of the velocity control then extrapolation makes
c life easy.  If we are in the midst of the control then interpolation
c will be required.

c analysis location is before first velocity control location

      if ( sngl(fx) .le. vel_x_coords(1) ) then

c generate an average velocity function at this location

         call avgvel ( vel_NumPoints(1), vel_times(1), 
     :        vel_velocities(1), vel_avg )

c interpolate average velocity at horizon time

         call dinterp ( vel_NumPoints(1), vel_times(1), vel_avg, tx, 
     :        vavg )
         
c interpolate stacking velocity at horizon time

         call interp ( vel_NumPoints(1), vel_times(1), 
     :        vel_velocities(1), tx, vstk )

         dip = datan ( ( dt / 2. ) * vavg / dx )
         
         return

      endif

c analysis location is after last velocity control location

      if ( sngl(fx) .ge. vel_x_coords(max_pointer) ) then

c calculate pointer to last velocity function

         pointer = 1 - vel_NumPoints(1)

         do i = 1, vel_NumFcns - 1
            pointer = pointer + vel_NumPoints(i)
         enddo

c calculate an average velocity function at the control location

         call avgvel ( vel_NumPoints(vel_NumFcns), vel_times(pointer), 
     :        vel_velocities(pointer), vel_avg )

c interpolate average velocity at horizon time

         call dinterp ( vel_NumPoints(vel_NumFcns), vel_times(pointer), 
     :        vel_avg, tx, vavg )
         
c interpolate stacking velocity at horizon time

         call interp ( vel_NumPoints(vel_NumFcns), vel_times(pointer), 
     :        vel_velocities(pointer), tx, vstk )

         dip = datan ( ( dt / 2. ) * vavg / dx )
         
         return

      endif

c analysis location is within velocity control

c calculate pointers to each location

      pointer1 = 0
      pointer2 = 1

      do i = 2, vel_NumFcns

         pointer2 = pointer2 + vel_NumPoints(i-1)
            
         if ( vel_x_coords(pointer2) .ge. sngl(fx) ) then
            pointer1 = pointer2 - vel_NumPoints(i-1)
            num_vels1 = vel_NumPoints(i-1)
            num_vels2 = vel_NumPoints(i)
            goto 10
         endif

      enddo

 10   continue

c generate average velocity functions at each velocity location

      call avgvel ( num_vels1, vel_times(pointer1), 
     :     vel_velocities(pointer1), vel_avg1)

      call avgvel ( num_vels2, vel_times(pointer2), 
     :     vel_velocities(pointer2), vel_avg2)

c interpolate an average velocity on the horizon at both locations

      call dinterp (num_vels1, vel_times(pointer1), 
     :     vel_avg1, tx, vavg1 )

      call dinterp (num_vels2, vel_times(pointer2), 
     :     vel_avg2, tx, vavg2 )

c interpolate a stacking velocity on the horizon at both locations

      call interp (num_vels1, vel_times(pointer1), 
     :     vel_velocities(pointer1), tx, vstk1 )

      call interp (num_vels2, vel_times(pointer2), 
     :     vel_velocities(pointer2), tx, vstk2 )

c interpolate an average and stacking velocity for the horizon at
c the analysis location

      vstk = ( ( fx - vel_x_coords(pointer1) ) / 
     :     ( vel_x_coords(pointer2) - vel_x_coords(pointer1) ) ) * 
     :     ( vstk2 - vstk1 ) + vstk1

      vavg = ( ( fx - vel_x_coords(pointer1) ) / 
     :     ( vel_x_coords(pointer2) - vel_x_coords(pointer1) ) ) * 
     :     ( vavg2 - vavg1 ) + vavg1

c calculate a dip on the horizon [in radians]

      dip = datan ( ( dt / 2. ) * vavg / dx )

      return
      end
