C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine OffsetSlopeTime( xsd_NumPoints, xsd_size, xsd_x_coords, 
     :     xsd_horizon_times, xsd_Segment, fx, ax, tx, dt, dx, bail_out,    
     :     verbos)

c routine to examine the model segment requested and return
c a value of time, delta time and delta distance for the 
c analysis location on the horizon.  If the horizon does not
c exist at the analysis location the bail_out flag is set
c to .true.
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer xsd_Segment, xsd_size
      integer xsd_NumPoints(SZLNHD)

      real xsd_x_coords(xsd_size), xsd_horizon_times(xsd_size)

      real*8 fx, ax, tx, dt, dx

      logical bail_out, verbos

c declare local variables

      integer i, pointer

      real*8 tx_ax, tx_fx, dt_ax, dt_fx, dx_ax, dx_fx
      real*8 slope, slope_ax, slope_fx

c determine if horizon is present at current analysis location [fx]
c if so determine time, and slope on the horizon at the analysis location

c determine location of segment in memory

      if ( xsd_segment .gt. 1 ) then
         pointer = 0 
         do i = 1, xsd_segment - 1
            pointer = pointer + xsd_NumPoints(i)
         enddo
      else
         pointer = 0
      endif

c determine if segment exists at analysis location, and be certain
c that both fx and ax are present on segment.  If not then set bail_out
c to .true. and return


c function location before segment

      if ( sngl(fx) .lt. xsd_x_coords( pointer + 1) ) bail_out = .true.

c function location past segment

      if ( sngl(fx) .gt. 
     :     xsd_x_coords( pointer + xsd_NumPoints( xsd_segment ) ) )
     :     bail_out = .true.

c function location on segment, get required data but watch out for
c offset location falling off either edge of segment.  If this 
c should happen get the closest estimate possible using the 
c terminus segment point and the function location

      IF ( .not. bail_out ) then

         DO  i = 1, xsd_NumPoints( xsd_segment )

            if ( xsd_x_coords( pointer + i ) .gt. sngl(fx) ) then

               if ( sngl(ax) .le. xsd_x_coords(pointer + 1) ) then
                  
c offset location off left edge


                  dt = dble (xsd_horizon_times(pointer+2) -
     :                 xsd_horizon_times(pointer+1) )
                  dx = dble(xsd_x_coords(pointer+2) - 
     :                 xsd_x_coords(pointer+1))
                  slope = dt / dx
                  tx = dble ( xsd_horizon_times( pointer + 1 ) )
                  return

               elseif ( sngl(ax) .ge. xsd_x_coords(pointer + 
     :                 xsd_NumPoints( xsd_segment ) ) ) then

c offset location off right edge

                  dt = dble( xsd_horizon_times( pointer + 
     :                 xsd_NumPoints( xsd_segment ) ) - 
     :                 xsd_horizon_times( pointer + 
     :                 xsd_NumPoints( xsd_segment ) - 1 ) )
                  dx = dble ( xsd_x_coords( pointer +  
     :                 xsd_NumPoints( xsd_segment ) ) - 
     :                 xsd_x_coords ( pointer + 
     :                 xsd_NumPoints( xsd_segment ) - 1 ) )
                  slope = dt / dx
                  tx = dble ( xsd_horizon_times( pointer +
     :                 xsd_NumPoints( xsd_segment ) ) )
                  return

               else

c both fx and ax on segment, interpolate a value of time and x_coord
c for each then use those to calculate delta values and slope

c time at ax

                  do j = 1, xsd_NumPoints(xsd_segment)

                     if ( xsd_x_coords( pointer + j ) .gt. sngl(ax) ) 
     :                    then

                        dt_ax = dble ( xsd_horizon_times( pointer + j )
     :                       - xsd_horizon_times( pointer + j - 1 ) )
                        dx_ax = dble ( xsd_x_coords( pointer + j ) -
     :                       xsd_x_coords( pointer + j - 1 ) )
                        slope_ax = dt_ax / dx_ax
                        tx_ax = slope_ax * 
     :                       ( ax - 
     :                       dble ( xsd_x_coords( pointer + j - 1 ) ) )
     :                       + dble ( xsd_x_coords( pointer + j - 1 ) ) 

                        goto 100
                     endif
                  enddo

 100              continue

c time at fx

                  dt_fx = dble ( xsd_horizon_times( pointer + i ) -
     :                 xsd_horizon_times( pointer + i - 1 ) )
                  dx_fx = dble ( xsd_x_coords( pointer + i ) -
     :                 xsd_x_coords( pointer + i - 1 ) )
                  slope_fx = dt_fx / dx_fx
                  tx_fx = slope_fx * 
     :                 ( fx - 
     :                 dble ( xsd_x_coords( pointer + i - 1 ) ) )
     :                 + dble ( xsd_x_coords( pointer + i - 1 ) ) 

c final calculation considering offset

                  dx = fx - ax
                  dt = dt_fx - dt_ax
                  slope = dt / dx
                  tx = slope *  ( fx - xsd_x_coords( pointer + j - 1 ) )
     :                 + dble ( xsd_x_coords( pointer + j - 1 ) )
                  
                  return

               endif

            endif

         ENDDO

c if we made it to here then must have fx > segment

         bail_out = .true.
         return

      ELSE

c return to calling routine with bail_out set to .true.

         return

      ENDIF   

c if made it to here then something is fishy

      write(LERR,*)' '
      write(LERR,*)' Somehting fishy in tvd suboutine offsetslopetime.F'
      write(LERR,*)'FATAL for now'
      stop

      end
