C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine VelocityRead ( luvel, vel_NumFcns, vel_size, v0,
     :     vel_NumPoints, vel_shotpoint, vel_times, vel_velocities )

c read the entire tdfn velocity function into memory using three arrays
c vel_shotpoint, vel_times and vel_velocites.  We know coming in that 
c there are vel_NumFcns functions and each function has vel_NumPoints[]
c number of cards associated with it.  So, all we have to do is 
c whip through the file and load it.  The only thing we have to check
c for is the number of non-zero time entries on the last card.  We also
c have to install the v0 entry and replace vel_NumPoints[] with the actual 
c number of function elements for that function location.

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer luvel, vel_NumFcns, vel_size
      integer vel_NumPoints(SZLNHD), vel_shotpoint(vel_size)

      real vel_times(vel_size), vel_velocities(vel_size)

      real*8 v0

c declare local variables

      integer count, ishotpoint, CardNumber, ThisRec, limit
      integer pointer, tmp_pointer, i, jj, kk
      integer iunit(SZLNHD), ivelocity(SZLNHD)
      integer tmp_shotpoint(SZLNHD)

      real tmp_times(SZLNHD), tmp_velocities(SZLNHD)

c initialize variables

c make sure count = 1 on the first iteration of the inner loop so that
c the correct function element count is maintained

      pointer = 0
 
      DO 1000 jj = 1, vel_NumFcns

         count = 0 - 6
         limit = vel_NumPoints(jj)

         DO kk = 1, limit
 
c advance function element count

            count = count + 7

c read next tdfn card
 
            read ( luvel, 10, end=999, err=990 ) CardNumber,
     :           (iunit(i),ivelocity(i), i = count , count + 6 ), 
     :           ishotpoint
            
 10         format(i1,4x,7(I4,I5),7X,I5)
 
c POLICEMAN: if ishotpoint = 0 then you have a completely blank card in the file
c            or have forgotten to enter a function index on the TDFN card
c            the former likely a blank card at the end of the file, the
c            latter is a disaster
 
            if ( ishotpoint .eq. 0 ) then
               if ( iunit(1) .eq. 0 .and. ivelocity(1) .eq. 0 ) then
                  write(LERR,*)' '
                  write(LERR,*)'TVD: Have encountered a blank card in'
                  write(LERR,*)'       your TDFN file.  Will ignore and'
                  write(LERR,*)'       continue'
                  write(LERR,*)'Warning'
                  goto 999
               else
                  write(LERR,*)'TVD: Have encountered a blank record'
                  write(LERR,*)'       number entry in your TDFN file.'
                  write(LERR,*)'FATAL'
                  write(LER,*)' '
                  write(LER,*)'TVD: Have encountered a blank record'
                  write(LER,*)'       number entry in your TDFN file.'
                  write(LER,*)'FATAL'
                  stop
               endif
            endif
 
            if ( count .eq. 1 ) ThisRec = ishotpoint
 
            if ( CardNumber .ne. 9 ) then

               do i = count, count + 6
                  pointer = pointer + 1

c again here we assume time in milliseconds, if we need a time units
c on the commandline [i.e. microseconds] we can do that later...Garossino

                  vel_times(pointer) = float( iunit(i) ) / 1000. 
                  vel_velocities(pointer) = float(ivelocity(i))
                  vel_shotpoint(pointer) = ishotpoint
               enddo
 
c POLICEMAN: watch for record number changes within a function
 
               if ( ishotpoint .ne. ThisRec ) then
                  write(LERR,*)'TVD: The record number has changed'
                  write(LERR,*)'       within a velocity function on'
                  write(LERR,*)'       you TDFN cards at record number'
                  write(LERR,*)'      ',ThisRec
                  write(LERR,*)'FATAL'
                  write(LER,*)'TVD: The record number has changed'
                  write(LER,*)'       within a velocity function on'
                  write(LER,*)'       you TDFN cards at record number'
                  write(LER,*)'      ',ThisRec
                  write(LER,*)'FATAL'
                  stop
               endif
               
            else
 
c have reached the end of the input velocity function for this record
c load last remaining vel_times,velocity pairs and return

               do i = count, count + 6
 
                  if(iunit(i) .ge. 0 .and. ivelocity(i) .gt. 0) then
 
c only add elements to velocity function if they exist

                     pointer = pointer + 1
 
                     vel_times(pointer) = float( iunit(i) ) / 1000.
                     vel_velocities(pointer) = float(ivelocity(i))
                     vel_shotpoint(pointer) = ishotpoint
                     vel_NumPoints(jj) = i
                  else
                     vel_NumPoints(jj) = i - 1
                     goto 100
                  endif
               enddo
 
               vel_NumPoints(jj) = count + 6
               goto 100
 
            endif
         ENDDO
 
 100     continue

         do i = 2, vel_NumPoints(jj)
 
c POLICEMAN: check for increasing vel_times in function
 
            if ( ( vel_times(i-1) - vel_times(i) ) .ge. 1.e-32 ) then
               write(LERR,*)'TVD: Units decrease in your input TDFN '
               write(LERR,*)'       velocity function at record number '
               write(LERR,*)'       ',ThisRec,'. The Units involved'
               write(LERR,*)'       are ', vel_times(i-1), ' and ',
     :              vel_times(i)
               write(LERR,*)'FATAL'
               write(LER,*)'TVD: Units decrease in your input TDFN '
               write(LER,*)'       velocity function at record number '
               write(LER,*)'       ',ThisRec,'. The Units involved'
               write(LER,*)'       are ', vel_times(i-1), ' and ',
     :              vel_times(i)
               write(LER,*)'FATAL'
               stop
            endif
 
 
c POLICEMAN: check for zero velocity entry
 
            if ( vel_velocities(i-1) .lt. 1.e-32
     :           .or. vel_velocities(i) .lt. 1.e-32 ) then
               write(LERR,*)'TVD: you have a zero velocity entry in '
               write(LERR,*)'     your input velocity function at '
               write(LERR,*)'     record number ',ThisRec,'. The '
               write(LERR,*)'     Units involved are ', vel_times(i-1), 
     :              ' and ', vel_times(i)
               write(LERR,*)'FATAL'
               write(LER,*)'TVD: you have a zero velocity entry in your'
               write(LER,*)'       input velocity function at record'
               write(LER,*)'       number ',ThisRec,'. The Units '
               write(LER,*)'       involved are ', vel_times(i-1), 
     :              ' and ', vel_times(i)
               write(LER,*)'FATAL'
               stop
            endif
         enddo

c install v0 entry with a time pick at time zero if not already there

         tmp_pointer = pointer - vel_NumPoints(jj) + 1

         if ( vel_times(tmp_pointer) .gt. 0.0 ) then

            do i = 1, vel_NumPoints(jj)
               tmp_times(i) = vel_times(tmp_pointer + i - 1)
               tmp_velocities(i) = vel_velocities(tmp_pointer + i - 1)
               tmp_shotpoint(i) = vel_shotpoint(tmp_pointer + i - 1)
            enddo

            vel_times(tmp_pointer) = 0.0
            vel_velocities(tmp_pointer) = sngl(v0)

            do i = 1, vel_NumPoints(jj)
               vel_times(tmp_pointer + i) = tmp_times(i)
               vel_velocities(tmp_pointer + i) = tmp_velocities(i)
               vel_shotpoint(tmp_pointer + i) = tmp_shotpoint(i)
            enddo

            vel_NumPoints(jj) = vel_NumPoints(jj) + 1

c adjust the array pointer to account for the extra entry            

            pointer = pointer + 1

         endif

         
 
 1000 CONTINUE
 
      return
 
 990  continue
 
      write(LERR,*)'TVD: error reading TDFN velocity function'
      write(LERR,*)'       at input record',ThisRec
      write(LERR,*)'FATAL'
      write(LER,*)'TVD: error reading TDFN velocity function'
      write(LER,*)'       at input record',ThisRec
      write(LER,*)'FATAL'
      stop
 
 999        continue

c hmmmmmmmm...in run time debug mode I better check out what has to 
c happen here.....
 
      if ( count .lt. 0 .and. pointer .eq. 0 ) goto 990
      return

      end
