C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine VelocityXcoord( vel_NumFcns, vel_size, vel_NumPoints, 
     :     vel_shotpoint, vel_x_coords, ShotInterval )

c routine to assign an x coordinate to each velocity location.  The
c x axis starts at sequential shot location 1 at coordinate zero.

#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer vel_NumFcns, vel_size
      integer vel_NumPoints(SZLNHD)
      integer vel_shotpoint(vel_size)

      real vel_x_coords(vel_size)

      real*8 ShotInterval

c declare local variables

      integer i, j, pointer

c initialize variables

      pointer = 0 - vel_NumPoints(1)

      do i = 1, vel_NumFcns

         pointer = pointer + vel_NumPoints(i)

         do j = 1, vel_NumPoints(i)

            vel_x_coords(pointer + j) = 
     :           float( vel_shotpoint(pointer + j) - 1 ) * 
     :           sngl(ShotInterval)

         enddo
      enddo

      return
      end

            
