C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dinterp ( lim, time, vstak, htime, hvstk )

c routine to return an interpolated velocity for a given horizon time

c declare variables passed from calling routine

      integer lim

      real time(lim)

      real*8 htime, hvstk, vstak(lim)

c declare local variables

      integer i

      real*8  fractn

c find position of htime within the function

      do i = 1, lim
         if ( sngl( htime ) .lt. time(i) ) goto 1
      enddo

      i = lim

c calculate the value of hvstk

1     if ( sngl( htime ) .lt. time(1) ) then

c --- extrapolate ---

         hvstk = vstak(1)

      elseif ( sngl ( htime ) .gt. time(lim) ) then

c --- extrapolate ---

         hvstk = vstak(LIM)

      else

c --- interpolate ---

         fractn = ( dble( time(i) -time(i-1) ) - 
     :        ( dble( time(i) ) - htime ) ) / 
     :        dble( time(i) - time(i-1) )

         hvstk = ( vstak(i) - vstak(i-1) ) * fractn + vstak(i-1)

      endif

      return
      end
