C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DSCAL1(X,N,S)
C**********************************************************************
C     THIS SUBROUTINE MULTIPLIES EVERY VALUE OF AN ARRAY BY A SCALE
C     FACTOR, S.
C     THIS IS THE DOUBLE PRECISION VERSION OF SUBROUTINE SCALE
C*****SUBROUTINE INPUTS
C     X = THE ARRAY OF VALUES TO BE SCALED.
C     N = THE LENGTH OF X.
C     S = THE SCALING FACTOR
C*****SUBROUTINE OUTPUTS
C     X = THE ORIGINAL VALUES OF X MULTIPLIED BY S
C***********************************************************************
      REAL*8 X(N),S
      DO 2 I = 1,N
C***********************************************************************
C     CHECKS TO VERIFY WHETHER AN UNDER FLOW ERROR WILL OCCUR OWING
C     TO THE PRESENCE OF LARGE NEGATIVE EXPONENTS. THE LIMIT ON THE
C      IBM 370 IS 10E-78. NUMBERS SMALLER THAN THIS ARE SET TO ZERO.
C***********************************************************************
      IF(DABS(X(I)).LT.10.0E-78.OR.DABS(S).LT.10.E-78) THEN
        X(I)= 0.0
        GOTO 2
      ELSE IF((DLOG10(DABS(X(I))) + DLOG10(DABS(S))).LE.-78.) THEN
          X(I) = 0.
          ELSE
          X(I) = X(I) * S
          ENDIF
    2   CONTINUE
      RETURN
      END
