C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine output ( t, d, v, co, Analysis_NumHorizons, domain, 
     :     Analysis_Shotpoint, line, c, x, nchan, BoatDirection, umin, 
     :     dp, lu_sred, lu_rred, lu_sgreen, lu_rgreen, 
     :     lu_truedip )

c routine to output (t,v,d) function data to required files
C ADDRESS      FILE
C -------      ----------
C  40          SOURCE RED
C  41          SOURCE GREEN
C  50          RECEIVER RED
C  51          RECEIVER GREEN
C  60          truedip file

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer Analysis_NumHorizons, domain, Analysis_Shotpoint
      integer nchan, lu_sred, lu_rred, lu_sgreen, lu_rgreen, lu_truedip  

      character*1 co(SZLNHD)

      character line*256

      real BoatDirection

      real*8 t(SZLNHD), d(SZLNHD), v(SZLNHD), c(SZLNHD)
      real*8 x(SZLNHD), umin(SZLNHD), dp(SZLNHD)

c declare local variables

      integer i

c initialize variables


c multiply dip by -1 to convert to unsigned distance used by amoco in 
c processing in -ve td space
c
c this is when BoatDirection=0,domain=1 or BoatDirection=1,domain=0
c
c or in English
c
c when the boat is going right --> left and we have receiver data
c  or
c when the boat is going left --> right and we have shot data
c
c in either of these cases we are working on the left hand side of the
c [t-x] diagram i.e. negative x dimension
c

c      if ( domain .ne. ifix(BoatDirection) ) then
c         do i = 1, Analysis_NumHorizons
c            d(i) = -1. * d(i)
c         enddo
c      endif

c write to appropriate tweak files                                      

      if ( domain .eq. 1 ) then

         if ( co(1) .eq. 'r' ) 
     :        write(lu_rred,40) line(1:14), Analysis_Shotpoint, 
     :        Analysis_NumHorizons

         if ( co(1) .eq. 'g' )
     :        write(lu_rgreen,40) line(1:14), Analysis_Shotpoint,
     :        Analysis_NumHorizons

         if ( co(1) .eq. 'g' )
     :        write(lu_truedip,40) line(1:14), Analysis_Shotpoint,
     :        Analysis_NumHorizons

         do i = 1, Analysis_NumHorizons

            if ( co(i) .eq. 'r' )
     :           write(lu_rred,20) t(i), d(i), v(i), co(i), umin(i)
            if ( co(i) .eq. 'g' )
     :           write(lu_rgreen,20) t(i), d(i), v(i), co(i), umin(i)
            if ( co(i) .eq. 'r' )
     :           write(lu_truedip,20) t(i), dp(i), v(i), co(i), umin(i)

         enddo

      else

c write shot red files

         if ( co(1) .eq. 'r' )
     :        write(lu_sred,40) line(1:14), Analysis_Shotpoint,
     :        Analysis_NumHorizons

         if ( co(1) .eq. 'g' )
     :        write(lu_sgreen,40) line(1:14), Analysis_Shotpoint,
     :        Analysis_NumHorizons

         if ( co(1) .eq. 'r' )
     :        write(lu_truedip,40) line(1:14), Analysis_Shotpoint,
     :        Analysis_NumHorizons

         do i = 1, Analysis_NumHorizons

            if ( co(i) .eq. 'r' )
     :        write(lu_sred,20) t(i), d(i), v(i), co(i), umin(i)

            if ( co(i) .eq. 'g' )
     :        write(lu_sgreen,20) t(i), d(i), v(i), co(i), umin(i)

            if ( co(i) .eq. 'r' )
     :        write(lu_truedip,20) t(i), dp(i), v(i), co(i), umin(i)

         enddo

      endif

      return

c formats

 20      format(F6.3,2(F6.0,2X),1X,A1,3X,F10.7,4X,F5.0,12X,F5.0)

 40   format(' LINE NUMBER:',2X,A14,/,' SHOT POINT',2X,I6,' Number horiz
     *ons',2x,i6,
     *//,
     *' TIME    DIP   VSTAK  COLOR  TWEAK MS ',/,
     *' ----    ---   -----  -----  --------')

      end
