C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine td ( c, nchan, bail_out )

#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer nchan
      
      real*8 c(SZLNHD)

      logical bail_out

c declare local variables

      real*8 theta, z, v, tz, h, t0, radius

c              primary   c(5) = h
c                        c(6) = velocity
c                        c(7) = t(0)
c                        c(8) = dip (radians)
c                        c(11) = gap
c                        c(13) = 2way time to primary at analysis point
c                                ie(2*z/v)
c 

c this routine calculates the  far offset value of the time distance
c curve as well as z,h and t0 

c where: theta is dip in radians
c        z is vertical depth to event
c        v is average velocity to event
c        tz is the vertical time at zero offset
c        h is minimum distance from event to source
c        t0 is zero offset time

c initialize variables

      theta = c(8)
      v = c(6)
      tz = c(13)

      if ( dabs(theta) .gt. 1.e-20 ) 
     :     radius = ( tz * v / ( 2.d0 * dcos(theta) ) ) / dtan(theta)

      if ( dabs(theta) .lt. 1.e-20 ) then
        z = tz * v / 2.d0
        h = z
       else
         z = radius * dtan(theta)
         h = z * dcos(theta)
      endif

      t0 = 2.d0 * h / v

      if ( h .lt. c(11) ) then
         bail_out = .true.
         return
      endif

      c(5) = h
      c(7) = t0

      return
      end
