C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tvd_sort (n, x, y, z, t, a, b, ca)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array Y.                 * C
C *                                                                  * C
C ******************************************************************** C
      real x(*), y(*), z(*), t(*), a(*), b(*)
      real xx, yy, zz, tt, aa, bb
      integer n
      character*1 ca(n), cca

      if (n .le. 1) return

      n2 = n/2+1
      ni = n

1     continue

       if (n2 .gt. 1) then

         n2 = n2-1
         xx = x(n2)
         yy = y(n2)
         zz = z(n2)
         tt = t(n2)
         aa = a(n2)
         bb = b(n2)
         cca = ca(n2)

       else

         xx = x(ni)
         yy = y(ni)
         zz = z(ni)
         tt = t(ni)
         aa = a(ni)
         bb = b(ni)
         cca = ca(ni)
         x(ni) = x(1)
         y(ni) = y(1)
         z(ni) = z(1)
         t(ni) = t(1)
         a(ni) = a(1)
         b(ni) = b(1)
         ca(ni) = ca(1)
         ni = ni-1

         if (ni .eq. 1) then
           x(1) = xx
           y(1) = yy
           z(1) = zz
           t(1) = tt
           a(1) = aa
           b(1) = bb
           ca(1) = cca
           return
         endif

       endif

       i = n2
       j = 2*n2

2      continue

       if (j .le. ni) then

         if (j .lt. ni) then
           if (x(j) .lt. x(j+1)) j = j+1
         endif

         if (xx .lt. x(j)) then
           x(i) = x(j)
           y(i) = y(j)
           z(i) = z(j)
           t(i) = t(j)
           a(i) = a(j)
           b(i) = b(j)
           ca(i) = ca(j)
           i = j
           j = 2*j
         else
           j = ni+1
         endif

         go to 2 

       endif

       x(i) = xx
       y(i) = yy
       z(i) = zz
       t(i) = tt
       a(i) = aa
       b(i) = bb
       ca(i) = cca

       go to 1 

       end
