C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Vel_Dip_traces( vel_trace, dip_trace, nsamp, nsi, 
     :     UnitSC, usp_record_index, NumFcns, NumEntries, size, 
     :     time, velocity, dip, tvd_index, verbos )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer nsamp, nsi, usp_record_index, size
      integer NumFcns
      integer NumEntries(NumFcns), tvd_index(NumFcns)

      real UnitSC
      real vel_trace(nsamp), dip_trace(nsamp)
      real time(size), dip(size), velocity(size)

      logical verbos

c declare local variables

      integer pointer, pointer1, pointer2, i

      real dip_trace1(SZLNHD), dip_trace2(SZLNHD)
      real vel_trace1(SZLNHD), vel_trace2(SZLNHD)

      logical done

c initialize variables

c locate tvd functions that span usp record location

      if ( usp_record_index .le. tvd_index(1) ) then

c usp index is prior to first t,v,d function

         call BuildTrace ( NumEntries(1), time(1), velocity(1), nsamp, 
     :        nsi, UnitSC, vel_trace )
         call BuildTrace ( NumEntries(1), time(1), dip(1), nsamp, 
     :        nsi, UnitSC, dip_trace )

         return

      elseif ( usp_record_index .ge. tvd_index(NumFcns) ) then

c usp index is after last t,v,d function

         pointer = 1

         do i = 1, NumFcns - 1
            pointer = pointer + NumEntries(i)
         enddo

         call BuildTrace ( NumEntries(NumFcns), time(pointer), 
     :        velocity(pointer), nsamp, nsi, UnitSC, vel_trace )
         call BuildTrace ( NumEntries(NumFcns), time(pointer), 
     :        dip(pointer), nsamp, nsi, UnitSC, dip_trace )

         return

      else

c usp index within t,v,d, function set, need to interpolate

         i = 2
         pointer = 1

         done = .false.

         do while ( .not. done )

            pointer = pointer + NumEntries(i-1)

            if ( usp_record_index .le. tvd_index(i) ) then
               done = .true.
               pointer1 = pointer
               pointer2 = pointer + NumEntries(i)
               num1 = NumEntries(i-1)
               num2 = NumEntries(i)
               index1 = tvd_index(i-1)
               index2 = tvd_index(i)
            else
               i = i + 1
               if ( i .gt. NumFcns ) then
                  write(ler,*)' something fuuked up'
                  stop
               endif
            endif

         enddo

         call BuildTrace ( num1, time(pointer1), velocity(pointer1), 
     :        nsamp, nsi, UnitSc, vel_trace1 )
         call BuildTrace ( num1, time(pointer1), dip(pointer1), 
     :        nsamp, nsi, UnitSc, dip_trace1 )
         call BuildTrace ( num2, time(pointer2), velocity(pointer2), 
     :        nsamp, nsi, UnitSc, vel_trace2 )
         call BuildTrace ( num2, time(pointer2), dip(pointer2), 
     :        nsamp, nsi, UnitSc, dip_trace2 )
         call InterpTrace ( nsamp, vel_trace1, index1, vel_trace2, 
     :        index2, usp_record_index, vel_trace )
         call InterpTrace (nsamp, dip_trace1, index1, dip_trace2, 
     :        index2, usp_record_index, dip_trace )

         return

      endif

      end




      
