C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#define VERBOSE

#ifdef SUNSYSTEM
      implicit   none
#endif

#define PPICK	1
#define GPICK	2

      character name*100
      integer numsmp, numtrc, numrec, ns, irs
      real dt
      integer idt
      integer lheader(SZLNHD)
      integer lhedlength, trlength, trdataoff
      integer ii, jj
      integer count
      integer argis, nblen, usprtrace, uspwtrace, uspclose
      integer uspdeadtrace
      character   getname * 100
      integer ierr, iabort
      integer jerr
      real        trace
      pointer     (ptrace, trace(2))
      character mode*100
      character clparam*100
      character wclparam*100
      integer   ierror, maxfile, maxcomp
      integer   pt
      integer   dptw
      integer   ikpsock
      integer   seekalot, seekstat
      integer   cinp
      character infile*100, outfile*100
      integer incon, outcon

      integer srptxc, srptyc, rcptxc, rcptyc
      real fsrptxc, fsrptyc, frcptxc, frcptyc
      integer sxo, sxi, rxo, rxi
      integer syo, syi, ryo, ryi
      real    ix1, iy1, ix2, iy2
      real    bi, bc
      real    ibx1, iby1, ibx2, iby2
      integer ibini, ibinc
      integer issynthetic
      integer srcloc, recind
      real grpint

      real vix, viy, vcx, vcy, vpx, vpy, vpi, vpc, norm
      real ccpx, ccpy

      real vp, rvp, tt, ttp, zz, rzz, gg, rgg

      real xx, xp

      character pfile*100, Gfile*100

      integer iret, initpick

#ifdef VERBOSE
      integer verbose
#endif

      name = getname()

      if ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0
     1          .or. argis ( '-help' ) .gt. 0 ) then

          write(LER,*)
     1'***************************************************************'

      write(LER,*) ' '
      write(LER,*) 'ccpbin'
      write(LER,*) ' '
      write(LER,*) '  arguments specifying binning geometry (default):'
      write(LER,*) '      -xs xs -ys ys  -xe xe -ye ye  -bi bi -bc bc'
      write(LER,*) ' '
      write(LER,*) '  vs/vp ratio and conversion-point depth:'
      write(LER,*) '                    -G G            -z z   or'
      write(LER,*) '                    -Gpik Gfiname   -z z   or'
      write(LER,*) '      -vp vp        -G G            -t t   or'
      write(LER,*) '      -Vpik pfiname -Gpik Gfiname   -t t   (etc).'
      write(LER,*) ' '
      write(LER,*) '  geometry (for synthetic datasets only):'
      write(LER,*) '      -synthetic  -gi grpint   or'
      write(LER,*) '      -sxo, -syo, -sxi, -syi,',
     1                  ' -rxo, -ryo, -rxi, and -ryi.'
      write(LER,*) ' '
#ifdef VERBOSE
      write(LER,*) '  For verbose log-file info: -verbose'
#endif
      write(LER,*) ' '
      write(LER,*) '  Standard USP windowing options: -ns -ne -rs -re'
      write(LER,*) '  (See USPIO)'
      write(LER,*) ' '
      write(LER,*) ' '
      write(LER,*) 'ccpbin'
      write(LER,*) 'writes CCP bin numbers into the USP trace headers'
      write(LER,*) 'CDPBCX and CDPBCY. CDPBCX contains the in-line'
      write(LER,*) 'bin number, and CDPBCY contains the cross-line'
      write(LER,*) 'bin number. The start and end of the binning'
      write(LER,*) 'line are determined by the USP-style arguments'
      write(LER,*) '-xs, -ys, -xe, -ye (all reals). xs and ys are'
      write(LER,*) 'X and Y coordinates of the start of the line,'
      write(LER,*) 'xe and ye the X and Y coordinates of the'
      write(LER,*) 'end of the line. If not specified, the geophone'
      write(LER,*) 'coordinates of the first and last traces in the'
      write(LER,*) 'data will be used.'
      write(LER,*) 'The inline and crossline bin sizes are set by'
      write(LER,*) '-bi and -bc (reals). If not specified, half the'
      write(LER,*) 'distance between the geophone coordinates of the'
      write(LER,*) 'first and second traces will be used.'
      write(LER,*) 'All these have the dimensions of SrPtXC, SrPtYC,'
      write(LER,*) 'RcPtXC, and RcPtYC.'
      write(LER,*) ' '
      write(LER,*) 'To do the binning properly you must set either'
      write(LER,*) ' z (depth of reflector of interest) and'
      write(LER,*) ' G (Vs/Vp ratio) or Gfiname (Vs/Vp pick file),'
      write(LER,*) 'OR'
      write(LER,*) ' vp (P velocity) or pfiname (P-wave velocity'
      write(LER,*) 'pick file), and G or Gfiname, and t.'
      write(LER,*) '(Make sure to use consistent units throughout.)'
      write(LER,*) ' '
      write(LER,*) 'If -synthetic is specified, then the shot and'
      write(LER,*) 'receiver positions will be calculated using'
      write(LER,*) 'SrcLoc, RecInd, and the group interval (specified'
      write(LER,*) 'via -gi on the command line) instead of'
      write(LER,*) 'SrPtXC and RcPtXC. (SrPtYC and RcPtYC will be'
      write(LER,*) 'assumed to be zero.)'
      write(LER,*) ' '
      write(LER,*) 'If the survey coordinates are not set'
      write(LER,*) 'in the input file, the X and Y start and increment'
      write(LER,*) 'for source and receiver can be set via'
      write(LER,*) '-sxo, -syo, -sxi, -syi, -rxo, -ryo, -rxi, and -ryi,'
      write(LER,*) 'instead (all reals).'
      write(LER,*) 'This option is intended for synthetic data, so it'
      write(LER,*) 'assumes common shot gathers, with all receivers'
      write(LER,*) 'for every shot. (Both increments zero indicates'
      write(LER,*) 'the header value should be used.)'


          stop
      endif

#include <f77/open.h>



#ifdef VERBOSE
      if (argis('-verbose') .gt. 0) then
          verbose = 1
      else
          verbose = 0
      endif
#endif


      if (argis('-synthetic') .gt. 0) then
          issynthetic = 1

          call argr4 ('-gi', grpint,  0.,  0.)
          if (grpint .eq. 0.) then
              write (LERR, *) name(1:nblen(name)),
     1        ': Group Interval must be defined for synthetic data.'
              write (LER, *) name(1:nblen(name)),
     1        ': Group Interval must be defined for synthetic data.'
              stop
          endif
          write (LERR, *)
     1        'Synthetic 2D data with group interval ', grpint, '.'
      else
          issynthetic = 0
      endif


c
c    If synthetic data that doesn't have
c    SrPtXC, SrPtYC, RcPtXC, and RcPtYC,
c    use these instead.
c

      call argr4 ('-sxo', sxo,  0.,  0.)
      call argr4 ('-sxi', sxi,  0.,  0.)
      call argr4 ('-rxo', rxo,  0.,  0.)
      call argr4 ('-rxi', rxi,  0.,  0.)

      call argr4 ('-syo', syo,  0.,  0.)
      call argr4 ('-syi', syi,  0.,  0.)
      call argr4 ('-ryo', ryo,  0.,  0.)
      call argr4 ('-ryi', ryi,  0.,  0.)


c
c Get velocity and time arguments 
c
      call argstr('-Vpik', pfile, ' ', ' ')
c
c Oops! Make sure to look for "Gpik" before "G"!
c
      call argstr('-Gpik', Gfile, ' ', ' ')
      call argr4 ( '-t', tt,  -1.,  -1.)
      call argr4 ( '-vp', rvp,  -1.,  -1.)
      call argr4 ('-G', rgg,  -1.,  -1.)
      call argr4 ('-z', rzz,  -1.,  -1.)


c
c Do we have a usable combination in there?
c

c
c We need:
c
c G and z
c
c or
c
c P, G, and t.
c

      if (rgg .le. 0. .and. Gfile .eq. ' ') then

              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no Vs/Vp ratio (G) specified!'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no Vs/Vp ratio (G) specified!'
              stop

      endif

      if (Gfile .ne. ' ' .and. tt .le. 0.) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no time specified! ',
     1        '(Necessary for reading G file.)'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no time specified! ',
     1        '(Necessary for reading G file.)'
              stop
      endif

      if (rzz .le. 0.) then
c
c No Z given, so must have t and P then.
c

          if (tt .le. 0.) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no time specified!'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no time specified!'
              stop
          else
              write (LERR, *) 't= ', tt
          endif

          if (rvp .le. 0. .and. pfile .eq. ' ') then
              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no P velocity specified!'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no P velocity specified!'
              stop
          endif

      else
          write (LERR, *) 'z= ', rzz
      endif




c
c Initialize USPIO, and open the input file
c
      maxfile = 2
      maxcomp = 1
      call uspioinit(name,maxfile,maxcomp)


      ierror = 0
      mode = 'r'
      clparam = ' '
      wclparam = ' '
      dptw = 0
      ikpsock = 0
      seekalot = 0
      call uspsinput(mode, clparam,
     1      wclparam, dptw,
     1      ikpsock, seekalot, seekstat,
     1      numsmp, numtrc, numrec, dt,
     1      ns, irs, pt,
     1      lheader, lhedlength,
     1      trlength, trdataoff, infile,
     1      incon, ierror)


c
c Allocate trace space
c
      iabort = 1
      call galloc (ptrace, trlength * SZSMPD,
     1                    ierr, iabort)



c
c    Get arguments related to bin sizes and directions
c
      call argr4 ('-xs', ix1,  0.,  0.)
      call argr4 ('-xe', ix2,  0.,  0.)
      call argr4 ('-ys', iy1,  0.,  0.)
      call argr4 ('-ye', iy2,  0.,  0.)

      if (ix1 .eq. 0. .and. ix2 .eq. 0. .and.
     1    iy1 .eq. 0. .and. iy2 .eq. 0.
     1    .and. seekstat .ne. 0 .and.
     1    rxi .eq. 0 .and. ryi .eq. 0) then

          write (LERR,*) name(1:nblen(name)),
     1     ': Error, no line limits given,',
     1     ' and cannot rewind input data.'
          write (LER,*) name(1:nblen(name)),
     1     ': Error, no line limits given,',
     1     ' and cannot rewind input data.'
          stop

      endif

      if (ix1 .eq. 0. .and. ix2 .eq. 0. .and.
     1    iy1 .eq. 0. .and. iy2 .eq. 0.
     1    .and. seekstat .eq. 0) then

          write (LERR,*) name(1:nblen(name)),
     1     ': No line limits given; scanning data to determine line',
     1     ' direction.'
          write (LER,*) name(1:nblen(name)),
     1     ': No line limits given; scanning data to determine line',
     1     ' direction.'

c
c Calculate location info for first trace
c
          ii = 1

          if (rxi .eq. 0 .and. ryi .eq. 0) then
c
c Seek to beginning and read
c

 100          continue
              if (ii .le. numtrc*numrec) then
                  call uspseek(incon, ii)
              else
                  write (LERR , *) name(1:nblen(name)),
     1            ': No live traces.'
                  write (LER , *) name(1:nblen(name)),
     1            ': No live traces.'
                  stop
              endif

              if (usprtrace(incon, trace, trlength) .ne. 0) then
                  write (LERR , *) name(1:nblen(name)),
     1            ': Could not read first trace.'
                  write (LER , *) name(1:nblen(name)),
     1            ': Could not read first trace.'
                  stop
              endif

              if (uspdeadtrace(trace) .ne. 0) then
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Trace ', ii,
     1                                ' is dead. Going forward one.'
                  endif
#endif
                  ii = ii + 1
                  goto 100
              endif

              if (issynthetic .eq. 0) then
c
c For field data, use RcPtXC and RcPtYC.
c
                  call saver(trace, 'RcPtXC', rcptxc, TRACEHEADER)
                  call saver(trace, 'RcPtYC', rcptyc, TRACEHEADER)
                  frcptxc = rcptxc
                  frcptyc = rcptyc
              else
c
c For synthetic datasets, use RecInd.
c
                  call saver(trace, 'RecInd', recind, TRACEHEADER)
                  frcptxc = real(recind) * grpint
                  frcptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting receiver increments on the command line.
c
              frcptxc = rxo + (ii-1) * rxi
              frcptyc = ryo + (ii-1) * ryi
          endif

          ix1 = frcptxc
          iy1 = frcptyc



c
c Calculate location info for last trace
c
          ii = numtrc*numrec

          if (rxi .eq. 0 .and. ryi .eq. 0) then

 200          continue
              if (ii .ge. 1) then
                  call uspseek(incon, ii)
              else
                  write (LERR , *) name(1:nblen(name)),
     1            ': No live traces.'
                  write (LER , *) name(1:nblen(name)),
     1            ': No live traces.'
                  stop
              endif


              if (usprtrace(incon, trace, trlength) .ne. 0) then
                  write (LERR, *) name(1:nblen(name)),
     1            ': Could not read last trace.'
                  write (LER , *) name(1:nblen(name)),
     1            ': Could not read last trace.'
                  stop
              endif

              if (uspdeadtrace(trace) .ne. 0) then
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Trace ', ii,
     1                                ' is dead. Going back one.'
                  endif
#endif
                  ii = ii - 1
                  goto 200
              endif

c
c Rewind back to the beginning again
c
              call uspseek(incon, 1)

              if (issynthetic .eq. 0) then
c
c For field data, use RcPtXC and RcPtYC.
c
                  call saver(trace, 'RcPtXC', rcptxc, TRACEHEADER)
                  call saver(trace, 'RcPtYC', rcptyc, TRACEHEADER)
                  frcptxc = rcptxc
                  frcptyc = rcptyc
              else
c
c For synthetic datasets, use RecInd.
c
                  call saver(trace, 'RecInd', recind, TRACEHEADER)
                  frcptxc = real(recind) * grpint
                  frcptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting receiver increments on the command line.
c
              frcptxc = rxo + (ii-1) * rxi
              frcptyc = ryo + (ii-1) * ryi
          endif
 
          ix2 = frcptxc
          iy2 = frcptyc


          write (LER, *)
     1            'Calculated line limits (', ix1, iy1, ') to (',
     1            ix2, iy2, ').'

      endif


      write (LERR, *) 'Line limits (', ix1, iy1, ') to (',
     1                ix2, iy2, ')'


c
c Get inline and crossline binning information
c If necessary determine these from the data.
c
 
      call argr4 ('-bi', bi,  0.,  0.)
      call argr4 ('-bc', bc,  0.,  0.)
 
      if (bi .eq. 0.
     1    .and. seekstat .ne. 0 .and.
     1    rxi .eq. 0 .and. ryi .eq. 0) then

          write (LERR,*) name(1:nblen(name)),
     1     ': Error, no bin size given,',
     1     ' and cannot rewind input data.'
          write (LER,*) name(1:nblen(name)),
     1     ': Error, no bin size given,',
     1     ' and cannot rewind input data.'
          stop

      endif

      if (bi .eq. 0.) then

          write (LERR,*) name(1:nblen(name)),
     1     ': No bin size given; scanning data to determine one.'
          write (LER,*) name(1:nblen(name)),
     1     ': No bin size given; scanning data to determine one.'

c
c Calculate location info for first trace
c

          ii = 1

          if (rxi .eq. 0 .and. ryi .eq. 0) then
c
c Seek to beginning and read
c

 300          continue
              if (ii .le. numtrc*numrec) then
                  call uspseek(incon, ii)
              else
                  write (LERR , *) name(1:nblen(name)),
     1            ': No live traces.'
                  write (LER , *) name(1:nblen(name)),
     1            ': No live traces.'
                  stop
              endif
 
              if (usprtrace(incon, trace, trlength) .ne. 0) then
                  write (LERR , *) name(1:nblen(name)),
     1            ': Could not read first trace.'
                  write (LER , *) name(1:nblen(name)),
     1            ': Could not read first trace.'
                  stop
              endif
 
              if (uspdeadtrace(trace) .ne. 0) then
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Trace ', ii,
     1                                ' is dead. Going forward one.'
                  endif
#endif
                  ii = ii + 1
                  goto 300
              endif


              if (issynthetic .eq. 0) then
c
c For field data, use RcPtXC and RcPtYC.
c
                  call saver(trace, 'RcPtXC', rcptxc, TRACEHEADER)
                  call saver(trace, 'RcPtYC', rcptyc, TRACEHEADER)
                  frcptxc = rcptxc
                  frcptyc = rcptyc
              else
c
c For synthetic datasets, use RecInd.
c
                  call saver(trace, 'RecInd', recind, TRACEHEADER)
                  frcptxc = real(recind) * grpint
                  frcptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting receiver increments on the command line.
c
              frcptxc = rxo + (ii-1) * rxi
              frcptyc = ryo + (ii-1) * ryi
          endif

          ibx1 = frcptxc
          iby1 = frcptyc


c
c Go forward to the next live trace
c
          ii = ii + 1
          count = 1

          if (rxi .eq. 0 .and. ryi .eq. 0) then
c
c Seek to the second trace and read
c

400           continue
              if (ii .le. numtrc*numrec) then
                  call uspseek(incon, ii)
              else
                  write (LERR , *) name(1:nblen(name)),
     1            ': Only one live trace.'
                  write (LER , *) name(1:nblen(name)),
     1            ': Only one live trace.'
                  stop
              endif

              if (usprtrace(incon, trace, trlength) .ne. 0) then
                  write (LERR, *) name(1:nblen(name)),
     1            ': Could not read second live trace.'
                  write (LER , *) name(1:nblen(name)),
     1            ': Could not read second live trace.'
                  stop
              endif

              if (uspdeadtrace(trace) .ne. 0) then
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Trace ', ii,
     1                                ' is dead. Going forward one.'
                  endif
#endif
                  ii = ii + 1
                  count = count + 1
                  goto 400
              endif

c
c Rewind back to the beginning again
c
              call uspseek(incon, 1)



              if (issynthetic .eq. 0) then
c
c For field data, use RcPtXC and RcPtYC.
c
                  call saver(trace, 'RcPtXC', rcptxc, TRACEHEADER)
                  call saver(trace, 'RcPtYC', rcptyc, TRACEHEADER)
                  frcptxc = rcptxc
                  frcptyc = rcptyc
              else
c
c For synthetic datasets, use RecInd.
c
                  call saver(trace, 'RecInd', recind, TRACEHEADER)
                  frcptxc = real(recind) * grpint
                  frcptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting receiver increments on the command line.
c
              frcptxc = rxo + (ii-1) * rxi
              frcptyc = ryo + (ii-1) * ryi
          endif

          ibx2 = frcptxc
          iby2 = frcptyc

c
c Calculate the distance between them; half that is the default
c inline bin size.
c
          bi = sqrt((ibx2-ibx1)**2 + (iby2-iby1)**2) / (2.*count)

          write (LER, *)
     1        'Calculated inline bin size: ', bi, '.'

          if (bi .eq. 0.) then
              write (LERR,*) name(1:nblen(name)),
     1         ': Error, zero bin size.'
              write (LER,*) name(1:nblen(name)),
     1         ': Error, zero bin size.'
              stop
          endif

      endif



 
c
c Crossline bin size defaults to 20 times inline bin size.
c
      if (bc .eq. 0.) then
          bc = bi * 20.
          write (LER, *)
     1        'Calculated crossline bin size: ', bc, '.'
      endif

      write (LERR, *) bi, ' inline bin length'
      write (LERR, *) bc, ' crossline bin width'



c
c    Figure out the rotated coordinate system
c    (vix, viy) is the inline bin vector
c    (vcx, vcy) is the crossline bin vector
c

      vix = ix2 - ix1
      viy = iy2 - iy1
      norm = sqrt(vix**2 + viy**2)

      if (norm .eq. 0.) then
          write (LERR, *) name(1:nblen(name)),
     1    ': Error, start and end of line at same location.'
          write (LER, *) name(1:nblen(name)),
     1    ': Error, start and end of line at same location.'
          stop
      endif

      vix = vix / norm
      viy = viy / norm

      vcx = viy
      vcy = -vix


      vix = vix / bi
      viy = viy / bi

      vcx = vcx / bc
      vcy = vcy / bc


      write (LERR, *) 'Inline binning normalization vector: ',
     1                 vix, ', ', viy, '.'
      write (LERR, *) 'Crossline binning normalization vector: ',
     1                 vcx, ', ', vcy, '.'




c
c Now that we have opened the input, we know how big it is, and so
c can specify default rs and re to initpick.
c
      if (rvp .le. 0. .and. pfile .ne. ' ') then
          iret = initpick(PPICK, pfile, irs, irs + numrec - 1)

          if (iret .ne. 0) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Could not open P velocity pick file ',
     2        pfile(1:nblen(pfile)), '.'
              write (LER,*) name(1:nblen(name)),
     1        ': Could not open P velocity pick file ',
     2        pfile(1:nblen(pfile)), '.'
              stop
          else
              write (LERR, *) 'p file= ', pfile(1:nblen(pfile))
          endif
      endif

      if (rgg .le. 0. .and. Gfile .ne. ' ') then
          iret = initpick(GPICK, Gfile, irs, irs + numrec - 1)

          if (iret .ne. 0) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Could not open G Vs/Vp ratio pick file ',
     2        Gfile(1:nblen(Gfile)), '.'
              write (LER,*) name(1:nblen(name)),
     1        ': Could not open G Vs/Vp ratio pick file ',
     2        Gfile(1:nblen(Gfile)), '.'
              stop
          else
              write (LERR, *) 'G file= ', Gfile(1:nblen(Gfile))
          endif
      endif





      mode = 'w'
      clparam = ' '
      cinp = incon
      ikpsock = 1
      seekalot = 0

      call uspsoutput (mode, clparam,
     1   cinp,
     1   ikpsock, seekalot, seekstat,
     1   numsmp, numtrc, numrec, dt,
     1   lheader, lhedlength, trlength, outfile,
     1   outcon, ierror)


c
c Yaohui's pick routines need dt as an integer, not a real.
c

      idt = nint(dt * 1000.)


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c Loop over gathers
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      do jj = 1, numrec


#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) '---------- Record #', jj,
     1        ' -----------------------------------------------'
          endif
#endif


c
c Calculate G and z for this gather
c

c
c First find G
c

          if (rgg .gt. 0.) then
c
c Simplest case: they simply provided us directly with it
c
              gg = rgg

          else

c
c Call Yaohui's routine to get the info we need from the pick file.
c Multiply time by 1000. according to USP convention.
c

              call sgetpick(GPICK, numsmp, idt, irs + jj - 1,
     1                      tt*1000., gg, 1., ttp)

c
c Correct for the bogus factor of 1000. in G.
c
              gg = gg / 1000.

              if (gg .le. 0.) then
                  write (LERR,*) name(1:nblen(name)),
     1            ': Got invalid G for record ', irs + jj - 1,
     2            ' from ', Gfile(1:nblen(Gfile)), ' of ', gg,
     3            ' .'
                  write (LER,*) name(1:nblen(name)),
     1            ': Got invalid G for record ', irs + jj - 1,
     2            ' from ', Gfile(1:nblen(Gfile)), ' of ', gg,
     3            ' .'
                  stop
              endif

          endif


c
c Now find Z
c

          if (rzz .gt. 0.) then
c
c Simplest case: they simply provided us directly with it
c
              zz = rzz

          else

              if (rvp .le. 0.) then

c
c Call Yaohui's routine to get the info we need from the pick file.
c Multiply time by 1000. according to USP convention. Provide G
c so the subroutine can convert from Tps to Tp.
c

                 call sgetpick(PPICK, numsmp, idt, irs + jj - 1,
     1                         tt*1000., vp, gg, ttp)

#ifdef VERBOSE
              if (verbose) then
                  write (LERR, *) 'tp=', ttp / 1000.
              endif
#endif

c
c P-velocity doesn't have to be divided by 1000.
c

                  if (vp .le. 0.) then
                      write (LERR,*) name(1:nblen(name)),
     1                ': Got invalid vp for record ', irs + jj - 1,
     2                ' from ', pfile(1:nblen(pfile)),
     3                ' of ', vp, ' .'
                      write (LER,*) name(1:nblen(name)),
     1                ': Got invalid vp for record ', irs + jj - 1,
     2                ' from ', pfile(1:nblen(pfile)),
     3                ' of ', vp, ' .'
                      stop
                  endif
              else
                  vp = rvp
              endif

#ifdef VERBOSE
              if (verbose) then
                  write (LERR, *) 'tps=', tt, '   vp=', vp
              endif
#endif

c
c Using t, vp, and G, calculate z.
c
              zz = tt / (1./vp + 1. / (gg * vp))

          endif



#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) 'z=', zz, '   G=', gg
          endif
#endif


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c Loop over traces within a gather
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      do ii = 1, numtrc

          if (usprtrace(incon, trace, trlength) .ne. 0) then
              write (LERR, *) name(1:nblen(name)),
     1                         ': Could not read trace ',
     1                         ii + (jj-1) * numtrc, '.'
              write (LER , *) name(1:nblen(name)),
     1                         ': Could not read trace ',
     1                         ii + (jj-1) * numtrc, '.'
              stop
          endif


          if (uspdeadtrace(trace) .ne. 0) then
c
c This trace is dead.
c Set the bin numbers to error values.
c
              ibini = -30000
              ibinc = -30000

              if (verbose) then
                  write (LERR, *) 'trace #', ii + (jj-1) * numtrc,
     1                            ' is DEAD.'
                  write (LERR, *) '    int bin # ', ibini, ibinc
              endif
c
c Skip over all the usual processing.
c
              goto 999
          endif



c
c Calculate location info for this point
c

          if (sxi .eq. 0. .and. syi .eq. 0.) then
              if (issynthetic .eq. 0) then
c
c For field data, use SrPtXC and SrPtYC.
c
                  call saver(trace, 'SrPtXC', srptxc, TRACEHEADER)
                  call saver(trace, 'SrPtYC', srptyc, TRACEHEADER)
                  fsrptxc = srptxc
                  fsrptyc = srptyc
              else
c
c For synthetic datasets, use (SrcLoc / 10.).
c
                  call saver(trace, 'SrcLoc', srcloc, TRACEHEADER)
                  fsrptxc = real(srcloc) * grpint / 10.
                  fsrptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting source increments on the command line.
c
              fsrptxc = sxo + (jj-1) * sxi
              fsrptyc = syo + (jj-1) * syi
          endif

          if (rxi .eq. 0 .and. ryi .eq. 0) then
              if (issynthetic .eq. 0) then
c
c For field data, use RcPtXC and RcPtYC.
c
                  call saver(trace, 'RcPtXC', rcptxc, TRACEHEADER)
                  call saver(trace, 'RcPtYC', rcptyc, TRACEHEADER)
                  frcptxc = rcptxc
                  frcptyc = rcptyc
              else
c
c For synthetic datasets, use RecInd.
c
                  call saver(trace, 'RecInd', recind, TRACEHEADER)
                  frcptxc = real(recind) * grpint
                  frcptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting receiver increments on the command line.
c
              frcptxc = rxo + (ii-1) * rxi
              frcptyc = ryo + (ii-1) * ryi
          endif



c
c    Now calculate the CCP point coordinate
c
          xx = sqrt((frcptxc-fsrptxc)**2 + (frcptyc-fsrptyc)**2)

          if (xx .gt. 0) then
c
c Yaohui's routine "getxp". This can blow up if gg > 1..
c

              call getxp (xx, zz, gg, xp)
              ccpx = fsrptxc + (xp / xx) * (frcptxc - fsrptxc)
              ccpy = fsrptyc + (xp / xx) * (frcptyc - fsrptyc)

          else
              ccpx = fsrptxc
              ccpy = fsrptyc
          endif


c
c    Now figure out which bin it goes in
c

c
c (ix1,iy1) is the start of the survey line; find the offset
c from there to this point.
c
          vpx = ccpx - ix1
          vpy = ccpy - iy1

c
c Project that offset onto the inline and crossline
c binning grid.
c
          vpi = vpx * vix + vpy * viy
          vpc = vpx * vcx + vpy * vcy

c
c Plunk it into the nearest bin.
c
          ibini = nint(vpi)
          ibinc = nint(vpc)

#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) 'trace #', ii + (jj-1) * numtrc
              write (LERR, *) '     Src ', fsrptxc, fsrptyc,
     1                        ', Rec ', frcptxc, frcptyc
              write (LERR, *) '     CCP bin coor ', ccpx, ccpy
              write (LERR, *) '     float bin # ', vpi, vpc,
     1                        ' --> int bin # ', ibini, ibinc
          endif
#endif

c
c    Modify the trace header to officially place it in that bin!
c

 999      continue
          call savew(trace, 'CDPBCX', ibini, TRACEHEADER)
          call savew(trace, 'CDPBCY', ibinc, TRACEHEADER)


          if (uspwtrace(outcon, trace, trlength) .ne. 0) then
              write (LERR, *) name(1:nblen(name)),
     1                        ': Could not write trace ',
     1                         ii + (jj-1) * numtrc, '.'
              write (LER , *) name(1:nblen(name)),
     1                         ': Could not write trace ',
     1                         ii + (jj-1) * numtrc, '.'
          endif


c
c End loops over trace and gather.
c
      enddo
      enddo



      if (uspclose(incon)) then
          write (LERR, *) 'Trouble closing input.'
          write (LER , *) 'Trouble closing input.'
      endif
      if (uspclose(outcon)) then
          write (LERR, *) 'Trouble closing output.'
          write (LER , *) 'Trouble closing output.'
      endif


c
c Done!
c

      stop      
      end
