C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


#define VERBOSE

#ifdef SUNSYSTEM
      implicit   none
#endif

#define PPICK	1
#define GPICK	2

      character name*100
      integer numsmp, irs, ire, nrec, stacor
      integer irsd, ired
      integer irn, itn
      integer argis, nblen
      character   getname * 100
      integer ierr, iabort
      integer jerr
      real        trace
      pointer     (ptrace, trace(2))

      integer srptxc, srptyc, rcptxc, rcptyc
      real fsrptxc, fsrptyc, frcptxc, frcptyc
      integer sxo, sxi, rxo, rxi
      integer syo, syi, ryo, ryi
      real    ix1, iy1, ix2, iy2
      real    bi, bc
      integer ibiniold, ibincold
      integer ibini, ibinc
      integer issynthetic
      integer srcloc, recind
      real grpint

      real vix, viy, vcx, vcy, vpx, vpy, vpi, vpc, norm
      real ccpx, ccpy

      real vp, rvp, tt, ttp, zz, rzz, gg, rgg

      real xx, xp

      character pfile*100, Gfile*100

      integer iret, initpick

#ifdef VERBOSE
      integer verbose
#endif

      integer nbins
      character   ntap * 100, otap * 100
      integer     luin , luout, lhbytes, nbytes
      integer     obytes, nsi
      integer     llhed ( SZLNHD )
      integer ierr1, ierr2

      integer firsttime, cbin, cbinval, dbinmax
      integer lagbin, leadbin, binoffset

      integer ii, jj, kk
      integer dropcount
      integer count
      integer tracecount

c
c The output data array. We will use this as a 2-dimensional array,
c with dimensions (Time, Bin)
c

c
c to get at the data
c
#define ODD(A,B) od(ITHWP1+((A)-1)+((B)-1)*(numsmp+ITHWP1-1))

#define TRACE(A) trace(ITHWP1+((A)-1))

c
c to get at the header
c
#define ODH(B) od(1+((B)-1)*(numsmp+ITHWP1-1))

c
c To keep track of how many times each sample has been hit.
c
#define ODND(A,B) odnorm(ITHWP1+((A)-1)+((B)-1)*(numsmp+ITHWP1-1))
#define ODNH(B) odnorm(1+((B)-1)*(numsmp+ITHWP1-1))

      real od
      pointer     (pod, od(2))
 
c
c This counts how many times each output bin is hit.
c
      integer odnorm
      pointer     (podn, odnorm(2))



      name = getname()

      if ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0
     1          .or. argis ( '-help' ) .gt. 0 ) then

          write(LER,*)
     1'***************************************************************'

      write(LER,*) ' '
      write(LER,*) 'ccpstck'
      write(LER,*) '  All these arguments are the same as used'
      write(LER,*) '  with ccpbin'
      write(LER,*) ' '
      write(LER,*) '  arguments specifying binning geometry (required):'
      write(LER,*) '      -xs xs -ys ys  -xe xe -ye ye  -bi bi -bc bc'
      write(LER,*) ' '
      write(LER,*) '  vs/vp ratio and conversion-point depth:'
      write(LER,*) '                  -G G          -z z   or'
      write(LER,*) '                  -Gpik Gfiname   -z z   or'
      write(LER,*) '      -vp vp      -G G          -t t   or'
      write(LER,*) '      -Vpik pfiname -Gpik Gfiname   -t t   (etc).'
      write(LER,*) ' '
      write(LER,*) '  geometry (for synthetic datasets only):'
      write(LER,*) '      -synthetic  -gi grpint   or'
      write(LER,*) '      -sxo, -syo, -sxi, -syi,',
     1                  ' -rxo, -ryo, -rxi, and -ryi.'
      write(LER,*) ' '
#ifdef VERBOSE
      write(LER,*) '  For verbose log-file info: -verbose'
#endif
      write(LER,*) ' '
      write(LER,*) ' Options for ccpstck only:'
      write(LER,*) ' '
      write(LER,*) ' -irs 1 -ire NumRec'
      write(LER,*) ' '
      write(LER,*) ' Minimum and maximum record number.'
      write(LER,*) ' These are not used to window the input, but'
      write(LER,*) ' for determining the range of record numbers'
      write(LER,*) ' that may be needed from pick files.'
      write(LER,*) ' '
      write(LER,*) ' '
      write(LER,*) ' -bins 500'
      write(LER,*) ' Sets the number of bins that ccpstck maintains'
      write(LER,*) ' in memory at a time. This sets how many bins'
      write(LER,*) ' a conversion point is allowed to drift laterally.'
      write(LER,*) ' '
      write(LER,*) 'ccpstck'
      write(LER,*) 'expects traces that have been run through ccpbin,'
      write(LER,*) 'and then sorted by inline bin number.'
      write(LER,*) 'On output, there should be one trace per inline bin'
      write(LER,*) 'number of ccpbin.'


          stop
      endif

#include <f77/open.h>



#ifdef VERBOSE
      if (argis('-verbose') .gt. 0) then
          verbose = 1
      else
          verbose = 0
      endif
#endif


c
c How many bins to allow for?
c
      call argi4 ('-bins', nbins, 500, 500)



      if (argis('-synthetic') .gt. 0) then
          issynthetic = 1

          call argr4 ('-gi', grpint,  0.,  0.)
          if (grpint .eq. 0.) then
              write (LERR, *) name(1:nblen(name)),
     1        ': Group Interval must be defined for synthetic data.'
              write (LER, *) name(1:nblen(name)),
     1        ': Group Interval must be defined for synthetic data.'
              stop
          endif
          write (LERR, *)
     1        'Synthetic 2D data with group interval ', grpint, '.'
      else
          issynthetic = 0
      endif


c
c    If synthetic data that doesn't have
c    SrPtXC, SrPtYC, RcPtXC, and RcPtYC,
c    use these instead.
c

      call argr4 ('-sxo', sxo,  0.,  0.)
      call argr4 ('-sxi', sxi,  0.,  0.)
      call argr4 ('-rxo', rxo,  0.,  0.)
      call argr4 ('-rxi', rxi,  0.,  0.)

      call argr4 ('-syo', syo,  0.,  0.)
      call argr4 ('-syi', syi,  0.,  0.)
      call argr4 ('-ryo', ryo,  0.,  0.)
      call argr4 ('-ryi', ryi,  0.,  0.)


c
c Get velocity and time arguments 
c
      call argstr('-Vpik', pfile, ' ', ' ')
      call argstr('-Gpik', Gfile, ' ', ' ')
      call argr4 ( '-t', tt,  -1.,  -1.)
      call argr4 ( '-vp', rvp,  -1.,  -1.)
      call argr4 ('-G', rgg,  -1.,  -1.)
      call argr4 ('-z', rzz,  -1.,  -1.)


c
c Do we have a usable combination in there?
c

c
c We need:
c
c G and z
c
c or
c
c P, G, and t.
c

      if (rgg .le. 0. .and. Gfile .eq. ' ') then

              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no Vs/Vp ratio (G) specified!'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no Vs/Vp ratio (G) specified!'
              stop

      endif

      if (Gfile .ne. ' ' .and. tt .le. 0.) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no time specified! ',
     1        '(Necessary for reading G file.)'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no time specified! ',
     1        '(Necessary for reading G file.)'
              stop
      endif

      if (rzz .le. 0.) then
c
c No Z given, so must have t and P then.
c

          if (tt .le. 0.) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no time specified!'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no time specified!'
              stop
          else
              write (LERR, *) 't= ', tt
          endif

          if (rvp .le. 0. .and. pfile .eq. ' ') then
              write (LERR,*) name(1:nblen(name)),
     1        ': Error, no P velocity specified!'
              write (LER,*) name(1:nblen(name)),
     1        ': Error, no P velocity specified!'
              stop
          endif

      else
          write (LERR, *) 'z= ', rzz
      endif



c**********************************************************************
c
c Done with initial setup... start reading input.
c
c
c Can't use USPIO because input and output are not well ordered!
c
c**********************************************************************


c
c Open up input. (We will read the input "trace by trace".)
c

      call argstr( '-N', ntap, ' ', ' ' )
      call getln(luin , ntap, 'r', 0)

c
c Open output.
c
      call argstr( '-O', otap, ' ', ' ' )
      call getln(luout , otap, 'w', 1)

c
c Read the input line header
c
      call rtape  (luin, llhed, lhbytes)

c
c Did we find it?
c

      if(lhbytes .eq. 0) then
         write(LER ,*) name(1:nblen(name)),
     :   ': no line header read from unit ', luin
         write(LERR,*) name(1:nblen(name)),
     :   ': no line header read from unit ', luin
         write(LER ,*) name(1:nblen(name)), ' FATAL'
         stop
      endif

c
c Find out the number of samples per trace and the sample interval
c
      call saver(llhed, 'NumSmp', numsmp, LINEHEADER)
      call saver(llhed, 'SmpInt', nsi  , LINEHEADER)



      if (numsmp .le. 0) then
         write(LER ,*) name(1:nblen(name)),
     1            ': Input line header indicates null input dataset.'
         write(LERR,*) name(1:nblen(name)),
     1            ': Input line header indicates null input dataset.'
         write(LERR,*) 'NumSmp=', numsmp
         write(LER ,*) name(1:nblen(name)), ' FATAL'
         stop
      endif

c
c Update the line header...
c
      call hlhprt (llhed, lhbytes, name, nblen(name), LERR)
      call savhlh(llhed,lhbytes,lhbytes)

c
c ...and write it out. Later after we know how many traces there
c actually will be in the output we can rewind and update this.
c
      call wrtape (luout, llhed, lhbytes)



c
c Calculate length of a trace
c
      obytes = SZTRHD + SZSMPD * numsmp


c
c Allocate space to write data
c

      iabort = 0
      call galloc (pod, obytes * nbins,
     1                    ierr1, iabort)
      call galloc (podn, obytes * nbins,
     1                    ierr2, iabort)

      if (ierr1 .ne. 0 .or. ierr2 .ne. 0) then
         write(LER ,*) name(1:nblen(name)),
     1     ': Could not allocate enough space for output trace buffer',
     2            numsmp, ' samples long.'
         write(LERR,*) name(1:nblen(name)),
     1     ': Could not allocate enough space for output trace buffer',
     2            numsmp, ' samples long.'
         write(LER ,*) name(1:nblen(name)), ' FATAL'
         stop
      endif



c
c Allocate input trace space... we do one at a time.
c
      iabort = 1
      call galloc (ptrace, obytes, ierr, iabort)




c
c    Get arguments related to bin sizes and directions
c
      call argr4 ('-xs', ix1,  0.,  0.)
      call argr4 ('-xe', ix2,  0.,  0.)
      call argr4 ('-ys', iy1,  0.,  0.)
      call argr4 ('-ye', iy2,  0.,  0.)

      if (ix1 .eq. 0. .and. ix2 .eq. 0. .and.
     1    iy1 .eq. 0. .and. iy2 .eq. 0.) then

          write (LERR,*) name(1:nblen(name)),
     1     ': Error, no line limits given.'
          write (LER,*) name(1:nblen(name)),
     1     ': Error, no line limits given.'
          stop

      endif


      write (LERR, *) 'Line limits (', ix1, iy1, ') to (',
     1                ix2, iy2, ')'


c
c Get inline and crossline binning information
c
 
      call argr4 ('-bi', bi,  0.,  0.)
      call argr4 ('-bc', bc,  0.,  0.)
 
      if (bi .eq. 0.) then

          write (LERR,*) name(1:nblen(name)),
     1     ': Error, no bin size given.'
          write (LER,*) name(1:nblen(name)),
     1     ': Error, no bin size given.'
          stop

      endif

c
c Crossline bin size defaults to 20 times inline bin size.
c
      if (bc .eq. 0.) then
          bc = bi * 20.
          write (LER, *)
     1        'Calculated crossline bin size: ', bc, '.'
      endif

      write (LERR, *) bi, ' inline bin length'
      write (LERR, *) bc, ' crossline bin width'



c
c    Figure out the rotated coordinate system
c    (vix, viy) is the inline bin vector
c    (vcx, vcy) is the crossline bin vector
c

      vix = ix2 - ix1
      viy = iy2 - iy1
      norm = sqrt(vix**2 + viy**2)

      if (norm .eq. 0.) then
          write (LERR, *) name(1:nblen(name)),
     1    ': Error, start and end of line at same location.'
          write (LER, *) name(1:nblen(name)),
     1    ': Error, start and end of line at same location.'
          stop
      endif

      vix = vix / norm
      viy = viy / norm

      vcx = viy
      vcy = -vix


      vix = vix / bi
      viy = viy / bi

      vcx = vcx / bc
      vcy = vcy / bc


      write (LERR, *) 'Inline binning normalization vector: ',
     1                 vix, ', ', viy, '.'
      write (LERR, *) 'Crossline binning normalization vector: ',
     1                 vcx, ', ', vcy, '.'



c
c Get starting, ending record numbers (required by initpick)
c

      call saver(llhed, 'NumRec', nrec , LINEHEADER)
      irsd = 1
      ired = nrec


      call argi4 ('-irs', irs,  0,  0)

      if (irs .eq. 0) then
          irs = 1
      endif


      call argi4 ('-ire', ire,  0,  0)

      if (ire .eq. 0) then
          ire = nrec
      endif



      if ((rvp .le. 0. .and. pfile .ne. ' ') .or.
     1    (rgg .le. 0. .and. Gfile .ne. ' ')) then


           write (LER,*) name(1:nblen(name)),
     1 ': Record numbers for pick files go from ', irs, ' to ', ire, '.'
           write (LERR,*) name(1:nblen(name)),
     1 ': Record numbers for pick files go from ', irs, ' to ', ire, '.'

      endif

c
c Now specify default rs and re to initpick.
c
      if (rvp .le. 0. .and. pfile .ne. ' ') then
          iret = initpick(PPICK, pfile, irs, ire)

          if (iret .ne. 0) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Could not open P velocity pick file ',
     2        pfile(1:nblen(pfile)), '.'
              write (LER,*) name(1:nblen(name)),
     1        ': Could not open P velocity pick file ',
     2        pfile(1:nblen(pfile)), '.'
              stop
          else
              write (LERR, *) 'p file= ', pfile(1:nblen(pfile))
          endif
      endif

      if (rgg .le. 0. .and. Gfile .ne. ' ') then
          iret = initpick(GPICK, Gfile, irs, ire)

          if (iret .ne. 0) then
              write (LERR,*) name(1:nblen(name)),
     1        ': Could not open G Vs/Vp ratio pick file ',
     2        Gfile(1:nblen(Gfile)), '.'
              write (LER,*) name(1:nblen(name)),
     1        ': Could not open G Vs/Vp ratio pick file ',
     2        Gfile(1:nblen(Gfile)), '.'
              stop
          else
              write (LERR, *) 'G file= ', Gfile(1:nblen(Gfile))
          endif
      endif




c
c Zero out output buffer
c

      do ii = 1, nbins

          call vclr (
     1 ODH(ii),
     1 1, ITHWP1 + numsmp - 1)

c
c Start out traces as dead
c
          stacor = 30000
          call savew(
     1 ODH(ii),
     1 'StaCor', stacor, TRACEHEADER)

          call vclr (
     1 ODNH(ii),
     1 1, ITHWP1 + numsmp - 1)

      enddo


c
c Initialize bin information
c

      firsttime = 1
      cbinval = 0

      cbin = 1
      dbinmax = (nbins-1) / 2
      lagbin = 0
      leadbin = 0

      dropcount = 0
      tracecount = 0


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c Start of main loop over input traces!
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

 101  continue

      nbytes = 0
      call rtape(luin, trace, nbytes)

      if (nbytes .eq. 0) then
c
c Done reading input!
c
          goto 9999
      endif


c
c Skip dead traces
c
      call saver(trace, 'StaCor', stacor, TRACEHEADER)

      if ( stacor .eq. 30000) then
#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) ' Dead trace.'
          endif
#endif
          goto 101
      endif


      if (nbytes .ne. obytes) then
              write (LER,*) name(1:nblen(name)),
     1        ': Unexpected trace length ', nbytes, ' for input.'
              write (LER,*) name(1:nblen(name)),
     1        ': Expected trace length ', obytes, '.'
              write (LERR,*) name(1:nblen(name)),
     1        ': Unexpected trace length ', nbytes, ' for input.'
              write (LERR,*) name(1:nblen(name)),
     1        ': Expected trace length ', obytes, '.'
              stop
      endif


c
c Find out the record number
c

      call saver(trace, 'RecNum', irn, TRACEHEADER)
      call saver(trace, 'TrcNum', itn, TRACEHEADER)


#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) '---------- Record #', irn,
     1        ', Trace #', itn, ' -------------------'
          endif
#endif


c
c Calculate G and z for this trace
c

c
c First find G
c

          if (rgg .gt. 0.) then
c
c Simplest case: they simply provided us directly with it
c
              gg = rgg

          else

c
c Call Yaohui's routine to get the info we need from the pick file.
c Multiply time by 1000. according to USP convention.
c

              call sgetpick(GPICK, numsmp, nsi, irn,
     1                      tt*1000., gg, 1., ttp)

c
c Correct for the bogus factor of 1000. in G.
c
              gg = gg / 1000.

              if (gg .le. 0.) then
                  write (LERR,*) name(1:nblen(name)),
     1            ': Got invalid G for record ', irn,
     2            ' from ', Gfile(1:nblen(Gfile)), ' of ', gg,
     3            ' .'
                  write (LER,*) name(1:nblen(name)),
     1            ': Got invalid G for record ', irn,
     2            ' from ', Gfile(1:nblen(Gfile)), ' of ', gg,
     3            ' .'
                  stop
              endif

          endif


c
c Now find Z
c

          if (rzz .gt. 0.) then
c
c Simplest case: they simply provided us directly with it
c
              zz = rzz

          else

              if (rvp .le. 0.) then

c
c Call Yaohui's routine to get the info we need from the pick file.
c Multiply time by 1000. according to USP convention. Provide G
c so the subroutine can convert from Tps to Tp.
c

                 call sgetpick(PPICK, numsmp, nsi, irn,
     1                         tt*1000., vp, gg, ttp)

#ifdef VERBOSE
              if (verbose) then
                  write (LERR, *) 'tp=', ttp / 1000.
              endif
#endif

c
c P-velocity doesn't have to be divided by 1000.
c

                  if (vp .le. 0.) then
                      write (LERR,*) name(1:nblen(name)),
     1                ': Got invalid vp for record ', irn,
     2                ' from ', pfile(1:nblen(pfile)),
     3                ' of ', vp, ' .'
                      write (LER,*) name(1:nblen(name)),
     1                ': Got invalid vp for record ', irn,
     2                ' from ', pfile(1:nblen(pfile)),
     3                ' of ', vp, ' .'
                      stop
                  endif
              else
                  vp = rvp
              endif

#ifdef VERBOSE
              if (verbose) then
                  write (LERR, *) 'tps=', tt, '   vp=', vp
              endif
#endif

c
c Using t, vp, and G, calculate z.
c
              zz = tt / (1./vp + 1. / (gg * vp))

          endif



#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) 'z=', zz, '   G=', gg
          endif
#endif




c
c Calculate location info for this point
c

          if (sxi .eq. 0. .and. syi .eq. 0.) then
              if (issynthetic .eq. 0) then
c
c For field data, use SrPtXC and SrPtYC.
c
                  call saver(trace, 'SrPtXC', srptxc, TRACEHEADER)
                  call saver(trace, 'SrPtYC', srptyc, TRACEHEADER)
                  fsrptxc = srptxc
                  fsrptyc = srptyc
              else
c
c For synthetic datasets, use (SrcLoc / 10.).
c
                  call saver(trace, 'SrcLoc', srcloc, TRACEHEADER)
                  fsrptxc = real(srcloc) * grpint / 10.
                  fsrptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting source increments on the command line.
c
              fsrptxc = sxo + (irn - irsd) * sxi
              fsrptyc = syo + (irn - irsd) * syi
          endif

          if (rxi .eq. 0 .and. ryi .eq. 0) then
              if (issynthetic .eq. 0) then
c
c For field data, use RcPtXC and RcPtYC.
c
                  call saver(trace, 'RcPtXC', rcptxc, TRACEHEADER)
                  call saver(trace, 'RcPtYC', rcptyc, TRACEHEADER)
                  frcptxc = rcptxc
                  frcptyc = rcptyc
              else
c
c For synthetic datasets, use RecInd.
c
                  call saver(trace, 'RecInd', recind, TRACEHEADER)
                  frcptxc = real(recind) * grpint
                  frcptyc = 0.
              endif
          else
c
c User has overriden any geometry in the USP trace headers by
c setting receiver increments on the command line.
c
              frcptxc = rxo + (itn-1) * rxi
              frcptyc = ryo + (itn-1) * ryi
          endif



c
c    Now calculate the CCP point coordinate
c
          xx = sqrt((frcptxc-fsrptxc)**2 + (frcptyc-fsrptyc)**2)

          if (xx .gt. 0) then
c
c Yaohui's routine "getxp". This can blow up if gg > 1..
c

              call getxp (xx, zz, gg, xp)
              ccpx = fsrptxc + (xp / xx) * (frcptxc - fsrptxc)
              ccpy = fsrptyc + (xp / xx) * (frcptyc - fsrptyc)

          else
              ccpx = fsrptxc
              ccpy = fsrptyc
          endif


c
c    Now figure out which bin it goes in
c

c
c (ix1,iy1) is the start of the survey line; find the offset
c from there to this point.
c
          vpx = ccpx - ix1
          vpy = ccpy - iy1

c
c Project that offset onto the inline and crossline
c binning grid.
c
          vpi = vpx * vix + vpy * viy
          vpc = vpx * vcx + vpy * vcy

c
c Plunk it into the nearest bin.
c
          ibini = nint(vpi)
          ibinc = nint(vpc)

c
c See what bin ccpbin put these in, just for comparison
c

          call saver(trace, 'CDPBCX', ibiniold, TRACEHEADER)
          call saver(trace, 'CDPBCY', ibincold, TRACEHEADER)


#ifdef VERBOSE
          if (verbose) then
              write (LERR, *) '  Src ', fsrptxc, fsrptyc,
     1                        ', Rec ', frcptxc, frcptyc
              write (LERR, *) '     old bin # ', ibiniold, ibincold
              write (LERR, *) '     CCP bin coor ', ccpx, ccpy
              write (LERR, *) '     float bin # ', vpi, vpc,
     1                        ' --> int bin # ', ibini, ibinc
          endif
#endif



      if (firsttime .eq. 1) then
          firsttime = 0

c
c Our first live trace... use it to figure out where to
c start!
c

c
c We'll start out at the beginning of the bin area...
c
          cbin = 1
c
c Bin number cbin will contain this bin number.
c
          cbinval = ibini

c
c How much to either side we've used.
c
          lagbin = 0
          leadbin = 0

      endif


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c Sum the trace into the appropriate bin.
c Calculate which bin that should be...
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

 555  continue
      binoffset = ibini - cbinval

c
c See if we need to shift the bins for it to fit.
c

      if (binoffset .gt. leadbin) then
c
c Need to add a new leading bin!
c

          if (leadbin .lt. dbinmax) then
c
c We still have room.
c
              leadbin = leadbin + 1
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Adding leading bin. ',
     1                cbin, cbinval, leadbin, lagbin
                  endif
#endif
              goto 555
          else

c
c Shift bins forward one
c
              cbin = cbin + 1
              cbinval = cbinval + 1

#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Shifting bins forward one. ',
     1                cbin, cbinval, leadbin, lagbin
                  endif
#endif

              if (lagbin .lt. dbinmax) then
                  lagbin = lagbin + 1
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Adding lagging bin. ',
     1                cbin, cbinval, leadbin, lagbin
                  endif
#endif

              else

c
c Oops! We need to write a lagging bin out and reuse the space to make
c room.
c

                  jj = cbin - (lagbin+1) + nbins
                  jj = (jj-1) - nbins * int((jj-1)/nbins) + 1

#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Writing out lagging bin. ',
     1                cbin - (lagbin+1), jj
                  endif
#endif


c
c Normalize the trace
c
                  do ii = 1, numsmp
                      count =
     1 ODND(ii,jj)

                      if (count .gt. 0) then
       ODD(ii,jj) =
     1 ODD(ii,jj)
     1              / real(count)
                      endif

                  enddo

c
c Set the fold number
c

                  call savew(
     1 ODH(jj),
     1            'FoldNm', count, TRACEHEADER)


c
c Write it out
c

                  call wrtape(luout,
     1 ODH(jj),
     1                             obytes)


                  tracecount = tracecount + 1



c
c Clear the bin back out so it's ready for new stuff
c

                  call vclr (
     1 ODH(jj),
     1            1, ITHWP1 + numsmp - 1)

c
c Start out traces as dead
c
                  stacor = 30000
                  call savew(
     1 ODH(jj),
     1            'StaCor', stacor, TRACEHEADER)

                  call vclr (
     1 ODNH(jj),
     1            1, ITHWP1 + numsmp - 1)

              endif
              goto 555
          endif

      endif



      if (-binoffset .gt. lagbin) then
c
c We need to add a new lagging bin.
c

          if (lagbin .lt. dbinmax) then
c
c We still have room.
c
              lagbin = lagbin + 1
#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Adding lagging bin. ',
     1                cbin, cbinval, leadbin, lagbin
                  endif
#endif
              goto 555
          else
c
c Oops! No room. Drop this trace on the floor!
c

              dropcount = dropcount + 1

#ifdef VERBOSE
              if (verbose) then
                  write (LERR, *) 'Dropping trace. ',
     1            cbin, cbinval, leadbin, lagbin
              endif
              goto 101
#endif
          endif

      endif


#ifdef VERBOSE
       if (verbose) then
           write (LERR, *) cbin, cbinval, leadbin, lagbin
       endif
#endif

       jj = (cbin+binoffset) + nbins
       jj = (jj-1) - nbins * int((jj-1)/nbins) + 1

#ifdef VERBOSE
       if (verbose) then
           write (LERR, *) 'Summing in trace. ', cbin + binoffset, jj
       endif
#endif


       do ii = 1, numsmp
       ODND(ii,jj) =
     1 ODND(ii,jj) + 1

       ODD(ii,jj) =
     1 ODD(ii,jj) +
     1 TRACE(ii)
       enddo


       if (ODNH(jj)
     1             .eq. 0) then

#ifdef VERBOSE
           if (verbose) then
               write (LERR, *) 'Copying trace header. '
           endif
#endif

           call vmov (trace, 1,
     1 ODH(jj),
     1                         1, ITHWP1 - 1)

           ODNH(jj) = 1

       endif


c
c End of trace reading loop
c

      goto 101

 9999 continue



c
c EOF reached: close input,
c

      call lbclos ( luin )


c
c Flush remaining bins left in buffer
c

c
c (Make sure we got at least one trace first...)
c
      if (firsttime .eq. 0) then

          do kk = -lagbin, leadbin

                  jj = cbin + kk + nbins
                  jj = (jj-1) - nbins * int((jj-1)/nbins) + 1

#ifdef VERBOSE
                  if (verbose) then
                      write (LERR, *) 'Writing out leftover bin. ',
     1                cbin + kk, jj
                  endif
#endif


c
c Normalize the trace
c
                  do ii = 1, numsmp
                      count =
     1 ODND(ii,jj)

                      if (count .gt. 0) then
       ODD(ii,jj) =
     1 ODD(ii,jj)
     1              / real(count)
                      endif

                  enddo

c
c Set the fold number
c
 
                  call savew(
     1 ODH(jj),
     1            'FoldNm', count, TRACEHEADER)


c
c Write it out
c

                  call wrtape(luout,
     1 ODH(jj),
     1                             obytes)


                  tracecount = tracecount + 1


           enddo
       endif



       write (LER,*) name(1:nblen(name)),
     1                ': ', tracecount, ' output bins.'
       write (LERR,*) name(1:nblen(name)),
     1                ': ', tracecount, ' output bins.'

       if (dropcount .gt. 0) then
           write (LER,*) name(1:nblen(name)),
     1                ': Warning, ', dropcount, ' input traces dropped.'
           write (LERR,*) name(1:nblen(name)),
     1                ': Warning, ', dropcount, ' input traces dropped.'
       endif



c
c Attempt to update the output line header
c

      call savew(llhed, 'NumTrc', 1, LINEHEADER)
      call savew(llhed, 'NumRec', tracecount, LINEHEADER)

      call rwd (luout)
      call wrtape (luout, llhed, lhbytes)

c
c Close the output
c
      call lbclos ( luout )

      write (LER,*) name(1:nblen(name)),
     1 ': Normal Termination'

c
c Done!
c

      stop      
      end
