/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>

#include <localsys.h>

  /*
   * read_vel_picks_
   *
   * A C function called by FORTRAN to read Velocity picks
   * 
   * fnn        : velocity pick file
   *              can be disco HANDVEL file, flat file, XSD pick file
   *              VXOS picks file, or TDFN card
   * nrec       : total number of records
   * recindex(i): Record index with velocity picks
   * flag       : =0 disco HANDVEL file
   *              =1 flat file
   *              =2 XSD pick file
   *              =3 XOS pick file
   *              =4 TDFN vel file
   * t(i)       : A big array to store time index
   * v(i)       : A big array to store velocity values
   * np(i)      : Number of velocity picks in the record i
   * indptr(i)  : Pointer to the begining of each velocity pick record i
   *
   * By Yaohui Zhang, 1995
   */


#ifdef FTN_TO_C_UPPERCASE
#define F_READ_VEL_PICKS READ_VEL_PICKS
#else
#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#define F_READ_VEL_PICKS read_vel_picks_
#else
#define F_READ_VEL_PICKS read_vel_picks
#endif
#endif


#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

#ifndef CRAYSYSTEM
int
F_READ_VEL_PICKS (fnn,nrec,recindex,flag,t,v,np,indptr,length_of_fnn)
    char           *fnn;
    unsigned        length_of_fnn;
#else
int
F_READ_VEL_PICKS (fnn,nrec,recindex,flag,t,v,np,indptr)
    _fcd            fnn;
#endif
int  *nrec,recindex[],*flag, np[],indptr[];
float t[],v[];
{
char           *c_fnn;
int             ii;

#ifdef CRAYSYSTEM
unsigned        length_of_fnn = _fcdlen (fnn);
#endif


/*
fprintf(stderr,"fnn: %d '%c%c%c' '%s'\n", length_of_fnn, fnn[0], fnn[1], fnn[2], fnn);
*/

    while (length_of_fnn > 0 &&
          *((char*)fnn + length_of_fnn - 1) == ' ')
        length_of_fnn--;

    c_fnn = (char *) malloc ((length_of_fnn + 1) * sizeof (char));
    strncpy (c_fnn, (char*)fnn, (int) length_of_fnn);
    c_fnn[length_of_fnn] = '\0';

/*
fprintf(stderr,"c_fnn: %d '%c%c%c' '%s'\n", length_of_fnn, c_fnn[0], c_fnn[1], c_fnn[2], c_fnn);
*/

    ii = C_read_vel_picks(c_fnn,nrec,recindex,flag,t,v,np,indptr);

    free (c_fnn);
    return ii;
}

/*read_vel_picks_(fnn,nrec,recindex,flag,t,v,np,indptr)  */

C_read_vel_picks(fnn,nrec,recindex,flag,t,v,np,indptr)

char fnn[];
int  *nrec,recindex[],*flag, np[],indptr[];
float t[],v[];
{

FILE *fptr;

int in,len,ii,kk,ijk,ip, icount;
char str[500],strt[9],strv[9], *fgets();
/*
char s1[50],s2[50],s3[50],s4[50],s5[50],s6[50],s7[50],s8[50],s9[50];
*/


fptr = fopen(fnn,"r");


if(fptr == NULL)
{
printf("\n Cannot open the velocity pick file: '%s'\n",fnn);
return;
/*
exit(1);
*/
}


switch(*flag)
      {
      case 0:
   /*
    * Read  disco HANDVEL file
    */
          in=0;
          ip=0;
          indptr[0]=0;
/*
          while(read_line(fptr,str) != -1)
	          {
*/
          while(!feof(fptr))
                {
                fgets(str,488,fptr);
      	    if(!strncmp(str,"HANDVEL",7))
      		    {
                    sscanf(str,"%*s%d",&recindex[ip]);
                    if(ip > 0)
                       {np[ip-1]=icount;
                        indptr[ip-1]=in-icount;
                       }
/*
                   printf("\nin=%d, np[ip-1]=%d icount=%d\n",in,np[ip-1],icount);
                   printf("\n%dth record has %d picks, indptr[%d]=%d\n",recindex[ip-1],np[ip-1],ip,indptr[ip-1]);
*/
                    ip=ip+1;
                    icount=0;
		          }
               else
                   {
                   get_word(str,strt,1,8);
                   get_word(str,strv,9,15);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else
                       {printf("\n Disco HANDVEL velocity format ERROR!");
                        printf("\n Zero velocity detected:");
                        printf("\n Time-Velocity pair MUST be provided in the");
                        printf("\n first 16-columns of a card after HANDVEL.\n");
                        printf("\n Check the HANDVEL %d in velocity file'%s'\n",recindex[ip-1],fnn);
                        return;
                       }
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/

                   get_word(str,strt,17,24);
                   get_word(str,strv,25,32);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto NEXTCARD;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/

                   get_word(str,strt,33,40);
                   get_word(str,strv,41,48);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto NEXTCARD;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/

                   get_word(str,strt,49,56);
                   get_word(str,strv,57,64);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto NEXTCARD;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   }

                NEXTCARD:	;
      	    }
                    np[ip-1]=icount;
                    indptr[ip-1]=in-icount;
            indptr[ip]=in;
            *nrec=ip;
/*
            printf("\nThere are %d record\n",*nrec); 
*/
          break;

      case 1:
         /*
          * read flat file
          */
          in=0;
          ip=0;
          ii=0;
/*
          while(read_line(fptr,str) != -1)
              	{
*/
          while(!feof(fptr))
                {
                fgets(str,488,fptr);
                sscanf(str,"%d%*s%*s%*s%*s",&kk);
              	if(kk == -1)
      	        	{
                     sscanf(str,"%*f%*s%*f%*s%d",&recindex[ip]);
                     ii=0;
                     ip=ip+1;
                     }
                else
                     {
              		sscanf(str,"%f%*s%f%*s%d",&t[in],&v[in],&recindex[ip]);
	              	in=in+1;
                     ii=ii+1;
      	        	}
                np[ip]=ii;
                indptr[ip]=in-ii;
                }
            *nrec=ip;
            indptr[ip]=in;
            break;
      case 2:
         /*
          * read XSD pick file (segments)
          */
          in=0;
          ip=0;
          indptr[0]=0;
/*
          if(read_line(fptr,str) == -1) return;
          while(read_line(fptr,str) != -1)
              	{
*/
          if(feof(fptr)) return;
          if(!feof(fptr)) fgets(str,488,fptr);
          while(!feof(fptr))
                {
                fgets(str,488,fptr);
              	if(!strncmp(str,"Segment",7))
                      {
                      sscanf(str,"%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%d",&np[ip]);
/*
                      printf("\n%s'np['%d']='%d\n",str,ip,np[ip]);
*/
                      ip=ip+1;
                      }
                else
      	        	{
                     sscanf(str,"%d%*s%f%f",&recindex[ip-1],&v[in],&t[in]);
	              	in=in+1;
      	        	}
                indptr[ip-1]=in-np[ip-1];
      	      }
                indptr[ip]=in;
           *nrec=ip;
            break;
      case 3:
         /*
          * read VXOS pick file (segments)
          */
          in=0;
          ip=0;
          indptr[0]=0;
/*
          if(read_line(fptr,str) == -1) return;
          while(read_line(fptr,str) != -1)
*/
          if(feof(fptr)) return;
          if(!feof(fptr)) fgets(str,488,fptr);
          while(!feof(fptr))
                {
                fgets(str,488,fptr);
              	if(!strncmp(str,"Segment",7))
                      {

                      sscanf(str,"%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%d",&np[ip]);
/*
                      printf("DBX: \n%s'np['%d']='%d\n",str,ip,np[ip]);
*/

                      icount=0;
                      ip=ip+1;
                      }
                else
      	        	{
                     sscanf(str,"%d%*s%f%f",&recindex[ip-1],&v[in],&t[in]);
	              	in=in+1;
                    icount=icount+1;
      	        	}
                indptr[ip-1]=in-np[ip-1]-1;
                np[ip-1]=icount;
      	         }
                indptr[ip]=in;
           *nrec=ip;
            break;
      case 4:
         /*
          * read TDFN pick file (segments)
          */
          in=0;
          ip=0;
          indptr[0]=0;
/*
          while(read_line(fptr,str) != -1)
              	{
*/
          while(!feof(fptr))
                {
                fgets(str,488,fptr);
              	if(!strncmp(str+1,"TDFN",4)) 
                   {get_word(str,strv,76,80);
                   recindex[ip]=atoi(strv);
                 /*  printf("\nRecord#=%s",strv);  */
                   get_word(str,strt,6,9);
                   get_word(str,strv,10,14);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   get_word(str,strt,15,18);
                   get_word(str,strv,19,23);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   get_word(str,strt,24,27);
                   get_word(str,strv,28,32);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   get_word(str,strt,33,36);
                   get_word(str,strv,37,41);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   get_word(str,strt,42,45);
                   get_word(str,strv,46,50);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   get_word(str,strt,51,54);
                   get_word(str,strv,55,59);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   get_word(str,strt,60,63);
                   get_word(str,strv,64,68);
                   t[in]=atof(strt);
                   v[in]=atof(strv);
                   if(v[in] != 0.0) 
                       {icount=icount+1;
                        in=in+1;
                       }
                   else goto ZEROVEL;
/*
                   printf("\n%d: V-pair %d = (%s,%s) = %8.0f, %8.2f",in-1,icount,strt,strv,t[in-1],v[in-1]);
*/
                   ZEROVEL:	;
                   if(!strncmp(str,"9TDFN",5))
                      {np[ip]=icount;
                      indptr[ip]=in-np[ip];
/*
                   printf("\nin=%d, np[ip]=%d icount=%d\n",in,np[ip],icount);
                   printf("\n%dth record has %d picks, indptr[%d]=%d\n",recindex[ip],np[ip],ip+1,indptr[ip]);
*/
                      ip=ip+1;
                      icount=0;
                      }
                   }
               }
            indptr[ip]=in;
            *nrec=ip;
/*
            printf("\nThere are %d record\n",*nrec); 
*/
            break;
      case 5:
         /*
          * read ProMax Velocity file (segments)
          */
          in=0;
          ip=0;
          indptr[0]=0;
/*
          if(read_line(fptr,str) == -1) return;
          while(read_line(fptr,str) != -1)
              	{
*/
          if(feof(fptr)) return;
          if(!feof(fptr)) fgets(str,488,fptr);
          while(!feof(fptr))
                {
                fgets(str,488,fptr);
              	if(!strncmp(str,"Segment",7))
                      {
/*
                      sscanf(str,"%*s%*s%*s%*s%*s%*s%*s%*s%*s%*s%d",&np[ip]);
                      printf("\n%s'np['%d']='%d\n",str,ip,np[ip]);
*/
                      icount=0;
                      ip=ip+1;
                      }
                else
      	        	{
                     sscanf(str,"%d%*s%f%f",&recindex[ip-1],&v[in],&t[in]);
	              	in=in+1;
                    icount=icount+1;
      	        	}
                indptr[ip-1]=in-np[ip-1];
                np[ip-1]=icount;
      	      }
                indptr[ip]=in;
           *nrec=ip;
            break;
      }
fclose(fptr);
return;
}



inputs(prompt,str,count)
  /*
   * By Yaohui Zhang, 1992
   */
char *prompt;
char *str;
int  count;
{
     char p[255];

     do   {
          printf(prompt);
/* The PGI compiler said this was dangerous, so I switched to the more
   acceptable fgets() - joe m. wade 10/20/00
          gets(p);
*/
          fgets(p,255,stdin);
          if(strlen(p)>count) printf("\nToo long\n");
          } while(strlen(p) > count);
          strcpy(str,p);
}


int read_line(fptr,string)
  /*
   * By Yaohui Zhang, 1992
   */
FILE *fptr;
char string[];
{
char c;
int  i,ieof;

     for(i=0;i<500;i++)
        string[i]=' ';
     ieof=0;
     i=0;
     c = getc(fptr);
     if( c == (char) NULL) {ieof = -1; printf("I am at EOF\n"); return ieof;}
     while( c != '\n')  /* get the string */
          {string[i] = c;
          printf("c='%c' ",c);
          c = getc(fptr); /* get next char  */
          i++;
          }
     string[i] = '\0';
     return ieof;
}


put_zero(x,n)
float x[];
int n;
{
int i;

	for(i=0;i<n;i++)
		x[i]=0.0;
}

  /*
   * Parsing a word from a string
   * By Yaohui Zhang, Ext. 3901
   * Date: May, 1992
   */
get_word(string,word,ibeg,iend)
char  string[],word[];
int   ibeg,iend;
{
int   i,n;

      i=0;
      n=iend-ibeg;
      if(n == 0)
              {word[i] = string[ibeg-1];
              word[1] = '\0';
              return;
              }
      for(i=0; i<=n; i++)
              {word[i] = string[ibeg+i-1];
              word[i+1] = '\0';
              }
      return;
}

/*
int count(fpr)
FILE *fpr;
{
char  str[3032];
int   n=0, len[4000];

rewind(fpr);
while(fgets(str,3032,fpr) != NULL)
        {len[n]=strlen(str);
        n++;
        }
return n;
}
*/

/*
**    Check the type of pick file:
**    DISCO HANDVEL format        -  return 0
**    Flat file format            -  return 1
**    Standard XSD pick file      -  return 2
**    CVD/VXOS pick file          -  return 3
**    TDFN                        -  return 4
**    ProMAX format               -  return 5
**    Unknown                     -  return -1
*/
int check_pick_file(fn)
char  fn[];
{
FILE *tmptr;
int   pikf;
char str[255],temp[30];


      if((tmptr = fopen(fn,"r")) == NULL)
         {printf(str,"Error opening P-wave Vel pick file '%s'",fn);
          pikf=-100;
          goto CHK_DONE;
         }
      else if((fgets(str,132,tmptr)) == NULL)
         {printf("Input P-wave vel pick file contains no data!\n");
          pikf=-1;
          goto CHK_DONE;
         }
      if((pikf = chk_pik_format(str)) == -1)
        {printf("Unknown P-wave velocity pick format\n");
        pikf=-1;
        goto CHK_DONE;
        }
      else if((pikf = chk_pik_format(str)) == 23)
         {
         fgets(str,132,tmptr);
/*         printf("\n'%s\n",str);     */
         get_word(str,temp,44,48);
/*         printf("\n'%s'\n",temp); */
         if(!strncmp(temp,"color",5)) pikf=2;
         else pikf=3;
         }
CHK_DONE:	;
fclose(tmptr);
return(pikf);
}



/*
**    Check the type of pick file:
**    DISCO HANDVEL format        -  return 0
**    Flat file format            -  return 1
**    TDFN                        -  return 4
**    ProMAX format               -  return 5
**    Standard XSD-like pick file -  return 23
**    Unknown                     -  return -1
*/
int chk_pik_format(s)
char *s;
{
    int i, l;

    if(!strncmp(s,"Units",5)) return(23);
    if(!strncmp(s,"HANDVEL",7)) return(0);
    if(!strncmp(s,"DESC",4))return(5);
    if(!strncmp(s+1,"TDFN",4))return(4);
    l = strlen(s);
    for (i=0;i<l;i++)
     if(!strncmp(s+i,",",1))return(1);

    return (-1);
}


#ifdef FTN_TO_C_UPPERCASE
#define F_GET_PICK_FLAG GET_PICK_FLAG
#else
#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#define F_GET_PICK_FLAG get_pick_flag_
#else
#define F_GET_PICK_FLAG get_pick_flag
#endif
#endif


#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

#ifndef CRAYSYSTEM
int
F_GET_PICK_FLAG (fnn2,flag,length_of_fnn2)
    char           *fnn2;
    unsigned        length_of_fnn2;
#else
int
F_GET_PICK_FLAG (fnn2,flag)
    _fcd            fnn2;
#endif
int  *flag;
{
char           *c_fnn2;
int             ii;

#ifdef CRAYSYSTEM
unsigned        length_of_fnn2 = _fcdlen (fnn2);
#endif

    while (length_of_fnn2 > 0 &&
          *((char*)fnn2+length_of_fnn2 - 1) == ' ')
        length_of_fnn2--;

    c_fnn2 = (char *) malloc ((length_of_fnn2 + 1) * sizeof (char));
    strncpy (c_fnn2, (char*)fnn2, (int) length_of_fnn2);
    c_fnn2[length_of_fnn2] = '\0';

    ii = C_get_pick_flag(c_fnn2,flag);

    free (c_fnn2);
    return ii;
}

C_get_pick_flag(fnn2,flag)
char fnn2[];
int  *flag;
{
*flag = check_pick_file(fnn2);
return;
}
