C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c       prenmo : creates NMO table
c       Yaohui Zhang , 1995
c
c       itx: Move out time in samples
c       ix :
c       idt:
c       itb: starting index
c       ite: ending index
c
        subroutine prenmo(itx,ix,idt,itb,ite)
        dimension itx(1),ix(1),idt(1)
        idt(itb)=0
        ix(itb)=itb+itx(itb)
        do 20 jk=itb+1,ite
        idt(jk)=itx(jk-1)-itx(jk)
        k=jk+itx(jk)+idt(jk)
        ix(jk)=k
        if(k.gt.ite) ix(jk)=ite
20      continue
        return
        end


c
c      NMO routine: nmoex
c      Yaohui Zhang, 1995
c
c      x    : input data
c      y    : output data
c      index: NMO index table
c      idt  : NMO interpolation index (control the stretching)
c      itb  : starting index
c      ite  : ending index
c
      subroutine nmoex(x,y,index,idt,itb,ite)
      dimension x(1),y(1),index(1),idt(1)
      do 5 i=itb,ite
         y(i)=x(index(i))
 5    continue
      nzero=ite/5
      do i=nzero,ite
         if(index(i) .eq. ite) y(i)=0.0
      enddo
c        do i=ite-itmin-1,ite
c           y(i)=0.0
c        enddo
c
      i=itb
 10   continue
      j=0
      k=0
 20   continue
c        if(idt(i).ne.0) j=j+1
c       i=i+1
      if(idt(i).ne.0) j=j+idt(i)
      if(idt(i).gt.1) k=idt(i)-1
      i=i+1
      if(idt(i).ne.0) go to 20
      if(j.ne.0) then
         n=i+1
         m=i-j
         nm=j
         if(j .ge. 6) go to 82
         go to (40,50,60,70,80),nm
 40      continue
         y(m+1)=0.5*(y(m)+y(n))
         go to 90
 50      continue
         y(m+1)=0.67*y(m)+0.33*y(n)
         y(m+2)=0.33*y(m)+0.67*y(n)
         go to 90
 60      continue
         y(m+2)=0.5*(y(m)+y(n))
         y(m+1)=0.75*y(m)+0.25*y(n)
         y(m+2)=0.25*y(m)+0.75*y(n)
         go to 90
 70      continue
         y(m+1)=0.8*y(m)+0.2*y(n)
         y(m+2)=0.6*y(m)+0.4*y(n)
         y(m+3)=0.5*(y(m)+y(n))
         y(m+4)=0.2*y(m)+0.8*y(n)
         go to 90
 80      continue
         y(m+1)=(5.0*y(m)+y(n))/6.0
         y(m+2)=(2.0*y(m)+y(n))/6.0
         y(m+3)=0.5*(y(m)+y(n))
         y(m+4)=(2.0*y(m)+y(n))/3.0
         y(m+5)=(y(m)+5.0*y(n))/6.0
         go to 90
 82      continue
         do 84 jk=1,j
            y(m+jk)=((j-jk+1)*y(m)+jk*y(n))/(j+1)
 84      continue
 90      continue
         i=i+k
      endif
      if(i.ge.ite) go to 100
      go to 10
 100  continue
      return
      end

c
c       psnmodt : Move out time calculation
c       Yaohui Zhang, 1995
c 
c       tps0 : zero offset travel time in ms (input)
c              P-S conv wave: tps0 = (tp0 + ts0)/2
c              P- or S-wave : tps0 = tp0 or ts0
c              where tp0 and ts0 are two way travel time at zero offset
c       vp   : P-wave velocity array (input)
c       x    : offset (input)
c       g    : Vs/Vp ratio array (input)
c       dt   : sample interval in ms (input)
c       dtnmo: move out time array in ms (output)
c       xp   : conversion distance array (output)
c       nsamp: number of sample in the array (input)
c       iflag: NMO flag, =1, non-hyperbolic NMO (input)
c                        =2, hyperbolic with v=Vp
c                        =3, hyperbolic with v=sqrt(Vs*Vp)
c
        subroutine psnmodt(tps0,vp,x,g,dt,dtnmo,xp,nsamp,iflag)
        dimension tps0(1),vp(1),g(1),dtnmo(1),xp(1)
        integer dt
        do i=1,nsamp
           tps00=tps0(i)
           vpp=vp(i)
           offset=x
           gg=g(i)
           call psnmodt1(tps00,vpp,offset,gg,dt,dtnmot,xpp,iflag)
           dtnmo(i)=dtnmot
           xp(i)=xpp
        enddo
        return
        end


        subroutine psnmodt1(tps0,vp,x,g,dt,dtnmo,xp,iflag)
c
c       tps0 : zero offset travel time (input)
c       vp   : P-wave velocity [Vp(tps)] (input)
c       x    : offset (input)
c       g    : velocity ratio (Vs/Vp) (input)
c       dt   : Time Sample Interval (input)
c       dtnmo: NMO correction time (ms) (output)
c       xp   : conversion distance (output)
c       iflag: NMO indicator: (input)
c              =1, non-hyperbolic NMO
c              =2, hyperbolic NMO with Vp
c              =3, hyperbolic NMO with sqrt(Vp.Vs)=sqrt(g)*Vp
c       default =1
c
        integer dt
c
        v=vp
        if(iflag .eq. 2) v=vp
        if(iflag .eq. 3) v=vp*sqrt(g)
        if(iflag .ne. 1) go to 2048
c
c       non-hyperbolic NMO
c
       if(tps0.eq.0.0 .AND. x.eq.0.0) then
             dtnmo=0
             return
       else if(tps0.eq.0.0) then
             dt1=dt/1000.0
             ntps0=tps0/dt
             ttp=x/(vp*dt1)+1
             tts=0
             ntps =ttp+tts-1.0
             ndtnmo=ntps-ntps0
             dtnmo=ndtnmo*dt
             go to 5000
       endif
       g1=1.0+g
       z=0.001*g*tps0*vp/g1
       call getxp(x,z,g,xp)
c       write(24,*) 'tps0,vp,z,g,x,xp=',tps0,vp,z,g,x,xp
       dt1=dt/1000.0
       rxp=(xp/(vp*dt1))**2
       rxs=((x-xp)/(vp*dt1))**2
       ntps0=tps0/dt
       rtps0=tps0/dt
       ttp=sqrt((g*rtps0/(1.0+g))**2 + rxp)+1.0
       tts=sqrt((g*rtps0/(1.0+g))**2 + rxs)/g
       ttpp=ttp*dt
       ttss=tts*dt
       ntps =ttp+tts-1.0
       ndtnmo=ntps-ntps0
       dtnmo=ndtnmo*dt
c       tps=ntps*dt
       go to 5000
2048   continue
c
c      Hyperbolic NMO
c
       ntps0=tps0/dt
       dt1=dt/1000.0
       zterm=(tps0/dt)**2
       xterm=(x/(dt1*v))**2
       ntps=sqrt(zterm+xterm)+1
       ndtnmo=ntps-ntps0
       dtnmo=ndtnmo*dt
       tps=ntps*dt
5000   continue
       return
       end



        subroutine getxp(x,zr,g,xp)
c
c       find the P-S conversion point
c
c       X : offset (input)
c       Zr: depth of horizon (input)
c       G : Vs/Vp (input)
c       Xp: conversion distance (output)
c
        if(x.eq.0.0) then
           xp=0.0
           return
        endif
        if(zr .eq. 0.0) then
           xp=x
           return
        endif
        xp=x/(1.0+g)
        j=0
10      continue
        j=j+1
        xpk=sqrt(1.0+(1.0-g*g)*xp*xp/(zr*zr))
        xp=x*xpk/(g+xpk)
        if(j.lt.12) go to 10
        return
        end

