C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C-----------------------------------------------------------------------
C     PROGRAM VSMOOTH
c
C     Smooth a gridded velocity c(x,z) and generate a depth array zett by
C     laterally averaging c(x,z) .
C
C     INPUT: lu55 line.matrix: direct access file from program VMATRIX
c            lu10 line.velocity: sequential file used by VMATRIX
c     OUTPUT:lu66 line.smatrix: sequential file (unformatted)
c
C-----------------------------------------------------------------------
c	include 'datum3.inc'
#include <f77/lhdrsz.h>

      REAL         vz(2500), DVDX(2500),vztemp(2500), zett(1001 )
      INTEGER  INDEXV ( 1001, 2500 )
      INTEGER  james(2500)
      INTEGER  IVEL (50)
	integer argis
      character jobname*120,line*120,scname*120
	logical query
C-----------------------------------------------------------------------
c
c       Assign logical unit numbers
c
C-----------------------------------------------------------------------
      lu55 = 14
      lu10 = 5
      lu66 = 9
C-----------------------------------------------------------------------
c
c       Get external file names
c
C-----------------------------------------------------------------------
	query = ( argis ( '-?' ) .gt. 0 )
	if ( query ) then
		call help()
		stop
	end if
      call argstr('-L',line,' ',' ')
	ipos = index(line,' ')
	j = ipos -1
	if (j .eq. 0) then
		print *,'PROGRAM STOP:NO LINE ID GIVEN, SEE MANUAL PAGE'
		stop
	end if
        call gcmdln (nzeta,lmax,dxgrid,dzgrid,zmax,nxave,nzave)
c	print *,'nzeta,lmax,dxgrid,dzgrid,zmax,nxave,nzave'
c	print *,nzeta,lmax,dxgrid,dzgrid,zmax,nxave,nzave
      call argstr('-M',jobname,line(1:j)//'.matrix',
     :				line(1:j)//'.matrix')
	scname(1:j+7) = jobname(1:j+7)
c	print *,scname
      open(unit = lu55, file=jobname, access='direct', recl=lmax*SZSMPD)
      call argstr('-C',jobname,line(1:j)//'.velocity',
     :				line(1:j)//'.velocity')
      open(unit = lu10, file =jobname )
      call argstr('-S',jobname,line(1:j)//'.smatrix',
     :  			line(1:j)//'.smatrix')
      open(unit = lu66, file =jobname, form = 'unformatted' )
c	open(unit=33,file='dum1')
c
c    set local variables to number of cells in x and z directions
c
c	dxgrid = xgrid
c	dzgrid = zgrid
 	jmax = lmax
 	imax1 = nzeta
	jxbias = 0 
	read (lu10,1) dum1, dum2
1     format(5x,2f10.2,55x)

c
c	read in card file containing velocities in each layer
c
	i = 0
c	ivel(1) = 0
	go to 10
5	if ( ( irlv .ge. 99999 ) ) go to 15
10	continue
	i = i + 1
	read (lu10,2) irlv
2	format(5x, i5, 70x)
	ivel(i) = irlv
cprint *,'i=',i,'ivel(i) = ', ivel(i)
	go to 5
15	continue	
c
c    read velocity indices from direct access file
c
	do 20 irow = 1, imax1
c	read (lu55, rec = irow) (indexv(irow,jxi),jxi = 1, jmax)
	read (lu55, rec = irow) (james(jxi), jxi = 1, jmax)
c	write(33,*)'row =',irow
cprint *,'row =',irow
cprint *,(james(i),i=1,3)
		do 22 jjj = 1, jmax
			indexv(irow, jjj) = james(jjj)
22	continue
c	write(33,2222)(indexv(irow,jjj),jjj=1,100,10)
2222	format(10i7)	
8788	format(10i7)
20	continue
c
c    compute smoothed velocities at depth zeta =0
c
      JZETA = 0
      ZETA  = 0.
      TAU   = 0.
      ZETT(0) = 0.
c     NZETA = IMAX1
C-----------------------------------------------------------------------
C
C     VELOCITY ROWS FOR DEPTH ZETA = 0.
C     AVERAGE HORIZONTALLY AND VERTICALLY FOR SMOOTH VELOCITY.
C
C-----------------------------------------------------------------------
	call vclr(vz,1,lmax)
	call vclr(vztemp,1,lmax)
	call vclr(dvdx,1,lmax)
	call vclr(zett,1,nzeta)
      IROW = 1
C-----------------------------------------------------------------------
C
C     VERTICAL SMOOTHING: AVERAGE VELOCITY OVER HORIZONTAL STRIPS,
C     EQUIVALENT TO A VERTICAL RUNNING AVERAGE.
C     THE NUMBER OF HORIZONTAL STRIPS IS HALF THAT USED FOR DEPTHS
C     > 0, AND THE MOST HEAVILY WEIGHTED STRIP IS
C     THE FIRST ROW OF THE VELOCITY MODEL.
C
C-----------------------------------------------------------------------
	istop = ( nzave + 1 ) / 2
      DO 80 JZAVE = 1,istop
C
C       NOTE: IMAX1 = # OF DEPTHS IN THE VELOCITY MODEL.
C
        IROW = 1
        DO 60 JXI = 1,JMAX
          JXII = JXI
c         JXII = JXI-JXBIAS
          JXII = MAX(1,JXII)
          JXII = MIN(JXII,JMAX-1)
C
C         TRIANGULAR TAPER FUNCTION
C
          NSUM = (NZAVE+1)/2
          SUM = NSUM**2
          WGT = ((NZAVE+1)/2-IABS((NZAVE+1)/2-JZAVE))/SUM
          VZTEMP(JXI) = VZTEMP(JXI)+WGT*(IVEL(INDEXV(IROW,JXII)))
60      CONTINUE
80    CONTINUE
      IROW = 2
      IROW = MAX(IROW,1)
      DO 90 JZAVE = (NZAVE+1)/2+1,NZAVE
C
C       NOTE: IMAX1 = # OF DEPTHS IN THE VELOCITY MODEL.
C
        IROW = MIN(IROW,IMAX1)
        DO 85 JXI = 1,JMAX
          JXII = JXI
c         JXII = JXI-JXBIAS
          JXII = MAX(1,JXII)
          JXII = MIN(JXII,JMAX-1)
C
C         TRIANGULAR TAPER FUNCTION
C
          NSUM = (NZAVE+1)/2
          SUM = NSUM**2
          WGT = ((NZAVE+1)/2-IABS((NZAVE+1)/2-JZAVE))/SUM
          VZTEMP(JXI) = VZTEMP(JXI)+WGT*(IVEL(INDEXV(IROW,JXII)))
85      CONTINUE
        IROW = IROW+1
90    CONTINUE
C-----------------------------------------------------------------------
C
C     HORIZONTAL SMOOTHING: HORIZONTAL RUNNING AVERAGE
C
C-----------------------------------------------------------------------
      CAVE = 0.
      DO 120 JXI = 1,JMAX
        DO 100 JXAVE = 1,NXAVE
          JNDEX = JXI+(NXAVE+1)/2-JXAVE
          JNDEX = MAX(1,JNDEX)
          JNDEX = MIN(JNDEX,JMAX-1)
C
C         TRIANGULAR TAPER FUNCTION
C
          NSUM = (NXAVE+1)/2
          SUM = NSUM**2
          WGT = ((NXAVE+1)/2-IABS((NXAVE+1)/2-JXAVE))/SUM
          Vz (jxi) = Vz(JXI)+WGT*(VZTEMP(JNDEX))
C
C         insert v(0) here for v(z) migration: vz(jxi) = ...
C         vz(jxi) = 1480. * 1.0077
C
100     CONTINUE
        IF ((JXI .GT. 1) .AND. (JXI .LT. JMAX)) CAVE = CAVE+Vz (jxi)
120   CONTINUE
      CAVE = CAVE/(JMAX-2)
      TAU = TAU+2.*ZETA/Vz( (  JMAX+1 ) / 2 )
c     DZETA = 10.
      DZETA = dzgrid
      DVDX( 1) = 0.
      DVDX( JMAX) = 0.
      DO 140 JXI = 2,JMAX-1
        DVDX( JXI ) = ( Vz( JXI+1 )- Vz( JXI-1) ) / (2.*DXGRID)
140   CONTINUE
	write(lu66) (vz(jj), jj=1,jmax)
	write(lu66) (dvdx(jj), jj=1,jmax)
3333	format(10f7.0)
C-----------------------------------------------------------------------
C
C     COMPUTE SMOOTHED VELOCITIES AT DEPTHS ZETA > 0.
C
C-----------------------------------------------------------------------
c     DZETA = 10.
      DZETA = dzgrid
      JZETA = 0
      ZETA = 0.
105   FORMAT(5E12.2)
C-----------------------------------------------------------------------
C
C     next statement is branch for do loop.
C
C-----------------------------------------------------------------------
	do 370 iii = 1, nzeta
110     if (.not. (zeta .lt. zmax) ) go to 370
        JZETA = JZETA+1
        ZETA = ZETA+DZETA
        IF (ZETA .GE. ZMAX) ZETA = ZMAX+.0001
c       ZETT(JZETA+1) = ZETA
        ZETT(iii) = ZETT(iii - 1) + DZETA 
C
C       VELOCITY ROWS FOR DEPTH ZETA.
C       AVERAGE HORIZONTALLY AND VERTICALLY FOR SMOOTH VELOCITY.
C
	call vclr(vz,1,lmax)
	call vclr(vztemp,1,lmax)
	call vclr(dvdx,1,lmax)
        IROW =    +INT(ZETA/DZGRID)-NZAVE/2
        IROW = MAX(IROW,1)
C-----------------------------------------------------------------------
C
C       VERTICAL SMOOTHING: AVERAGE VELOCITY OVER HORIZONTAL STRIPS,
C       EQUIVALENT TO A VERTICAL RUNNING AVERAGE
C
C-----------------------------------------------------------------------
        DO 300 JZAVE = 1,NZAVE
C
C         NOTE: IMAX1 = # OF DEPTHS IN THE VELOCITY MODEL.
C
          IROW = MIN(IROW,IMAX1)
          DO 280 JXI = 1,JMAX
            JXII = JXI
c           JXII = JXI-JXBIAS
            JXII = MAX(1,JXII)
            JXII = MIN(JXII,JMAX-1)
C
C           TRIANGULAR TAPER FUNCTION
C
            NSUM = (NZAVE+1)/2
            SUM = NSUM**2
            WGT = ((NZAVE+1)/2-IABS((NZAVE+1)/2-JZAVE))/SUM
            VZTEMP(JXI) = VZTEMP(JXI)+WGT*(IVEL(INDEXV(IROW,JXII)))
280       CONTINUE
          IROW = IROW+1
300     CONTINUE
C-----------------------------------------------------------------------
C
C       HORIZONTAL SMOOTHING: HORIZONTAL RUNNING AVERAGE
C
C-----------------------------------------------------------------------
        CAVE = 0.
        DO 340 JXI = 1,JMAX
          DO 320 JXAVE = 1,NXAVE
            JNDEX = JXI+(NXAVE+1)/2-JXAVE
            JNDEX = MAX(1,JNDEX)
            JNDEX = MIN(JNDEX,JMAX-1)
C
C           TRIANGULAR TAPER FUNCTION
C
            NSUM = (NXAVE+1)/2
            SUM = NSUM**2
            WGT = ((NXAVE+1)/2-IABS((NXAVE+1)/2-JXAVE))/SUM
            vz( JXI ) = vz( JXI ) + WGT*(VZTEMP(JNDEX))
320       CONTINUE
          IF ((JXI .GT. 1) .AND. (JXI .LT. JMAX))
     :               CAVE = CAVE + Vz( JXI )
340     CONTINUE
        CAVE = CAVE/(JMAX-2)
        TAU = TAU + 2. * DZETA / Vz( ( JMAX+1 ) / 2 ) 
        DZETA = dzgrid
        DVDX(  1    ) = 0.
        DVDX(  JMAX ) = 0.
        DO 360 JXI = 2,JMAX-1
         dvdx ( jxi ) =  (vz ( JXI+1 ) - vz ( JXI-1 ) ) / ( 2.*DXGRID )
360     CONTINUE
	write(lu66) (vz(jj),jj=1,jmax)
	write(lu66) (dvdx(jj),jj=1,jmax)
c     go to 110
370   continue
      NZ = JZETA
1060  FORMAT (1x, 8F10.2)
      close (unit =lu66, status = 'keep')
      close (unit =lu55, status = 'keep')
      close (unit =lu10, status = 'keep')
c	call ishell ('rm '//scname(1:j+7) )
c	print *,'vsmooth done'
      END
      subroutine gcmdln (nzeta,lmax,dxgrid,dzgrid,zmax,nxave,nzave)
c-----
c     get command arguments
c
c     nzeta - i*4 number of cells in z-direction.
c     lmax  - i*4 number of cells in x-direction.
c     dxgrid- r*4 grid interval in x.
c     dzgrid- r*4 grid interval in z.
c     zmax  - r*4 bottom of model.
c     nxave - i*4 number of cells to smooth in x direction.
c     nzave - i*4 number of cells to smooth in z direction.
c-----
      integer argis

            call argi4 ( '-nz', nzeta, 0, 0 )
            call argi4 ( '-nx', lmax , 0, 0 )
            call argr4 ( '-dx', dxgrid, 0.0, 0.0 )
            call argr4 ( '-dz', dzgrid, 0.0, 0.0 )
            call argr4 ( '-zmax', zmax, nzeta*dzgrid,nzeta*dzgrid)
            call argi4 ( '-sx', nxave, 0, 0 )
            call argi4 ( '-sz', nzave, 0, 0 )

      return
      end

      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Execute VSMOOTH by typing vsmooth and a list of program',
     :' parameters.'
      write(LER,*)
      write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
        write(LER,*)
     :'Enter the following parameters, or use the default values:'
        write(LER,*)
        write(LER,*)
     :' -L [line]  : Complete path for INPUT Line ID. : (NO DEFAULT)'
        write(LER,*)
     :'              Enter path name(i.e. /m/trc/zxxx01/data/linexyz)'
        write(LER,*)
     :'              to prefix input and output files.'
        write(LER,*)
       write(LER,*)
     :' -nx : Number of cells in x direction: (no default)'
       write(LER,*)
     :' -nz : Number of cells in z direction: (no default)'
       write(LER,*)
     :' -dx : Cell width in x direction: (no default)'
       write(LER,*)
     :' -dz : Cell width in z direction: (no default)'
       write(LER,*)
     :' -zmax : Maximum depth of model: (no default)'
       write(LER,*)
     :' -sx : Number of cells to smooth in x direction: (default =1)'
       write(LER,*)
     :' -sz : Number of cells to smooth in z direction: (default =1)'
       write(LER,*)
     :' -M [matrix]: Complete path for INPUT velocity matrix file'
        write(LER,*)
     :'             	(default = /m/trc/zxxx01/data/linexyz.matrix)'
        write(LER,*)
       write(LER,*)
     :' -C [vel]   : Complete path for INPUT velocity card file'
        write(LER,*)
     :'             	(default = /m/trc/zxxx01/data/linexyz.vel)'
        write(LER,*)
       write(LER,*)
     :' -S [smatrix]: Complete path for OUTPUT velocity matrix file'
        write(LER,*)
     :'             	(default = /m/trc/zxxx01/data/linexyz.smatrix)'
        write(LER,*)
        write(LER,*)
     :'usage: vsmooth -L[line] -nx[] -nz[] -dx[] -dz[] -zmax[]'
        write(LER,*)
     :'               -sx[] -sz[]'
         write(LER,*)
     :'***************************************************************'
      return

      end
	subroutine datain(lu,nzeta,lmax,nang,maxgrp,deltrc,delray,
     :			xgrid,zgrid,zmax,nxave,nzave,nap2,
     :			tmax,nt,dipmax,dipfil,f1,f2,f3,f4,
     :			irev,itopo,jflag,jxgrp0)	
	read(lu,*)nzeta
	read(lu,*)lmax 
	read(lu,*)nang 
	read(lu,*)maxgrp
	read(lu,*)deltrc
	read(lu,*)delray
	read(lu,*)xgrid  
	read(lu,*)zgrid  
	read(lu,*)zmax   
	read(lu,*)nxave   
	read(lu,*)nzave   
	read(lu,*)nap2    
	read(lu,*)tmax    
	read(lu,*)nt      
	read(lu,*)dipmax      
	read(lu,*)dipfil      
	read(lu,*)f1
	read(lu,*)f2
	read(lu,*)f3
	read(lu,*)f4
	read(lu,*)irev
	read(lu,*)itopo
	read(lu,*)jflag
	read(lu,*)jxgrp0
	return
	end
