C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       apkr                                             *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Curtis Kruse                       ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/20  *
C  REVISED BY:  Mary Ann Thornton             REVISION DATE: 92/01/29
C       Moved code to sun for maintenance/distribution
C       Change to use system 'include' files, not Curtis'
C       Add variable 'version' for including mbsdate.h
C  REVISED BY:  Gary Murphy       V:2.1       REVISION DATE: 92/04/07
C       Changed calculation of ipansz (it was too small to receive all
C       the data requested) - also changed some writes and formats in
C       esurf.F.
c  revised by:   Gary Murphy      v:2.2       revision date: 92/05/27
c       Made pick arrays dynamic.
C  REVISED BY:  D.W. Nelson       V:3.1       REVISION DATE: 93/03/25
C       Change BIGNUM from 9E99 to 9E37 for 32-bit machines
C       Make arrays in NRMLR dynamic to reduce about 60 Mb of memory
C       Also, changed line header size to SZLNHD and added logical
C       unit LER for HP system and let ltrm = ler  /Mary Ann Thornton
C  REVISED BY:  Mary Ann Thornton V:3.2       REVISION DATE: 93/07/15
C       Code was failing on second call to openpr
C       Removed one call to openpr - only one call is allowed.
C  REVISED BY:  Gary Murphy       V:3.3       REVISION DATE: 93/08/04
C       Made maximum number of samples error a warning.
C*********************************************************************
C NAME:         AUTOMATIC PICKER                            JUN 90   *
C*********************************************************************
C
C  PURPOSE:
C
C  USAGE:
C       fap [-Nintape] [-Ootap] [-O2otap2][-V] [-h]
C
C       -N[ntap]
C               Specifies 'intape' as the input SIS data set.  If
C               omitted, standard input is used.
C
C       -O[otap]
C               Specifies 'otap' as the output SIS data set containing 
C               the trace number of the picks.
C
C	-C[card]
C		Specifies 'card' as the input cardd file. Must be
C		specified.
C
C	-P[pickfile]
C		Specifies oper pick file to be used as control points.
C
C       -V
C               Causes the program to generate verbose print output.
C
C       -h
C               Causes the program to write help information to the
C               standard output and then halts.
C
C  FILES:
C       ntap
C               Input SIS data set.  Each record contains a single
C               velocity analysis panel.  Each trace represents a
C               different velocity function within the velocity
C               analysis panel.  The input data must contain coherence
C               values which are greater than 0 (i.e. an envelope of the
C               data is a reasonable input). Values less than 0
C               are treated as control points which the solution cannot
C               pass through.
C
C       otap
C               Output SIS data set containing the picked indexes.
C               The output picks are in terms of the trace number
C               and not actual velocity.  These picks must subsequently
C               be converted to actual velocities using another program.
C
C      otap2
C               Output SIS data set containing velocity panels with
C               picks displayed.  This is intended only as a quality
C               control data set to visually verify the validity of
C               the picks.
C
C
 
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      PARAMETER (MXSAM=2048,MXTRA=2048,MXTOT=MXSAM*MXTRA,LHEAD=SZLNHD)
      PARAMETER (LPRT=26, LCRD=25, LLIST=27)
      PARAMETER (LUPICK=28)
      PARAMETER (MXREC=2, MAXA=MXSAM*MXTRA*MXREC)
#ifdef HPUXSYSTEM
c     unit 7 should be pre-connected to stderr on HP systems
      parameter (LER=7)
#else
      parameter (LER=0)
#endif
C
      DIMENSION IHEAD(LHEAD)
      DIMENSION RXX(MXSAM+ITRWRD),DATA(MXSAM)
C
      REAL ETOT(1),A(1),E(1)
      REAL EREC(1),ERECLAST(1),PICKS(1)
      REAL AMIN(1),AAVG(1),AAVG2(1)
      POINTER (PTRETOT,ETOT)
      POINTER (PTRA,A)
      POINTER (PTRE,E)
      POINTER (PEREC,EREC)
      POINTER (PERECL,ERECLAST)
      POINTER (PTRPICKS,PICKS)
      POINTER (PAMIN,AMIN)
      POINTER (PAAVG,AAVG)
      POINTER (PAAVG2,AAVG2)

      REAL TIME(0:MXSAM),VEL(0:MXSAM)
      INTEGER PATHTYPE(4),RTPATH(4)
      REAL BIGNUM
      REAL ERRBIAS,CUTOFF
      INTEGER FIRSTREC,LASTREC,ESIZE,ETOTSIZE
      INTEGER RINC
      REAL EAVG,ETOTAVG
      REAL PEAKPWR,TREXP
      REAL AMULT,ESHIFT
      INTEGER RECMIX
      INTEGER KRECS,RECSTEP,BLCKSIZE,NVECTOR
      INTEGER DEBUG
 
C
      INTEGER*2 IRX(LNTRHD),THDR(LNTRHD,MXTRA)
C
      INTEGER ZONLY
      pointer (ppicknum, picknum)
      pointer (precpick, recpick)
      pointer (ptrpick, trpick)
      pointer (psamppick, samppick)
      INTEGER PICKNUM(1),RECPICK(1)
      INTEGER TRPICK(1),SAMPPICK(1)
      INTEGER P1STREC,PLASTREC,PRECINC,TOLERNCE
      INTEGER ERRFLAG,HFLAG
      INTEGER RFFLAG,RRFLAG,ZFFLAG,ZRFLAG,RIFLAG
      CHARACTER*1   PARR(66)
      CHARACTER*4  PPNAME
      CHARACTER*4  VERSION
      CHARACTER*128 NTAP,OTAP,OTAP2,OTAP3,OTAP4,OTAP5,INPUT
      CHARACTER*128 PICKFILE
C
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
 
#include "apkr.h"
#include "dpzt.h"
 
C
      DATA VERSION/' 3.3'/
      DATA PPNAME/'APKR'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ','A','U','T','O','M','A','T','I','C',' ','F','U','N',
     3'C','T','I','O','N',' ','P','I','C','K','E',
     3          'R',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
      data jabort /0/
C
      ZONLY=0
      LTRM = LER
      IPRT = LPRT
      JERR = 0
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN PRINTOUT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      CALL cmdlin(NTAP,OTAP,OTAP2,OTAP3,OTAP4,OTAP5,INPUT,
     @  PICKFILE,IPIPI,IPIPO,LTRM,VERBOS,DEBUG,ERRFLAG,
     @  RFFLAG,RRFLAG,ZFFLAG,ZRFLAG,RIFLAG)
      write(lprt,*)'flags=',RFFLAG,RRFLAG,ZFFLAG,ZRFLAG,RIFLAG
      write(lprt,*)' debug=',debug

      IF(IPIPI.EQ.0) THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN=0
         LTRM=2
      ENDIF
      IF(IPIPO.EQ.0) THEN
C        LUOUT IS AN OUTPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT = 1
      ENDIF
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C        OPEN OPTIONAL OUTPUT FILES
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(OTAP2.NE.' ') CALL LBOPEN(LUOUT2,OTAP2,'w')
      IF(OTAP3.NE.' ') CALL LBOPEN(LUOUT3,OTAP3,'w')
      IF(OTAP4.NE.' ') CALL LBOPEN(LUOUT4,OTAP4,'w')
      IF(OTAP5.NE.' ') CALL LBOPEN(LUOUT5,OTAP5,'w')
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN OPER PICKFILE CONTAINING CONTROL POINTS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(PICKFILE.NE.' ')THEN
C          CALL LBOPEN(LUPICK,PICKFILE,'r')
          OPEN(UNIT=LUPICK,FILE=PICKFILE,STATUS='OLD',IOSTAT=JERR)
          if (jerr .ne. 0) then
             write(lprt,*) 'error opening pickfile', pickfile
             stop 100
          else
             write(lprt,*)'opened file ',pickfile,' on lu ',lupick
             rewind (lupick)
          endif
          call countpicks (lupick, npick)
          write(lprt,*)'number of bytes ', 4*(npick+1)*iszbyt
          call galloc (ppicknum, (npick+1)*iszbyt, ier1, jabort)
          call galloc (precpick, (npick+1)*iszbyt, ier2, jabort)
          call galloc (ptrpick, (npick+1)*iszbyt, ier3, jabort)
          call galloc (psamppick, (npick+1)*iszbyt, ier4, jabort)
          ierr = ier1+ier2+ier3+ier4
          if (ierr .ne. 0) then
             write (LPRT,*) ' error allocating pick arrays'
             stop 100 
          endif
          CALL READPICK(LUPICK,PICKNUM,RECPICK,TRPICK,
     &                  SAMPPICK,NPICK)
          CLOSE(LUPICK)
 
      ENDIF
      WRITE(LPRT,38)NTAP
   38 FORMAT(' INPUT DATASET = ',/,A128)
      IF(PICKFILE.NE.' ')WRITE(LPRT,39)PICKFILE
   39 FORMAT(' INPUT OPER PICK FILE= ',/,A128)
 
      IF(OTAP.NE.' ')WRITE(LPRT,900)OTAP
      IF(OTAP2.NE.' ')WRITE(LPRT,902)OTAP2
      IF(OTAP3.NE.' ')WRITE(LPRT,903)OTAP3
      IF(OTAP4.NE.' ')WRITE(LPRT,904)OTAP4
      IF(OTAP5.NE.' ')WRITE(LPRT,905)OTAP5
900   FORMAT(' OUTPUT DATASET OF PICKED TRACE NUMBERS = '/,A128)
902   FORMAT(' OUTPUT DATASET OF ERROR SURFACE AND PICKS ='/,A128)
903   FORMAT(' OUTPUT DATASET OF ERROR SURFACE AFTER UPWARD AND '
     & ,'DOWNWARD PASS = '/,A128)
904   FORMAT(' OUTPUT DATASET OF ERROR SURFACE AFTER FORWARD AND'
     & ,'BACKWARD PASS = ',/,A128)
905   FORMAT(' OUTPUT DATASET OF ERROR SURFACE AFTER FINAL PASS =',
     & /,A128)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN CARD FILE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JERR = 0
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)' ERROR OPENING INPUT CARD FILE'
            STOP 50
         ENDIF
      ELSE
         N=ICOPEN('-apkr.crd',LCRD)
            IF(N.EQ.0)THEN
               WRITE(LPRT,*)'  YOU MUST SUPPLY INPUT PARAMETERS'
               STOP 50
            ENDIF
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ INPUT CARDS, SET UP JOB PARAMETERS, WRITE THEM OUT        C
C     JOBNAM = MOD DATASET NAME, FMIN-FMAX=FREQUENCY LIMITS
C     IPADTR-IPADRC=EITHER PAD OR NO PAD TRACES & RECORDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL READCARD(LCRD,FIRSTREC,LASTREC,RINC,RECMIX,
     &      ERRBIAS,PEAKPWR,CUTOFF,DTRDZ,TREXPON,DTRDREC,
     &      ITRSM1,ITRSM2,IZSM1,IZSM2,PATHTYPE,NFILT,
     &      NVEL,BEGVEL,VINC,
     &      TIME,VEL,NDEPTH,
     &      P1STREC,PLASTREC,PRECINC,TOLERNCE,AMULT,ESHIFT)
 
 
      TREXP = TREXPON
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ LINE HEADER AND PICK OUT PARAMETERS NEEDED TO READ TRACES*
C     LTR   = NUMBER OF TRACES PER RECORD
C     NREC  = NUMBER OF RECORDS PER JOB
C     ISI   = SAMPLE RATE INTERVAL (I.E. 4 INDICATES 4 MILLISECONDS)
C     KSAMP = NUMBER OF DATA SAMPLES PER TRACE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JEOF = 0
      CALL RTAPE(LUIN,IHEAD,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      call saver(ihead,'NumTrc',ltr,linhed)
      call saver(ihead,'NumRec',nrec,linhed)
      call saver(ihead,'Format',isi,linhed)
      call saver(ihead,'NumSmp',ksamp,linhed)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     SET DEFAULTS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
          WRITE(LPRT,*)' '
      IF(FIRSTREC.LT.1)THEN
          WRITE(LPRT,*)'FIRST RECORD DEFAULTING TO 1'
          WRITE(LPRT,*)' '
          FIRSTREC=1
      ENDIF
 
      IF(LASTREC.GT.NREC.OR.LASTREC.EQ.0) THEN
          WRITE(LPRT,*)'LAST RECORD DEFAULTING TO ',NREC
          WRITE(LPRT,*)' '
          LASTREC=NREC
      ENDIF
 
      IF(RINC.LT.1) THEN
          WRITE(LPRT,*)'RECORD INCREMENT DEFAULTING TO 1'
          WRITE(LPRT,*)' '
          RINC=1
      ENDIF
 
      IF(FIRSTREC.LT.1)FIRSTREC=1
      IF(LASTREC.GT.NREC)LASTREC=NREC
      NUMRECS = (LASTREC-FIRSTREC)/RINC + 1
 
      IF(RECMIX.EQ.0.OR.RECMIX.GT.RINC)RECMIX=RINC
 
      IF(P1STREC.LT.1.AND.PICKFILE.NE.' ')THEN
          WRITE(LPRT,*)'FIRST RECORD OF CONTROL POINT FILE',
     &         ' DEFAULTING TO 1'
          WRITE(LPRT,*)' '
          P1STREC=1
      ENDIF
 
      IF((PLASTREC.GT.NREC.OR.PLASTREC.LE.0).AND.PICKFILE.NE.' ') THEN
          WRITE(LPRT,*)'LAST RECORD OF CONTROL POINT FILE',
     &          ' DEFAULTING TO ',NREC
          WRITE(LPRT,*)' '
          PLASTREC=NREC
      ENDIF
 
      IF(PRECINC.LT.1.AND.PICKFILE.NE.' ') THEN
          WRITE(LPRT,*)'RECORD INCREMENT OF CONTROL POINT FILE',
     &       ' DEFAULTING TO 1'
          WRITE(LPRT,*)' '
          PRECINC=1
      ENDIF
 
      IF(TOLERNCE.EQ.0.AND.PICKFILE.NE.' ') THEN
          WRITE(LPRT,*)'CONTROL POINT TOLERANCE DEFAULTING TO 0'
          WRITE(LPRT,*)' '
          TOLERNCE = 0
      ENDIF
 
 
      IF(DTRDZ.LE.0.) THEN
          WRITE(LPRT,*)'TRACE/DEPTH SMOOTHNESS DEFAULTING TO 1.'
          WRITE(LPRT,*)' '
          DTRDZ=1.
      ENDIF
 
      IF(NUMRECS.EQ.1) DTRDREC=0.0
      IF(DTRDREC.LE.0.0) THEN
          WRITE(LPRT,*)'TRACE/RECORD SMOOTHNESS = 0'
          WRITE(LPRT,*)'NO RECORD TO RECORD CONSISTENCY WILL BE APPLIED'
          WRITE(LPRT,*)' '
          DTRDREC=1.
          ZONLY=1
      ENDIF
 
      ITRSM1 = ITRSM1/RINC
 
      ITRSM2 = ITRSM2/RINC
 
      IF(PATHTYPE(1).EQ.0.AND.
     &   PATHTYPE(2).EQ.0.AND.
     &   PATHTYPE(3).EQ.0.AND.
     &   PATHTYPE(4).EQ.0) THEN
          WRITE(LPRT,*)'PATHTYPES DEFAULTING TO ',
     &          'PATHTYPE 2 AND PATHYPE 3 ONLY'
          WRITE(LPRT,*)' '
          PATHTYPE(2)= 1
          PATHTYPE(3)= 1
      ENDIF
 
 
      IF(NDEPTH.EQ.0)THEN
          VEL(0)=0.0
          VEL(1)=0.0
          TIME(0)=0.0
          TIME(1)=KSAMP*ISI
          NDEPTH=2
          WRITE(LPRT,*)'NO GUIDE VELOCITY FUNCTION ENTERED DEFAULTING'
          WRITE(LPRT,*)'TO CONSTANT INDEX AS GUIDE'
          WRITE(LPRT,*)' '
      ENDIF
 
      IF(VINC.EQ.0.0)THEN
          VINC=1.
          WRITE(LPRT,*)'VELOCITY INCREMENT DEFAULTING TO 1.'
          WRITE(LPRT,*)' '
      ENDIF
 
      IF(NVEL.EQ.0)THEN
          NVEL=LTR
          WRITE(LPRT,*)'NUMBER OF VELOCITY FUNCTIONS DEFAULTING TO ',LTR
          WRITE(LPRT,*)' '
      ENDIF
 
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      ITRSZ = KSAMP+1
      IF(ITRSZ*.5.EQ.ITRSZ/2)ITRSZ = ITRSZ + 1
      IRECSZ = (LTR+1)*ITRSZ
      IF(IRECSZ*.5.EQ.IRECSZ/2)IRECSZ = IRECSZ + 1
      IPANSZ=(NREC+1)*ITRSZ
      IF(IPANSZ*.5.EQ.IPANSZ/2)IPANSZ = IPANSZ + 1
 
      ESIZE = IRECSZ*NUMRECS
      ETOTSIZE = IRECSZ*(NUMRECS+1)
      call savew(ihead,'NumRec',numrecs,linhed)
 
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C        ALLOCATE MEMORY                                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      KODE=0
      NVECTOR=64
      ISIZE=MAX(ETOTSIZE,MIN(NUMRECS,NVECTOR)*IRECSZ*2)
      rb=iszbyt*(2*etotsize+2*irecsz+ipansz+isize)
      PRINT*,"Allocating ",rb/(1024.*1024.)," Mbytes"
      CALL galloc(PTRA,ETOTSIZE*ISZBYT,KODE,1)
      CALL galloc(PTRETOT,ETOTSIZE*ISZBYT,KODE,1)
      CALL galloc(PTRE,ISIZE*ISZBYT,KODE,1)
      CALL galloc(PEREC,IRECSZ*ISZBYT,KODE,1)
      CALL galloc(PERECL,IRECSZ*ISZBYT,KODE,1)
      CALL galloc(PTRPICKS,IPANSZ*ISZBYT,KODE,1)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
 
      IF(IRECSZ.GT.MXTOT)THEN
         WRITE(LPRT,*)' maximum no. of sample per record is ',MXTOT
         WRITE(LPRT,*)' actual  no. of sample per record is ',IRECSZ
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
      IF(ESIZE.GT.MAXA)THEN
         WRITE(LPRT,*)' ACTUAL  NO. DATA VALUES IS ',ESIZE
         WRITE(LPRT,*)' Warning --- may thrash on workstation'
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     HLH WILL PRINT LINEHEADER AND UPDATE THE HISTORICAL PORTION    *
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      LEN=4
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LPRT)
      IF(OTAP2.NE.' ') CALL WRTAPE(LUOUT2,IHEAD,JEOF)
      IF(OTAP3.NE.' ') CALL WRTAPE(LUOUT3,IHEAD,JEOF)
      IF(OTAP5.NE.' ') CALL WRTAPE(LUOUT5,IHEAD,JEOF)
      IF(RIFLAG.EQ.1) then
         nnn=NUMRECS+1
         call savew(ihead,'NumRec',nnn,linhed)
      endif
      IF(OTAP4.NE.' ') CALL WRTAPE(LUOUT4,IHEAD,JEOF)
 
      call savew(ihead,'NumTrc',numrecs,linhed)
      call savew(ihead,'NumRec',1,linhed)
      IF(OTAP.NE.' ') CALL WRTAPE(LUOUT,IHEAD,JEOF)
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C      WRITE PARAMETERS TO USER REPORT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      WRITE(LPRT,271) FIRSTREC,LASTREC,RINC,RECMIX,ERRBIAS,PEAKPWR,
     &CUTOFF,DTRDZ,TREXP,DTRDREC,AMULT,ESHIFT,
     &PATHTYPE(1),PATHTYPE(2),PATHTYPE(3),PATHTYPE(4)
271   FORMAT(//,7X, 'INPUT PARAMETERS AFTER DEFAULTS:',
     &       //, 'FIRST RECORD TO PROCESS................',4X,I5,
     &       //, 'LAST RECORD TO PROCESS.................',4X,I5,
     &       //, 'RECORD INCREMENT.......................',4X,I5,
     &       //, 'NUMBER OF RECORDS TO MIX...............',4X,I5,
     &       //, 'BIAS ON ERROR CALCULATION..............',1X,F8.4,
     &       //, 'POWERING EXPONENT FOR ERROR............',1X,F8.4,
     &       //, 'CUTTOF VALUE FOR ERROR.................',1X,F8.4,
     &       //, 'TRACE/DEPTH SMOOTHNESS.................',1X,F8.4,
     &       //, 'TRACE/DEPTH EXPONENT...................',1X,F8.4,
     &       //, 'TRACE/RECORD SMOOTHNESS................',1X,F8.4,
     &       //, 'TRACE/RECORD ERROR MIXING..............',1X,F8.4,
     &       //, 'DC SHIFT FOR LATERAL SMOOTHING.........',1X,F8.4,
     &       //, 'PATHTYPE 1.............................',4X,I5,
     &       //, 'PATHTYPE 2.............................',4X,I5,
     &       //, 'PATHTYPE 3.............................',4X,I5,
     &       //, 'PATHTYPE 4.............................',4X,I5)
 
      WRITE(LPRT,2731)
     &      ITRSM1,ITRSM2,IZSM1,IZSM2
2731  FORMAT(//, 'ITRSM1.................................',4X,I5,
     &       //, 'ITRSM2.................................',4X,I5,
     &       //, 'IZSM1..................................',4X,I5,
     &       //, 'IZSM2..................................',4x,I5)
 
      IF(NVEL.GT.0)THEN
          WRITE(LPRT,272)NVEL,BEGVEL,VINC
272       FORMAT(//,7X,'VELOCITY FUNCTION PERTURBATIONS',
     &       //, 'NUMBER OF VELOCITY FUNCTIONS...........',4X,I5,
     &       //, 'BEGINNING VELOCITY.....................',1X,F8.2,
     &       //, 'VELOCITY INCREMENT.....................',1X,F8.2)
      ENDIF
 
      IF(PICKFILE.NE.' ')THEN
          WRITE(LPRT,273)PICKFILE,P1STREC,PLASTREC,PRECINC,TOLERNCE
273       FORMAT(//,7X,'CONTROL POINT FILE - ',A80,
     &       //, 'FIRST RECORD (CONTROL POINT FILE)......',4X,I5,
     &       //, 'LAST RECORD  (CONTROL POINT FILE)......',4X,I5,
     &       //, 'RECORD INCREMENT (CONTROL POINT FILE)..',4X,I5,
     &       //, 'CONTROL POINT TOLERANCE................',4X,I5)
      ENDIF
 
      WRITE(LPRT,*) ' '
      WRITE(LPRT,*)'  GUIDE VELOCITY FUNCTION'
      WRITE(LPRT,*)'      TIME  VELOCITY'
      WRITE(LPRT,274)(TIME(I),VEL(I),I=1,NDEPTH)
274   FORMAT(F10.2,F10.2)
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     PARAMETER CHECKING
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(CUTOFF.LT.-1. .OR. CUTOFF.GT.1.)THEN
          WRITE(LPRT,263)CUTOFF
263       FORMAT(/, 1X,'** ERROR ON INPUT PARAMETERS ',/,
     &    '** CUTOFF MUST BE BETWEEN -1. AND 1.',/,
     &    '** CUTOFF = ',F8.2)
          STOP 100
      ENDIF
 
      IF(ERRBIAS.LT.0.0) THEN
          WRITE(LPRT,264)ERRBIAS
264       FORMAT(/, 1X,'** ERROR ON INPUT PARAMETERS ',/,
     &    '** ERRBIAS MUST BE GREATER THAN 0    ',/,
     &    '** ERRBIAS = ',F8.2)
          STOP 100
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  Read in data to A                                                 C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      LA=0
      JA=0
      JR = 0
      IREC = 0
      JREND = 0
      CALL VCLR(A,1,IRECSZ*NUMRECS)
      DO 100 IR=FIRSTREC,LASTREC,RINC
      write(*,*)'READING RECORD ',IR
         IREC = IREC + 1
         HFLAG = 0
         ISHIFT = RECMIX/2
         JRLAST = JREND
         JRBEG = MAX(1,IR-ISHIFT)
         JREND = MIN(IR-ISHIFT+RECMIX-1,NREC)
         IF(VERBOS)WRITE(LPRT,*)' '
         IF(VERBOS)
     &   WRITE(LPRT,*)'BUILDING RECORD ',IR,' FROM',JRBEG,'-',JREND
 
C        ---------skip records----------
         DO 200 JR=JRLAST+1,JRBEG-1
            IF(VERBOS)WRITE(LPRT,*)'SKIPPING RECORD ',JR
            DO 300 L=1,LTR
                JEOF = 0
                CALL RTAPE(LUIN,RXX,JEOF)
                IF(JEOF.EQ.0) GO TO 1500
300         CONTINUE
200      CONTINUE
 
 
C        -------read and sum records--------
         DO 210 JR = JRBEG,JREND
            IF(VERBOS)WRITE(LPRT,*)
     &           '  SUMMING RECORD ',JR,' INTO REC ',IR
            LA = JA
            DO 310 L=1,LTR
 
                JEOF = 0
                CALL RTAPE(LUIN,RXX,JEOF)
                IF(JEOF.EQ.0) GO TO 1500
C                CALL VADD(DATA,1,A(LA+1),1,E,1,KSAMP)
                DO 9088 I=1,KSAMP
                   E(I)=DATA(I)+A(LA+1+I)
9088            CONTINUE
                CALL VMOV(E,1,A(LA+1),1,KSAMP)
                LA = LA + ITRSZ
C               ------take first live trace header
                IF(JR.EQ.IR.AND.HFLAG.EQ.0.AND.
     &                (IRX(125).NE.30000.OR.IR.EQ.LASTREC)) THEN
                   HFLAG=1
                   IF(IRX(125).EQ.30000) IRX(125)=0
                   CALL VMOV(IRX,1,THDR(1,IREC),1,ITRWRD)
                ENDIF
 
310          CONTINUE
             LA = LA + ITRSZ
210      CONTINUE
         JA = JA + IRECSZ
100   CONTINUE
101   CONTINUE
 
      WRITE(LPRT,*)'number of records           = ',NUMRECS
      WRITE(LPRT,*)'number of traces per record = ',LTR
      WRITE(LPRT,*)'ESIZE=',ESIZE
      WRITE(LPRT,*)'ETOTSIZE=',ETOTSIZE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  Forward pass                                                         C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      ETOTAVG=0.0
      CALL GRIDINIT(1./DTRDZ,1.,RINC/DTRDREC)
      CALL PRTGRID()
      DO 555 I=1,NDEPTH
        PRINT*,I,"TIME=",TIME(I)
555   CONTINUE
      CALL VGUIDE(VEL(1),TIME(1),NDEPTH,VINC,KSAMP,ISI)
 
      CALL PRTGUIDE()
      IF(ERRFLAG.NE.1)THEN
        CALL COH2ERR(A,KSAMP,LTR,NUMRECS,CUTOFF,ERRBIAS,PEAKPWR,AMAX)
      ELSE
        CALL ERRNORM(A,NUMRECS,LTR,KSAMP)
      ENDIF
 
C      CALL TRFILT3(A,LTR,ITRSZ,NFILT,NFILT,.333333333)
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  CONTROL POINTS                                                     C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(PICKFILE.NE.' ')THEN
          CALL PICKCNTL(A,PICKNUM,RECPICK,TRPICK,SAMPPICK,
     &           NPICK,NREC,LTR,KSAMP,
     &           FIRSTREC,RINC,NUMRECS,P1STREC,PRECINC,TOLERNCE)
      ENDIF
 
C      CALL VFILL(BIGNUM,E,1,ESIZE)
      DO 7378 I=1,ESIZE
         E(I)=BIGNUM
7378  CONTINUE
 
 
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
C      CALL VFILL(BIGNUM,ETOT,1,ETOTSIZE)
      DO 8324 I=1,ETOTSIZE
         ETOT(I)=BIGNUM
8324  CONTINUE
 
 
 
      IFLAG=0
      IF(ZONLY.EQ.1)IFLAG=1
      IF(ZFFLAG.EQ.1) THEN
         IFLAG=1
         ZONLY=1
      ELSEIF(ZRFLAG.EQ.1)THEN
         IFLAG=2
         ZONLY=1
      ENDIF
 
 
C     ----perform downward and upward pass on A to create E------
      CALL SUMDPZT(A,E,ETOT,KSAMP,LTR,NUMRECS,PATHTYPE,IFLAG)
 
C     ------interpolate from nodes to center of cells------
      IF(RIFLAG.EQ.0)print*,"not riflag"
      IF(RIFLAG.EQ.1)print*,"riflag"
      IF(RIFLAG.EQ.0 .OR. ZONLY.EQ.0)THEN
      CALL TREINDEX(E,KSAMP,LTR,NUMRECS,ZONLY)
      ENDIF
 
 
 
C ------normalize each record to similar average and remove DC shift---
       CALL TSCALEE(E,KSAMP,LTR,NUMRECS,EAVG)
ccc       CALL NRMLZ(E,NUMRECS,LTR,KSAMP,IZSM1,IZSM2,ITRSM1,ITRSM2)
C      CALL NORMZ2(E,KSAMP,LTR,NUMRECS,EAVG)
 
 
      IF(ZONLY.EQ.1) GOTO 7117
 
C     -----intermediate output-------------------------
      EAVG=0.0
      LA = 0
      IF ( OTAP3.NE.' ') THEN
      DO 503 IR = 1,NUMRECS
          LA = (IR-1)*IRECSZ
          IP = (IR-1)*ITRSZ+1
          CALL VMOV(THDR(1,IR),1,IRX,1,ITRWRD)
          DO 513 L = 1,LTR
              IRX(107)=L
              DO 523 K=1,KSAMP
                  DATA(K) = E(LA+K)
	          IF ( DATA(K).GE.BIGNUM) DATA(K)=-EAVG
523           CONTINUE
              CALL WRTAPE(LUOUT3,RXX,JEOF)
              LA = LA + ITRSZ
513       CONTINUE
503   CONTINUE
      ENDIF
 
 
 
      RTPATH(1)=1
      RTPATH(2)=1
      RTPATH(3)=1
      RTPATH(4)=1
 
C     ------clear ETOT which is where forward + backward pass
C     ------will be stored after calls to FORDPRT and REVDPRT
      CALL VCLR(ETOT,1,ETOTSIZE)
 
C     ------forward pass over E with result added to ETOT-----
      IF(RRFLAG.EQ.0)THEN
      CALL FORDPRT(E,ETOT,EREC,ERECLAST,KSAMP,LTR,NUMRECS,RTPATH)
      ENDIF
 
C     ------backwards pass over E with result added to ETOT----
      IF(DEBUG.EQ.1)WRITE(LPRT,*)'REVDPRT'
      IF(RFFLAG.EQ.0)THEN
      CALL REVDPRT(E,ETOT,EREC,ERECLAST,KSAMP,LTR,NUMRECS,RTPATH)
      ENDIF
 
C     -----interpolate from nodes to center of cells-----------
      IF(DEBUG.EQ.1)WRITE(LPRT,*)'RREINDEX'
      IF(RIFLAG.EQ.0)THEN
        CALL RREINDEX(ETOT,KSAMP,LTR,NUMRECS)
      ENDIF
 
C -----normalize each record to similar average and remove DC shift---
C      CALL NORMZ(ETOT,KSAMP,LTR,NUMRECS,ETOTAVG)
CC      CALL SCALE2(ETOT,KSAMP,LTR,NUMRECS,ETOTAVG)
      IF(IZSM1.NE.IZSM2.OR.ITRSM1.NE.ITRSM2)THEN
        IF(DEBUG.EQ.1)WRITE(LPRT,*)'NRMLR'
        rb=iszbyt*(3*ipansz)
        PRINT *,"Allocating ",rb/(1024.*1024.)," Mbytes"
        CALL galloc(PAMIN,IPANSZ*ISZBYT,KODE,1)
        CALL galloc(PAAVG,IPANSZ*ISZBYT,KODE,1)
        CALL galloc(PAAVG2,IPANSZ*ISZBYT,KODE,1)
        CALL NRMLR(E,AMIN,AAVG,AAVG2,
     +             NUMRECS,LTR,KSAMP,IZSM1,IZSM2,ITRSM1,ITRSM2)
      ENDIF
C      CALL TSCALEE(ETOT,KSAMP,LTR,NUMRECS,ETOTAVG)
      IF(DEBUG.EQ.1)WRITE(LPRT,*)'ERRMIX'
      IF(ESHIFT.NE.0.0)THEN
      CALL ERRMIX(ETOT,A,KSAMP,LTR,NUMRECS,AMULT,ESHIFT)
      ENDIF
C      CALL ERRMULT(ETOT,A,KSAMP,LTR,NUMRECS,AMULT,ESHIFT)
 
C****************
      IE=1
      DO 463 IR = 1,NUMRECS
C          CALL VMUL(ETOT(IE),1,A(IE),1,E,1,IRECSZ)
C          CALL VMOV(E,1,ETOT,1,IRECSZ)
          IE = IE + IRECSZ
463   CONTINUE
cccccccccccccccc
C     CALL TSCALEE(E,KSAMP,LTR,NUMRECS,ESIZE)
cccccccccccccccc
 
C     -----intermediate output-------------------------
      ETOTAVG=0.0
      IF ( OTAP4.NE.' ') THEN
      IF(DEBUG.EQ.1)WRITE(LPRT,*)'WRITING TO OTAP4'
      LA = 0
      JRECS = NUMRECS
      IF(RIFLAG.EQ.1)JRECS=NUMRECS+1
      DO 504 IR = 1,JRECS
          LA = (IR-1)*IRECSZ
          IP = (IR-1)*ITRSZ+1
          CALL VMOV(THDR(1,IR),1,IRX,1,ITRWRD)
          DO 514 L = 1,LTR
              IRX(107)=L
              DO 524 K=1,KSAMP
                  DATA(K) = ETOT(LA+K)
	          IF ( DATA(K).GE.BIGNUM/20.) DATA(K)= 0.0
		  IF(PICKS(K+IP).EQ.L)DATA(K)= 0.0
524           CONTINUE
              CALL WRTAPE(LUOUT4,RXX,JEOF)
              LA = LA + ITRSZ
514       CONTINUE
504   CONTINUE
      ENDIF
 
 
 
       RECSTEP = MIN(NVECTOR,NUMRECS)
 
      IF(DEBUG.EQ.1)WRITE(LPRT,*)'SUMDPZT'
      DO 600 IR=1,NUMRECS,RECSTEP
           KRECS = MIN(RECSTEP,NUMRECS-IR+1)
           BLCKSIZE = KRECS*IRECSZ
           CALL VFILL(BIGNUM,E,1,BLCKSIZE)
           CALL VFILL(BIGNUM,E(BLCKSIZE+1),1,BLCKSIZE)
           DO 1833 I=1,2*BLCKSIZE
              E(I)=BIGNUM
1833       CONTINUE
           IE = (IR-1)*IRECSZ+1
           CALL SUMDPZT(ETOT(IE),E,E(BLCKSIZE+1),
     &                 KSAMP,LTR,KRECS,PATHTYPE,1)
           CALL VMOV(E,1,ETOT(IE),1,BLCKSIZE)
600   CONTINUE
 
 
C     ------interpolate from nodes to center of cells------
      IF(DEBUG.EQ.1)WRITE(LPRT,*)'TREINDEX'
      IF(RIFLAG.NE.1)THEN
      CALL TREINDEX(ETOT,KSAMP,LTR,NUMRECS,1)
      ENDIF
 
 
7117   CONTINUE
 
      IF(ZONLY.EQ.1) CALL VMOV(E,1,ETOT,1,ESIZE)
 
      CALL MPATH(ETOT,KSAMP,LTR,NUMRECS,PICKS)
c     CALL MINPATH(ETOT,KSAMP,LTR,NUMRECS,PICKS)
 
 
C     -----intermediate output-------------------------
      IF ( OTAP5.NE.' ') THEN
 
C       CALL NORMREC2(ETOT,KSAMP,LTR,NUMRECS,ETOTAVG)
cc      CALL MINNRMLZ(ETOT,NUMRECS,LTR,KSAMP,E,EMIN)
cc      CALL ZEROMIN(ETOT,NUMRECS,LTR,KSAMP)
 
      LA = 0
      DO 505 IR = 1,NUMRECS
          LA = (IR-1)*IRECSZ
          IP = (IR-1)*ITRSZ
          CALL VMOV(THDR(1,IR),1,IRX,1,ITRWRD)
          DO 515 L = 1,LTR
              IRX(107)=L
              DO 525 K=1,KSAMP
                  DATA(K) = ETOT(LA+K)
C	          IF ( DATA(K).GE.BIGNUM/20.) DATA(K)=-ETOTAVG*.2
	          IF ( DATA(K).GE.BIGNUM/20.) DATA(K)=-1000.
C		  IF(PICKS(K+IP).EQ.L)DATA(K)=-ETOTAVG
C		  IF(PICKS(K+IP).EQ.L)DATA(K)=0.0
 
525           CONTINUE
              CALL WRTAPE(LUOUT5,RXX,JEOF)
              LA = LA + ITRSZ
515       CONTINUE
505   CONTINUE
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
9117  CONTINUE
C     -----intermediate output-------------------------
      IF ( OTAP2.NE.' ') THEN
      LA = 0
      DO 501 IR = 1,NUMRECS
          LA = (IR-1)*IRECSZ
          IP = (IR-1)*ITRSZ
          CALL VMOV(THDR(1,IR),1,IRX,1,ITRWRD)
          DO 511 L = 1,LTR
              IRX(107)=L
              DO 521 K=1,KSAMP
                  DATA(K) = A(LA+K)
	          IF ( DATA(K).GE.BIGNUM/20.) DATA(K)=-.5
		  IF(PICKS(K+IP).EQ.L)DATA(K)=0.0
521           CONTINUE
              CALL WRTAPE(LUOUT2,RXX,JEOF+ISZBYT)
              LA = LA + ITRSZ
511       CONTINUE
501   CONTINUE
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     -----output picks-----------------------------------
      IF ( OTAP.NE.' ') THEN
      LA = 0
      DO 500 IR = 1,NUMRECS
          CALL VMOV(THDR(1,IR),1,IRX,1,itrwrd)
          IRX(110)=IRX(106)
          IRX(106)=1
          IRX(107)=IR
 
          DO 510 IZ = 1,KSAMP
              IP = (IR-1)*ITRSZ + IZ
              DATA(IZ) = PICKS(IP)
510       CONTINUE
          CALL WRTAPE(LUOUT,RXX,JEOF)
500   CONTINUE
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
      WRITE(LPRT,*) ' JOB COMPLETE'
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(6,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      IF(OTAP2.NE.' ') CALL LBCLOS(LUOUT2)
      IF(OTAP3.NE.' ') CALL LBCLOS(LUOUT3)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(6,1510)IR,L
 1510 FORMAT(2X,'TAPEIO ERROR PROCESSING OUTPUT RECORD',I5,' TRACE',I5)
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      IF(OTAP2.NE.' ') CALL LBCLOS(LUOUT2)
      IF(OTAP3.NE.' ') CALL LBCLOS(LUOUT3)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR READING CARDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
3000  CONTINUE
      WRITE(6,3011)
3011  FORMAT(2X,'ERROR READING PARAMETER CARD')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      IF(OTAP2.NE.' ') CALL LBCLOS(LUOUT2)
      IF(OTAP3.NE.' ') CALL LBCLOS(LUOUT3)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      IF(OTAP2.NE.' ') CALL LBCLOS(LUOUT2)
      IF(OTAP3.NE.' ') CALL LBCLOS(LUOUT3)
      IF(OTAP4.NE.' ') CALL LBCLOS(LUOUT4)
      IF(OTAP5.NE.' ') CALL LBCLOS(LUOUT5)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                             *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,OTAP,OTAP2,OTAP3,OTAP4,OTAP5,INPUT,PICKFILE,      *
C              IPIPI,IPIPO,LTRM,VERBOS,DEBUG,ERRFLAG,RFFLAG,RRFLAG,    *
C              ZFFLAG,ZRFLAG,RIFLAG)                                   *
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,OTAP,OTAP2,OTAP3,OTAP4,OTAP5,INPUT,
     @  PICKFILE,IPIPI,IPIPO,LTRM,VERBOS,DEBUG,ERRFLAG,
     @  RFFLAG,RRFLAG,ZFFLAG,ZRFLAG,RIFLAG)
      INTEGER ARGIS,DEBUG,ERRFLAG
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,OTAP,OTAP2,OTAP3,OTAP4,OTAP5,INPUT,PICKFILE
      INTEGER RFFLAG,RRFLAG,ZFFLAG,ZRFLAG,RIFLAG
 
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--AUTOMATIC PICKER'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]     . INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap]     . OUTPUT DATASET NAME OF VELOCITY '
         WRITE(LTRM,*)'             . FIELD '
         WRITE(LTRM,*)'-O2[otap2]   . OUTPUT DATASET NAME OF PICKED '
         WRITE(LTRM,*)'             . VELOCITY PANELS '
         WRITE(LTRM,*)'-C[card]     . INPUT CARD '
         WRITE(LTRM,*)'-P[pickfile] . INPUT OPER PICK FILE'
         WRITE(LTRM,*)'-V           . VERBOSE PRINTOUT'
         WRITE(LTRM,*)'-e           . DO NOT COMPUTE ERROR'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'-O3[otap3]   . OUTPUT DATASET NAME OF'
         WRITE(LTRM,*)'             . ACCUMULATED ERROR SURFACE'
         WRITE(LTRM,*)'-O4[otap3]   . OUTPUT DATASET NAME OF X'
         WRITE(LTRM,*)'             . ACCUMULATED ERROR SURFACE'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'apkr -N[] -O[] -C[]'
         WRITE(LTRM,*)'apkr -N[] -O[] -O2[] -O3 -O4[] -C[] -P[] -V'
         STOP
      ENDIF
      IF((ARGIS('-dh').GT.0))THEN
         WRITE(LTRM,*)'DEBUGGING COMMAND LINE ARGUMENTS'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'-RF          RECORD ORIENTED FORWARD PASS '
         WRITE(LTRM,*)'-RR          RECORD ORIENTED REVERSE PASS '
         WRITE(LTRM,*)'-ZF          Z ORIENTED FORWARD PASS '
         WRITE(LTRM,*)'-ZR          Z ORIENTED REVERSE PASS '
         WRITE(LTRM,*)'-RI          NO REINDEXING PERFORMED'
      ENDIF
      CALL ARGSTR('-N',NTAP ,' ',' ')
      CALL ARGSTR('-O',OTAP ,' ',' ')
      CALL ARGSTR('-O2',OTAP2,' ',' ')
      CALL ARGSTR('-O3',OTAP3,' ',' ')
      CALL ARGSTR('-O4',OTAP4,' ',' ')
      CALL ARGSTR('-O5',OTAP5,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGSTR('-P',PICKFILE,' ',' ')
      CALL ARGI4('-e',ERRFLAG,1,0)
      CALL ARGI4('-D',DEBUG,0,0)
      VERBOS =   (ARGIS( '-V' ).GT.0)
      CALL ARGI4('-RF',RFFLAG,1,0)
      CALL ARGI4('-RR',RRFLAG,1,0)
      CALL ARGI4('-ZF',ZFFLAG,1,0)
      CALL ARGI4('-ZR',ZRFLAG,1,0)
      CALL ARGI4('-RI',RIFLAG,1,0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       READCA                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      READCARD  (LCRD,FIRSTREC,LASTREC,RINC,RECMIX,ERRBIAS,PEAKPWR,   *
C                 CUTOFF,DTRDZ,TSMEXP,DTRDREC,ITRSM1,ITRSM2,IZSM1,     *
C                 IZSM2,PATHTYPE,NFILT,NVEL,BEGVEL,VINC,TIME,VEL,      *
C                 NDEPTH,P1STREC,PLASTREC,PRECINC,TOLERNCE,ERRMIX,     *
C                 ESHIFT,RFFLAG,RRFLAG,ZFFLAG,ZRFLAG)                  *
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
      SUBROUTINE READCARD(LCRD,FIRSTREC,LASTREC,RINC,RECMIX,
     &      ERRBIAS,PEAKPWR,CUTOFF,DTRDZ,TSMEXP,DTRDREC,
     &      ITRSM1,ITRSM2,IZSM1,IZSM2,PATHTYPE,NFILT,
     &      NVEL,BEGVEL,VINC,
     &      TIME,VEL,NDEPTH,
     &      P1STREC,PLASTREC,PRECINC,TOLERNCE,ERRMIX,ESHIFT,
     &      RFFLAG,RRFLAG,ZFFLAG,ZRFLAG)
 
      PARAMETER (MXSAM=2048)
 
      INTEGER FIRSTREC,LASTREC,RINC,PATHTYPE(4),NVEL,LCRD
      REAL ERRBIAS,CUTOFF,DTRDZ,DTRDREC,BEGVEL,VINC,ERRMIX
      REAL TIME(0:MXSAM),VEL(0:MXSAM)
      INTEGER P1STREC,PLASTREC,PRECINC,TOLERNCE
      INTEGER ITRSM1,ITRSM2,IZSM1,IZSM2
      REAL PEAKPWR,TSMEXP,ESHIFT
      INTEGER RECMIX,NFILT
 
 
#include "apkr.h"
 
 
      CHARACTER*1  CARD(80)
      CHARACTER*4 NAME
      EQUIVALENCE (CARD(1),NAME)
 
      ESHIFT = 0.0
      ITRSM1 = 0
      ITRSM2 = 0
      IZSM1  = 0
      IZSM2  = 0
 
      DO 200 J=1,999
          READ(LCRD,77,ERR=3000,END=999)CARD
   77     FORMAT(80A1)
 
          IF(NAME.EQ.'FORM')THEN
              READ(LCRD,300,ERR=3000,END=999)
     &            FIRSTREC,LASTREC,RINC,RECMIX
  300         FORMAT(10X,I10,I10,I10,I10)
 
          ELSE IF(NAME.EQ.'SMOO')THEN
              READ(LCRD,301,ERR=3000,END=999)
     &            ERRBIAS,PEAKPWR,CUTOFF,DTRDZ,TSMEXP,DTRDREC
  301         FORMAT(10X,6F10.0)
 
 
          ELSE IF(NAME.EQ.'FILT')THEN
               WRITE(*,77)CARD
              READ(LCRD,308,ERR=3000,END=999)
     &            ITRSM1,ITRSM2,IZSM1,IZSM2
  308         FORMAT(10X,4I10)
 
          ELSE IF(NAME.EQ.'WEIG')THEN
              READ(LCRD,307,ERR=3000,END=999)
     &          ERRMIX,ESHIFT,NFILT
  307         FORMAT(10X,2F10.0,I10)
 
 
          ELSE IF(NAME.EQ.'PATH')THEN
              READ(LCRD,303,ERR=3000,END=999)
     &          PATHTYPE(1),PATHTYPE(2),PATHTYPE(3),PATHTYPE(4)
  303         FORMAT(10X,4I10)
 
          ELSE IF(NAME.EQ.'CONT')THEN
              READ(LCRD,302,ERR=3000,END=999)
     &          P1STREC,PLASTREC,PRECINC,TOLERNCE
  302         FORMAT(10X,I10,I10,I10,I10)
 
          ELSE IF(NAME.EQ.'VELO')THEN
              READ(LCRD,304,ERR=3000,END=999)
     &               NVEL,BEGVEL,VINC
  304         FORMAT(10X,BN,I10,2F10.0)
 
          ELSE IF(NAME.EQ.'VGUI')THEN
              DO 707 I=1,MXSAM
                  READ(LCRD,305,ERR=709,END=708)
     &                NAME,TIME(I),VEL(I)
  305             FORMAT(A4,6X,BN,F10.0,F10.0)
                  IF((TIME(I).EQ.0.AND.VEL(I).EQ.0).OR.
     &                     NAME.NE.'    ')GOTO 709
                  IF(I.GT.1.AND.TIME(I).LT.TIME(I-1))THEN
                      WRITE(IPRT,343)VEL(I-1),TIME(I-1)
                      WRITE(IPRT,344)VEL(I),TIME(I)
343                   FORMAT(/,'** ERROR TIMES MUST INCREASE',/
     &                '               TIME   VELOCITY',/
     &               ,10X,F10.2,F10.2)
344                   FORMAT(10X,F10.2,F10.2)
                  ENDIF
707           CONTINUE
 
709           CONTINUE
              BACKSPACE(LCRD)
          ENDIF
 
708   CONTINUE
200   CONTINUE
      GOTO 999
 
3000  CONTINUE
      WRITE(IPRT,*)'ERROR READING INPUT CARDS'
999   CONTINUE
 
      NDEPTH = I-1
      RETURN
      END
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C#
C# APKR Automatic Picker
C#
C#Execute automatic picking program with parameters in line:
C/m/ess/zcjk06/APKR/apkr   \
C       -Nntap        \
C       -Opicks       \
C       -O2pickpanls  \
C       -Pinputpicks  \
C-apkr.crd"\
CFORMAT      FIRSTREC   LASTREC   REC INC   REC MIX
C                   1       550         4         4
CSMOOTH      ERR BIAS  PEAKPOWR    CUTOFF TIMSMOOTH TIMSMEXPT RECSMOOTH
C                 .01         2       .00       1.0         2        4.
CFILTER            X1        X2        Z1        Z2
C                   5        30         5        30
CWEIGHTS     TIMEWGHT    ESHIFT    FILTER
C                  .5       .1          3
CPATHS          PATH1     PATH2     PATH3     PATH4
C                   0         1         1         0
CCONTROL      P1STREC  PLASTREC   PRECINC TOLERANCE
C
CVELOCITIES  # OF VEL   BEG VEL   VEL INC
C                  48         1         1
CVGUIDE          TIME  VELOCITY
C                   0         1
C                3496         1
C"
