 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SUMDPZ                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SUMDPZT  (A,E,EREV,NZ,NT,NR,PATHTYPE,FLAG)                      *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      EREV    REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      PATHTY  INTEGER  ??IOU*  (4)                -                   *
C      FLAG    INTEGER  ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      DPZTFO -                                                        *
C      DPZTRE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/11/19 ==================   *
C      SUMDPZT  (A,E,EREV,NZ,NT,NR,PATHTYPE)                           *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE SUMDPZT(A,E,EREV,NZ,NT,NR,PATHTYPE,FLAG)
      INTEGER NT,NZ,NR,FLAG
      REAL A((NT+1)*(NZ+1)*NR)
      REAL E((NT+1)*(NZ+1)*NR)
      REAL EREV((NT+1)*(NZ+1)*NR)
      INTEGER PATHTYPE(4)
 
      INTEGER REVPATH(4)
      REAL XVECT,YVECT
      INTEGER IT,IE,I,IR
      INTEGER ESIZE
 
#include "apkr.h"
 
      ESIZE = IRECSZ*NR
 
C     --------SET STARTING EDGE OF E AND EREV TO 0-----------------
      DO 100 IR=1,NR
	  DO 200 IT=0,NT
	      IE = (IR-1)*IRECSZ + IT*ITRSZ+1
	      E(IE)=0
	      EREV(IE+NZ)=0
200	  CONTINUE
100   CONTINUE
 
 
C      print*,"SUMDPZT-FLAG=",FLAG
      CALL DPZTFOR(A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,FLAG)
 
      REVPATH(1) = PATHTYPE(4)
      REVPATH(2) = PATHTYPE(3)
      REVPATH(3) = PATHTYPE(2)
      REVPATH(4) = PATHTYPE(1)
 
      CALL DPZTREV(A,EREV,XVECT,YVECT,NZ,NT,NR,REVPATH)
 
C     -------SUM E AND EREV TO GET TOTAL ERROR SURFACE-----------
      IF(FLAG.EQ.2)THEN
        DO 102 I=1,ESIZE
          E(I) = EREV(I)
102     CONTINUE
      ELSE IF(FLAG.NE.1) THEN
        DO 103 I=1,ESIZE
          E(I) = E(I)+EREV(I)
103     CONTINUE
      ENDIF
 
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DPZTFO                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DPZTFOR  (A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,IFLAG)              *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      XVECT   REAL     ??IOU*                     -                   *
C      YVECT   REAL     ??IOU*                     -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      PATHTY  INTEGER  ??IOU*  (4)                -                   *
C      IFLAG   INTEGER  ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      DPZT -                                                          *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C      LTRM  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/12/17 ==================   *
C      DPZTFOR  (A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE)                    *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE DPZTFOR(A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,IFLAG)
      INTEGER NT,NZ,NR
      REAL A((NT+1)*(NZ+1)*NR)
      REAL E((NT+1)*(NZ+1)*NR)
      INTEGER PATHTYPE(4),IFLAG
 
      INTEGER IT,IZ,IE,IE1,IA
 
#include "apkr.h"
 
      WRITE(LTRM,*)'DPZTFOR'
      WRITE(IPRT,*)'DPZTFOR'
 
 
      IZ = 1
      IF(PATHTYPE(1).EQ.1) THEN
          DO 100 IT=1,NT
 	      IE = IT*ITRSZ+IZ
	      IE1 = (IT-1)*ITRSZ+IZ
 	      IA = IE1-1
	      IF (E(IE1)+DT*A(IA) .LT. E(IE)) THEN
	          E(IE) = E(IE1)+DT*A(IA)
	      ENDIF
100	  CONTINUE
      ENDIF
 
      IF (PATHTYPE(4).EQ.1) THEN
	  DO 101 IT=NT-1,0,-1
	      IE = IT*ITRSZ+IZ
	      IE1 = (IT+1)*ITRSZ+IZ
	      IA = IE-1
	      IF (E(IE1)+DT*A(IA) .LT.E(IE)) THEN
		  E(IE) = E(IE1)+DT*A(IA)
	      ENDIF
101	  CONTINUE
      ENDIF
 
C      print*,"DPZTFOR- IFLAG=",IFLAG
      DO 102 IZ=2,NZ+1
	CALL DPZT(A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,1,IZ,IFLAG)
102   CONTINUE
 
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DPZTRE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DPZTREV  (A,EREV,XVECT,YVECT,NZ,NT,NR,PATHTYPE)                 *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      EREV    REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      XVECT   REAL     ??IOU*                     -                   *
C      YVECT   REAL     ??IOU*                     -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      PATHTY  INTEGER  ??IOU*  (4)                -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      DPZT -                                                          *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE DPZTREV(A,EREV,XVECT,YVECT,NZ,NT,NR,PATHTYPE)
      INTEGER NT,NZ,NR
      REAL A((NT+1)*(NZ+1)*NR)
      REAL EREV((NT+1)*(NZ+1)*NR)
      REAL XVECT,YVECT
      INTEGER PATHTYPE(4)
 
      INTEGER IT,IZ,IE,IE1,IA
 
#include "apkr.h"
 
      WRITE(IPRT,*)'DPZTREV'
 
      IZ = NZ
      IF(PATHTYPE(1).EQ.1) THEN
          DO 100 IT=1,NT
              IE = IT*ITRSZ+IZ
              IE1 = (IT-1)*ITRSZ+IZ
              IA = IE1-1
              IF (EREV(IE1)+DT*A(IA) .LT. EREV(IE)) THEN
                  EREV(IE) = EREV(IE1)+DT*A(IA)
              ENDIF
100       CONTINUE
      ENDIF
 
      IF (PATHTYPE(4).EQ.1) THEN
          DO 101 IT=NT-1,0,-1
              IE = IT*ITRSZ+IZ
              IE1 = (IT+1)*ITRSZ+IZ
              IA = IE-1
              IF (EREV(IE1)+DT*A(IA) .LT.EREV(IE)) THEN
                  EREV(IE) = EREV(IE1)+DT*A(IA)
              ENDIF
101       CONTINUE
      ENDIF
 
      DO 102 IZ=NZ,1,-1
          CALL DPZT(A,EREV,XVECT,YVECT,NZ,NT,NR,PATHTYPE,-1,IZ,0)
102   CONTINUE
 
      RETURN
      END
 
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DPZT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DPZT  (A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,DIR,IZ,IFLAG)          *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      XVECT   REAL     ??IOU*                     -                   *
C      YVECT   REAL     ??IOU*                     -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      PATHTY  INTEGER  ??IOU*  (4)                -                   *
C      DIR     INTEGER  ??IOU*                     -                   *
C      IZ      INTEGER  ??IOU*                     -                   *
C      IFLAG   INTEGER  ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      GUIDE   NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/12/17 ==================   *
C      DPZT  (A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,DIR,IZ)                *
C  =============================== DATE: 91/12/18 ==================   *
C      DPZT  (A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,DIR,IZ,IFLAG)          *
C  =============================== DATE: 91/12/18 ==================   *
C      DPZT  REAL  (A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,DIR,IZ,IFLAG)    *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE DPZT(A,E,XVECT,YVECT,NZ,NT,NR,PATHTYPE,DIR,IZ,IFLAG)
      REAL A((NT+1)*(NZ+1)*NR)
      REAL E((NT+1)*(NZ+1)*NR)
      REAL XVECT,YVECT
      INTEGER NT,NZ,NR,PATHTYPE(4),DIR,IZ,IFLAG
 
      REAL AA,E0,E1,E2,SINPHI,COSPHI,ETEMP,T0,Z0
      REAL DTGUID,T,DTR,DTR2,DTRINV
      INTEGER IT,K,IA,IE,IE1,IG
 
#include "apkr.h"
#include "dpzt.h"
 
      SMALLNUM = 0
      K=0
      IG=IGUIDE(IZ)
      IF (DIR.EQ.-1)K=1
 
C      print*,"DPZT - IFLAG=",IFLAG
 
C     --------make trace spacing a function of sample number-------
      DTR = DT*((1.0*IZ)**TREXP)
      DTR2 = DTR*DTR
      DTRINV = 1.0/DTR
 
      IF(DIR.GE.0)THEN
          DTGUID =  DTGUIDE(IG)*DTR/DT
      ELSE
          DTGUID = -DTGUIDE(IG)*DTR/DT
      ENDIF
 
      DGLA = SQRT((DTR-DTGUID)*(DTR-DTGUID)+DZ2)
      DGLB = SQRT(DTGUID*DTGUID+DZ2)
      DGLC = SQRT((DTR+DTGUID)*(DTR+DTGUID)+DZ2)
      SINA = (DTR-DTGUID)/DGLA
      SINB = -DTGUID/DGLB
      SINC = -(DTR+DTGUID)/DGLC
      COSA = DZ/DGLA
      COSB = DZ/DGLB
      COSC = DZ/DGLC
 
 
      DO 100 IT=2,NT+1
          IE = (IT-1)*ITRSZ+IZ
	  IE1 = (IT-2)*ITRSZ+IZ
	  IA = IE1+K-1
 
CDIR$ IVDEP
	  DO 200 IR=1,NR
	      AA = A(IA)
 
C             -----handle discontinuities-------------
              IF(IFLAG.EQ.0)THEN
              AANEXT = A(IA+1)
              IF((AANEXT.LT.0).AND.
     &            (AA.GT.0))THEN
                ETEMP = E(IE1-DIR)+AA*DTR
                IF(ETEMP.LE.E(IE-1).AND.ETEMP.GT.0)E(IE-1)=ETEMP
              ENDIF
              ENDIF
 
C	      ---------------------------------------------------------
C			PATHTYPE 1         0 <= COSPHI <= COSA
C	      ---------------------------------------------------------
 
	      IF ((A(IA+1).LT.0.OR.A(IA+1).GT.BIGNUM.OR.
     &              PATHTYPE(1).EQ.1 ).AND. AA.GT.SMALLNUM) THEN
		  E1 = E(IE1-DIR)
		  E2 = E(IE1)
		  COSPHI = (E2-E1)/(AA*DZ)
 
		  IF (COSPHI.GE.COSA) THEN
		      Z0 = -DZ
		      T0 = -DTR + DTGUID
		      ETEMP = E1+AA*DGLA
		  ELSE IF (COSPHI.LE.0) THEN
		      Z0 = 0
		      T0 = -DTR + DTGUID
		      ETEMP = E2+AA*DTR
		  ELSE
		      T0 = -DTR
		      Z0 = -DTR*COSPHI/SQRT(1.0-COSPHI*COSPHI)
		      E0 =  (-E1*Z0+E2*(DZ+Z0))*DZINV
		      ETEMP = E0+AA*SQRT(T0*T0+Z0*Z0)
 
		  ENDIF
 
C             ------UPDATE E IF ETEMP IS LESS--------------
		  IF (ETEMP.LT.E(IE)) THEN
		      E(IE)=ETEMP
C		      XVECT(IE) = T0
C		      YVECT(IE) = DIR*Z0
		  ENDIF
 
	      ENDIF
 
C	      ---------------------------------------------------------
C			PATHTYPE 2         SINA >= SINPHI >= SINB
C	      ---------------------------------------------------------
 
	      IF (PATHTYPE(2).EQ.1 .AND. AA.GT.SMALLNUM) THEN
                  E1 = E(IE1-DIR)
		  E2 = E(IE-DIR)
		  SINPHI = (E2-E1)/(AA*DTR)
 
		  IF (SINPHI.LE.SINB) THEN
C		      Z0 = -DZ
C		      T0 = DTGUID
		      ETEMP = E2+AA*DGLB
		  ELSE IF(SINPHI.GE.SINA) THEN
C		      Z0 = -DZ
C		      T0 = -DTR + DTGUID
		      ETEMP = E1+AA*DGLA
		  ELSE
		      T = -DZ*SINPHI/SQRT(1.0-SINPHI*SINPHI)
                      T0 = T -DTGUID
C		      Z0 = -DZ
		      E0 = (-E1*T0+E2*(DTR+T0))*DTRINV
		      ETEMP = E0+AA*SQRT(T*T+DZ2)
		  ENDIF
 
C             ------UPDATE E IF ETEMP IS LESS--------------
		  IF (ETEMP.LT.E(IE)) THEN
		      E(IE)=ETEMP
C		      XVECT(IE) = T0
C		      YVECT(IE) = DIR*Z0
		  ENDIF
 
	      ENDIF
	      IE = IE+IRECSZ
	      IE1 = IE1+IRECSZ
	      IA = IA+IRECSZ
 
200	  CONTINUE
100   CONTINUE
 
 
 
 
      DO 110 IT=NT,1,-1
          IE = (IT-1)*ITRSZ+IZ
	  IE1 = IT*ITRSZ+IZ
	  IA = IE+K-1
 
CDIR$ IVDEP
	  DO 210 IR=1,NR
	      AA = A(IA)
 
C             -----handle discontinuities-------------
              IF(IFLAG.EQ.0)THEN
              AANEXT = A(IA+1)
              IF((AANEXT.LT.0).AND.
     &            (AA.GT.0))THEN
                ETEMP = E(IE1-DIR)+AA*DTR
                IF(ETEMP.LE.E(IE-1).AND.ETEMP.GT.0)E(IE-1)=ETEMP
              ENDIF
              ENDIF
 
 
C	      ---------------------------------------------------------
C			PATHTYPE 3          SINB >= SINPHI >= SINC
C	      ---------------------------------------------------------
 
	      IF (PATHTYPE(3).EQ.1 .AND. AA.GT.SMALLNUM) THEN
                  E1 = E(IE1-DIR)
		  E2 = E(IE-DIR)
		  SINPHI = (E1-E2)/(AA*DTR)
 
		  IF (SINPHI.GE.SINB) THEN
C		      Z0 = -DZ
C		      T0 = 0 + DTGUID
		      ETEMP = E2 + AA*DGLB
		  ELSE IF (SINPHI.LE.SINC) THEN
C		      Z0 = -DZ
C		      T0 = DTR + DTGUID
		      ETEMP = E1+AA*DGLC
		  ELSE
		      T = -DZ*SINPHI/SQRT(1.0-SINPHI*SINPHI)
                      T0 = T - DTGUID
C		      Z0 = -DZ
		      E0 = (E1*T0+E2*(DTR-T0))*DTRINV
		      ETEMP = E0 + AA*SQRT(T*T+DZ2)
		  ENDIF
 
C             ------UPDATE E IF ETEMP IS LESS--------------
		  IF (ETEMP.LT.E(IE)) THEN
		      E(IE)=ETEMP
C		      XVECT(IE) = T0
C		      YVECT(IE) = DIR*Z0
		  ENDIF
	      ENDIF
 
C	      ---------------------------------------------------------
C			PATHTYPE 4         0 <= COSPHI <= COSC
C	      ---------------------------------------------------------
 
	      IF ((A(IA+1).LT.0.OR.A(IA+1).GT.BIGNUM.OR.
     &              PATHTYPE(4).EQ.1) .AND. AA.GT.SMALLNUM) THEN
                  E1 = E(IE1-DIR)
		  E2 = E(IE1)
		  COSPHI = (E2-E1)/(AA*DZ)
 
		  IF (COSPHI.LE.0) THEN
		      Z0 = 0
		      T0 = DTR
		      ETEMP = E2+AA*DTR
		  ELSE IF (COSPHI.GE.COSC) THEN
		      Z0 = -DZ
		      T0 = DTR + DTGUID
		      ETEMP = E1+AA*DGLC
		  ELSE
		      T0 = DTR + DTGUID
		      Z0 = -DTR*COSPHI/SQRT(1.0-COSPHI*COSPHI)
		      E0 = (-E1*Z0+E2*(DZ+Z0))*DZINV
		      ETEMP = E0+AA*SQRT(T0*T0+Z0*Z0)
		  ENDIF
 
 
C             ------UPDATE E IF ETEMP IS LESS--------------
		  IF (ETEMP.LT.E(IE)) THEN
		      E(IE)=ETEMP
C		      XVECT(IE) = T0
C		      YVECT(IE) = DIR*Z0
		  ENDIF
 
	      ENDIF
 
	      IE = IE+IRECSZ
	      IE1 = IE1+IRECSZ
	      IA = IA+IRECSZ
 
210	  CONTINUE
110   CONTINUE
 
      RETURN
      END
