C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ZBOXCA                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ZBOXCAR  (AAVG,NR,NZ,NSMOOTH)                                   *
C  ARGUMENTS:                                                          *
C***********************************************************************
      SUBROUTINE ZBOXCAR(AAVG,NR,NZ,NSMOOTH)
      REAL AAVG(NR*(NZ+1))
      INTEGER NR,NZ,NSMOOTH
 
      REAL ANEW(4096)
      INTEGER IA,IZ,IR
 
#include "apkr.h"
 
      NS = NSMOOTH/2
 
 
      DO 100 IR = 1,NR
          SUM = 0
          NSUM = 0
          IEND = NS
          IF(NZ.LT.NS)  IEND = NZ
 
C         +----------------------------------+
C         | determine filter for first trace |
C         +----------------------------------+
          DO 200 IZ = 1,IEND
              IA = (IR-1)*ITRSZ + IZ
              SUM = SUM + AAVG(IA)
              NSUM = NSUM + 1
200       CONTINUE
 
          DO 300 IZ = 1,NZ
C             +--------------------------+
C             | add leading point to sum |
C             +--------------------------+
              IF(IZ+NS.LE.NZ)THEN
                  IAFOR = (IR -1)*ITRSZ +IZ+NS
                  IEND = IZ + NS
                  NSUM = NSUM + 1
                  SUM = SUM + AAVG(IAFOR)
              ENDIF
C             +--------------------------------+
C             | remove trailing point from sum |
C             +--------------------------------+
              IF(IZ-NS.GT.1)THEN
                  IABACK = (IR - 1)*ITRSZ + IZ-NS-1
                  IBEG = IZ-NS
                  NSUM = NSUM -1
                  SUM = SUM - AAVG(IABACK)
              ENDIF
              IF(NSUM.NE.0)ANEW(IZ)=SUM/NSUM
300       CONTINUE
 
          DO 400 IZ = 1,NZ
              IA = (IR-1)*ITRSZ + IZ
              AAVG(IA)=ANEW(IZ)
400       CONTINUE
 
100   CONTINUE
 
 
      RETURN
      END
