C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SUBS                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SUBS  (NTR,NSAMP,ARRAY1,ARRAY2,ARRAY3)                          *
C  ARGUMENTS:                                                          *
C      NTR     INTEGER  ??IOU*              -                          *
C      NSAMP   INTEGER  ??IOU*              -                          *
C      ARRAY1  REAL     ??IOU*  (NSAMP,NTR) -                          *
C      ARRAY2  REAL     ??IOU*  (NSAMP,NTR) -                          *
C      ARRAY3  REAL     ??IOU*  (NSAMP,NTR) -                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      HILBER -                                                        *
C      VMMA   -                                                        *
C      VSQRT  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c  dummy subroutine - does precisely nothing
 
c  but it is an example of rearranging a vector in main
c  into a matrix
 
      subroutine subs (ntr, nsamp, array1, array2, 
     1                 resid, nrec, irec,
     1                 rec, trac, samp, npts, no_seg, 
     1                 rec2, trac2, samp2, npt2, noseg2, 
     1                 jzm, dist, nzmin, nzmax, ngamma, dgamma, 
     1                 dz, jfnz, pick, offset)
 
      parameter (defalt = -999.)
      real      array1(nsamp, ntr)
      real      array2(nsamp, ntr)
      real      resid(nsamp, nrec)
      real      rec(*), trac(*), samp(*)
      integer   npts(no_seg)
      real      rec2(*), trac2(*), samp2(*)
      real      offset(3)
      integer   npt2(noseg2)
      integer   jzm(nsamp, ngamma, ntr)
      real      dist(ntr)
      integer   jfnz(ntr,nrec)
      integer   nzmin(ntr),nzmax(ntr)
      real      dgamma, dz
      logical   first, pick
      data      first /.true./
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c---------------

      if (first) then
 
          first = .false.

c table the look-ups
          do joff=1,ntr
             do igam=1,ngamma
                gamma = 1.+(igam-ngamma/2-1)*dgamma
                nzmin(joff) = 1
                do jz = 1,nsamp
                  arg = (jz*dz)**2+(gamma**2-1)*dist(joff)**2
		  if(arg.ge.0.) then
	            jzm(jz,igam,joff) = nint(sqrt(arg)/dz)
		  else
		    jzm(jz,igam,joff) = nsamp
		  endif
		  if (jzm(jz,igam,joff) .lt. 1) nzmin(joff) = jz+1
	        enddo
	        nzmax(joff)=nsamp
	        do jz = nsamp,1,-1
	         if(jzm(jz,igam,joff) .gt. nsamp) nzmax(joff) = jz-1
                enddo
             enddo
          enddo

        do i=1,nrec
           do j=1,nsamp
              resid(j,i)=defalt
           enddo
           resid(1,i)=ngamma/2+1
           resid(nsamp,i)=ngamma/2+1
        enddo

        inpick=0
        do i=1,no_seg

           do j=1,npts(i)
              inpick=inpick+1
              inpck2=0
              do i2=1,i-1
                 inpck2=inpck2+npt2(i2)
              enddo
              do j2=1,npt2(i)
                 inpck2=inpck2+1
                 if(nint(trac(inpick)).eq.nint(trac2(inpck2)))then

                     isamp=nint(samp(inpick))
                     jgam=nint(samp2(inpck2))
                     if(jgam.lt.1.or.jgam.gt.ngamma)jgam=ngamma/2+1
                     if(isamp.lt.1.or.isamp.gt.nsamp)isamp=nsamp
                     resid(isamp,nint(trac(inpick)))=jgam

                 endif
             enddo
          enddo
       enddo

        do i=1,nrec
              call intrp ( resid(1,i), nsamp, defalt )
        enddo

        do i=1,nrec
           do j=1,nsamp
              if(resid(j,i).eq.defalt)resid(j,i)=ngamma/2+1
           enddo
        enddo

        if(pick)then
           do j = 1, nrec
              do i=1,ntr
                    jfnz(i,j)=1
              enddo
           enddo
        endif

      endif
 
      if(.not.pick)then
      do i=1,ntr
 
c  find first non-zero sample
                  do jz = 1, nsamp
                    if (array1(jz,i) .ne. 0) goto 543
                  enddo
  543             jfnz(i,irec)=jz
c  apply gamma moveout
                  call vclr(array2(1,i),1,nsamp)
		  do jz = nzmin(i),nzmax(i)
                        igam=resid(jz,irec)
			array2(jz,i)=array1(jzm(jz,igam,i),i)
                  enddo
      enddo
      endif

      return
      end
 
      subroutine fndsmp(jzm,nsamp,ngamma,jtr,isamp,jgam,kk,iosamp)
      integer jzm(nsamp,ngamma,jtr)

      if(jgam.lt.1.or.jgam.gt.ngamma)then
         jgam2=ngamma/2+1
      else
         jgam2=jgam
      endif

      if(isamp.lt.1.or.isamp.gt.nsamp)then
         isamp2=nsamp
      else
         isamp2=isamp
      endif

      iosamp = jzm(isamp2,jgam2,kk)

      return
      end
