C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C NAME: SWRPCK    WRITE PICKS                          REV 2.0  DEC 92 *
C***********************************************************************
C                                                                      *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Write an 'xsd' pick file which consists of a 'Units' card      *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 92/02/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/07/23  *
C  REVISED:  Mary Ann Thornton  October 5, l992
C            changed a format statment to read new xsd formatted picks
C            This version does not write the name of the segments or
C            the number of picks per segment.
C  REVISED:  Mary Ann Thornton  December l6, 1992
C            Rewrite the subroutine to write the new improved xsd     
C            formatted picks with the number of segments and maximum
C            number of picks on the Units card
C            and the names of the segments
C            To use this subroutine, the picks must have been read in
C            with subroutine rdpick.F (from this same library)
C  CALLING FORMAT:                                                     *
C       call swrpck(rec,trac,samp,color,name,npicks,units,offset,      *
C    &              nrec,ntrac,nsamp,jseg,maxpik,lprt,lpout,           *
C    &              sego,jerr)                                   *
C                                                                      *
C  PARAMETERS:                                                         *
C    rec       Input real one-dimensional array of x points            *
C                                                                      *
C    trac      Input real one-dimensional array of y points            *
C                                                                      *
C    samp      Input real one-dimensional array of z points            *
C                                                                      *
C    color     Integer array of segment colors                         *
C                                                                      *
C    name      Input Character*20 array length 1000 containing         *
C              segment names                                           *
C                                                                      *
C    npicks    Integer input array of length 1000                      *
C               npicks(1) = the number of points in segment one        *
C               npicks(2) = the number of points in segment two, etc.  *
C                                                                      *
C    units     Real input array of length 3                            *
C              units(1) = Units measure for the x points               *
C              units(2) = Units measure for the y points               *
C              units(3) = Units measure for the z points               *
C                                                                      *
C    offset    Real input array of length 3                            *
C              offset(1) = offset measure for the x points             *
C              offset(2) = offset measure for the y points             *
C              offset(3) = offset measure for the z points             *
C                                                                      *
C    nrec      Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    ntrac     Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    nsamp     Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    jseg      Integer input scalar                                    *
C              Number of segments in the picks file                    *
C                                                                      *
C    maxpik    Integer output scalar                                   *
C              Maximum number of picks in any one segment              *
C                                                                      *
C    lprt      Integer input scalar                                    *
C              Logical unit of print out                               *
C                                                                      *
C    lpout     Integer input scalar                                    *
C              Logical unit of pick file                               *
C                                                                      *
C    jerr      Integer input/output scalar                             *
C              Error flag                                              *
C                                                                      *
C  DESCRIPTION:  This routine writes an 'xsd' pick file given          *
C      arrays containing the x, y, and z points and color for          *
C      each segment.                                                   *
C                                                                      *
C  SUBPROGRAMS CALLED:  None                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr =250  =   Error writing picks file                         *
C                                                                      *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine swrpck(rec,trac,samp,color,name,npicks,units,offset,
     &                  nrec,ntrac,nsamp,jseg,maxpik,lprt,lpout,
     &                  sego,nout,jerr)
C
      integer npicks(*),color(*)
      character*20 name(*)
      real rec(*),trac(*),samp(*)
      real units(*),offset(*)
      real sego(*)
      character*6 uword
      character*7 oword
      character*6 cword
      data uword/'Units '/
      data oword/'Offset '/
      data cword/'Count '/
 
      nseg = 0
      knt=0
      do j=1,jseg
        k=nint(sego(knt+1))
        if (k .ge. 1 .and. k .le. jseg .and. npicks(k) .ge. 0) then
           knt=knt+npicks(k)
           nseg = nseg + 1
        else
           npicks(k) = 0
        endif
      enddo


      jerr = 0
   50 format(a6,3(f12.6,1x),3(i5,1x),a7,3(f12.6,1x),a6,i5,1x,i5)
      write(lpout,50,err=350)uword,units(1),units(2),units(3),
     &nrec,ntrac,nsamp,oword,offset(1),offset(2),offset(3),cword,
     &nseg,maxpik
  100 format(2(f12.6,1x)f12.6)

      knt=0
      do 300 j=1,jseg
       k=nint(sego(knt+1))
       if (npicks(k) .ne. 0) then
         write(lpout,60,err=350)k,name(k),color(k),npicks(k)
   60    format('Segment = ',i5,' Name ',a20,'  color = ',i5,
     &          ' picks = ',i5)
         do 250 n=1,npicks(k)
            knt = knt + 1
            if(samp(knt).ge.1.and.samp(knt).le.nsamp)then   
               write(lpout,100,err=350)rec(knt),trac(knt),
     &                              samp(knt)
            endif
  250    continue
       endif
  300 continue
      return
  350 write(lprt,*)' Error encountered writing picks file'
      jerr = 250
      return
      end
