C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  find weights of 4 corner points that apply to some point inside a
c  rectangle.  Use the diagonally opposed area of the rectangle for
c  the weight of each corner

      subroutine WghtArea (xin,yin,dx,dy,wght1,wght2,wght3,wght4)

      real xin,yin,dx,dy,wght1,wght2,wght3,wght4
      real c1x,c1y,c2x,c2y,c3x,c3y,c4x,c4y
      real area1, area2,area3,area4,areasum

c
c
c     c3--------------c4
c      | area 2  |area|
c      |         | 1  |
c      |-------- * ---| <-- yin
c      | area 4  |area|
c      |         | 3  |
c     c1--------------c2
c                |
c               xin
c
      c1x = dx* int(xin/dx)
      c1y = dy* int(yin/dy)

      c2x = c1x + dx
      c2y = c1y

      c3x = c1x
      c3y = c1y + dy

      c4x = c2x
      c4y = c3y

      area1 = abs( (xin-c4x) * (yin-c4y) )
      area2 = abs( (xin-c3x) * (yin-c3y) )
      area3 = abs( (xin-c2x) * (yin-c2y) )
      area4 = abs( (xin-c1x) * (yin-c1y) )

      areasum = dx * dy

      wght1 = area1/areasum
      wght2 = area2/areasum
      wght3 = area3/areasum
      wght4 = area4/areasum

      return
      end
