C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
      subroutine cmdln(ntap,otap,ptap,ilts,xlts,CdpInt,verbos,wght)

c     ntap - C*255  input file name
c     otap - C*255  output file name
c     ptap - C*255  xsd pickfile name [optional]
c     ilts - R*4 spacing between inline traces (btwn traces w/in a record)
c     xlts - R*4 spacing between xline  traces (between input records)
c     cdpint - R*4 cdp spacing on output traverse line

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      real ilts, xlts, cdpint

      character  ntap*(*), otap*(*), ptap*(*), wght*(*)

      logical verbos

c parse command line
c      wght = 'linear'
      wght = 'cosine'

      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )
      call argstr ('-P', ptap, ' ', ' ' )

      call argr4( '-cdpint', cdpint, 25.0, 25.0)

      call argr4( '-ilts', ilts, 25.0, 25.0 )
      call argr4( '-xlts', xlts, 25.0, 25.0 )

      verbos = (argis('-V') .gt. 0)

c Policemen

      if ( ptap .eq. ' ' ) then
         write(LERR,*)' '
         write(LERR,*)' No traverse control entered.  Must supply '
         write(LERR,*)' turning points for line to be extracted '
         write(LERR,*)' from the input volume in the form of '
         write(LERR,*)' an XSD pickfile. '
         write(LERR,*)'FATAL '
         write(LER,*)' '
         write(LER,*)' AT3D_LITE: '
         write(LER,*)'       No traverse control entered.  Must supply'
         write(LER,*)'       turning points for line to be extracted '
         write(LER,*)'       from the input volume in the form of  '
         write(LER,*)'       an XSD pickfile. '
         write(LER,*)' FATAL '
         goto 999
      endif

      if( ilts .le. 0.0 .or. xlts .le. 0.0 ) then
         write(LERR,*)' '
         write(LERR,*)' both -ilts and -xlts entries must be '
         write(LERR,*)' greater than zero.  You have input'
         write(LERR,*)' -ilts = ',ilts,' -xlts = ',xlts
         write(LERR,*)' please correct this problem and resubmit'
         write(LERR,*)' FATAL'
         write(LER,*)' '
         write(LER,*)' '
         write(LER,*)' AT3D_LITE: '
         write(LER,*)'       both -ilts and -xlts entries must be '
         write(LER,*)'       greater than zero.  You have input'
         write(LER,*)'       -ilts = ',ilts,' -xlts = ',xlts
         write(LER,*)'       please fix this problem and resubmit'
         write(LER,*)' FATAL'
         write(LER,*)' '
         goto 999
      endif

      return

 999  continue
      
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' AT3D_LITE: Abnormal Termination'
      stop

      end
