C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln(ntap,otap,vtap,dxi,tdfn,flat,fmin,fmax,
     1                  zmax,nray,nray1,dipfil,dipmax,dipmin,deta,
     2                  f1,f2,f3,f4,isis,scalez,scalet,scalev,itaper)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vtap  - C*100    velocity file name
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), vtap*(*)
      real        dxi,zmax,f1,f2,f3,f4,scalez,scalet,dipmax,dipfil
      real        deta,fmin,fmax,scalev,dipmin
      integer     nray,nray1,isis,itaper
      logical     verbos, tdfn, flat
      integer     argis

c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.

c     For example program prgm might be invoked in the following way:

c     prgm  -Nxyz -Oabc

c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"

c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-v', vtap, ' ', ' ' )
            call argr4 ( '-dxi', dxi, 0., 0.)
            call argr4 ( '-zmax', zmax, 35000., 35000.)
            call argr4 ( '-dpf', dipfil, 1., 1.)
            call argr4 ( '-dpm', dipmax, 169., 169.)
            call argr4 ( '-dpn', dipmin, 90., 90.)
            call argr4 ( '-f1', f1, 2., 2.)
            call argr4 ( '-f2', f2, 4., 4.)
            call argr4 ( '-f3', f3, 20., 20.)
            call argr4 ( '-f4', f4, 28., 28.)
            call argr4 ( '-sz', scalez, 0., 0.)
            call argr4 ( '-st', scalet, 0., 0.)
            call argr4 ( '-sv', scalev, 1., 1.)
            call argi4 ( '-nray', nray, 720, 720)
            call argi4 ( '-ot', itaper, 5, 5)
            nray1 = nray + 1
            deta  = 0.

            fmin = .5 * (f1 + f2)
            fmax = .5 * (f3 + f4)

            if (dxi .eq. 0.) then
               write(LERR,*)'Must supply input trace spacing -- FATAL'
               write(LERR,*)'Use -dxi[] command line entry'
               stop
            endif

            isis   =   1
            if (argis('-D') .gt. 0) isis = 0
            tdfn   =   (argis('-T') .gt. 0)
            flat =   (argis('-F') .gt. 0)
            verbos =   (argis('-V') .gt. 0)

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't

      return
      end

