C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine migint (dipfil,fmin,fmax,scale,dxi,zett,f1,f2,f3,f4,
     1                 nz,nvelup,nray1,nzeta,vup,vzup,zup,zscale,dpmax,
     2                 ppmax,zmax,dip,zdip,p,np,jvelup,fmaxy)

#include <f77/iounit.h>

      real     p(0:nray1)
      real     vup(0:4000), zup(0:4000)
      real     zscale(0:nzeta), vzup(0:nzeta), zett(0:nzeta)
      real     dpmax(0:nzeta), dip(0:50), zdip(0:50)
      real     dipfil,fmin,fmax,scale,dxi
      integer  nzeta


      PI = 3.141592
      DPFIL = DIPFIL
      FMAXX = FMAX
      CZERO = VUP(0)
      PMAX = VUP(0)/(DPFIL*FMAX*DXI)
      PMAX = AMIN1(PMAX,.9999)
      THETA = ASIN(PMAX)
cjmw     PRINT*,'PMAX = ',PMAX
      PCRITX = PMAX
      PCRITY = 0.
CWAVENUMBER FILTER START
      PPMAX = VUP(0)/(4.*FMAX*DXI)
      PPMAX = AMIN1(PPMAX,.9999)

      SINMX = 0.
      DO 25 JDIP = 0,50
        SINMX = AMAX1(SINMX,SIN(PI*DIP(JDIP)/180.))
        IF (DIP(JDIP) .GT. 90.) SINMX = .9999
25    CONTINUE
      PMAX = AMIN1(PMAX,SINMX)
      IF (PPMAX/PMAX .LT. .99) THEN
        DPFL = DPFIL*PMAX/PPMAX
        write(LERR,*)' '
        write(LERR,*)'WARNING: TO AVOID MIGRATING ALIASED FREQUENCIES ',
     1         'F3, F4 SHOULD BE REDUCED TO ',
     2          F3*PPMAX/PMAX,F4*PPMAX/PMAX
        write(LERR,*)' '
        fmaxy = 0.5 * (F3*PPMAX/PMAX + F4*PPMAX/PMAX)
        write(LERR,*)'I will filter the data with the corner freqs'
        write(LERR,*)fmin,' & ',fmaxy
        write(LERR,*)'to minimize aiasing. Also...'
        write(LERR,*)' '
        write(LERR,*)'          WHEN IMAGING THE STEEPEST DIPS.'
        write(LERR,*)'TO PRESERVE ALL FREQUENCIES DIPFIL MUST EXCEED ',
     1                DPFL
        write(LERR,*)' '
      END IF

CWAVENUMBER FILTER END

C
C     ARRAY OF MIGRATION DEPTHS, VELOCITIES, AND RAY PARAMETERS
C     (ONE RAY PARAMETER FOR EACH DEPTH AT WHICH VELOCITY EXCEEDS
C     ALL VELOCITIES AT LESSER DEPTHS).
C
      NP = 0
      JZETA = 0
      JP = 0
      ZETA = 0.
      ZSCALE(JZETA) = 0.
      ZETT(0) = ZETA
      VZUP(0) = VUP(0)
      VZMAX = VUP(0)
      DZETA = VUP(0)/(4.*(FMIN+FMAXX))
      JVEL = 0
      JUP = 0
      JDIP = 0
CC    JPCRTX = NZETA
CC    JPCRTY = NZETA
C     PRINT*,'JZETA, ZETA, VZETA'
c          write(LER,*)'migint0: ',ZETA,ZMAX,ZUP(NVELUP),VZMAX,DZETA,
c    1NVELUP
CCCCCCDO WHILE (ZETA .LT. ZMAX)
C9919 IF(.NOT.(ZETA .LT. ZMAX)) GOTO 9921
CCCCCCDO WHILE ((ZETA .LT. ZMAX) .AND. (ZETA .LT. ZUP(NVELUP-1))
 9919 IF(.NOT.((ZETA .LT. ZMAX).AND.(ZETA .LT. ZUP(NVELUP-1))))GOTO 9921
        JZETA = JZETA+1
        ZETA = ZETA+DZETA
        ZSCALE(JZETA) = ZETA**SCALEZ
        ZETT(JZETA) = ZETA
c         write(LER,*)'migint1: ',JZETA,ZETA,ZSCALE(JZETA),ZETT(JZETA)
C
C       EXTRAPOLATE OR INTERPOLATE LINEARLY TO FIND
C       VELOCITY BETWEEN TWO SPECIFIED POINTS
C
        DO 29 JZ = 0,NVELUP
c           write(0,*)'migint2: ',JZ,ZUP(JZ)
          IF (ZETA .GT. ZUP(JZ)) JVELUP = JZ
29      CONTINUE
        IF (JVELUP .EQ. NVELUP) THEN
          SLOPE = (VUP(JVELUP)-VUP(JVELUP-1))/
     1            (ZUP(JVELUP)-ZUP(JVELUP-1))
          IF (ABS(SLOPE) .LT. .001) SLOPE = .001
        ELSE
cjmw        print*,'migint3b: ',ZUP(JVELUP+1),ZUP(JVELUP)
          SLOPE = (VUP(JVELUP+1)-VUP(JVELUP))/
     1            (ZUP(JVELUP+1)-ZUP(JVELUP))
          IF (ABS(SLOPE) .LT. .001) SLOPE = .001
        END IF
        VZUP(JZETA) = VUP(JVELUP)+SLOPE*(ZETA-ZUP(JVELUP))
cjmw        PRINT*, JZETA, ZETA, VZUP(JZETA)

C
C       EXTRAPOLATE OR INTERPOLATE LINEARLY TO FIND
C       MAXIMUM DIP BETWEEN TWO SPECIFIED DEPTHS
C

        IF (ZETA .GT. ZDIP(JDIP+1)) JDIP = JDIP+1
        DPMAX(JZETA) = DIP(JDIP)+(ZETA-ZDIP(JDIP))*
     1               (DIP(JDIP+1)-DIP(JDIP))/(ZDIP(JDIP+1)-ZDIP(JDIP))
        DPMAX(JZETA) = DPMAX(JZETA)*3.14159/180.

        DZETA = VZUP(JZETA)/(4.*(FMIN+FMAXX))
        IF (VZUP(JZETA) .GT. VZMAX+1.) THEN
          VZMAX = VZUP(JZETA)
          IF (VUP(0)/VZUP(JZETA) .LT. PMAX) THEN
            JP = JP+1
            P(JP) = VUP(0)/VZUP(JZETA)
          END IF
        END IF
CCCCCCREPEAT
 9920 GOTO 9919
 9921 CONTINUE
      NZ = JZETA

      if (nz .eq. 0) then
c        write(LERR,*)'HEART ATTACK in BORNUSP: number depths is zero'
         write(LERR,*)'HEART ATTACK in GAZDAG: number depths is zero'
         write(LERR,*)'Check velocity function or velocity file type'
         stop
      endif

cjmw      PRINT*,'NZ = ',NZ
C     NP = JP

C
C     RAY PARAMETERS SO FAR DEFINED
C     ARE THOSE FOR TURNED RAYS AT EACH MIGRATION DEPTH.
C     COMPLETE THE ARRAY BY INCLUDING 20 EXTRA RAY PARAMETERS
C     NEAR THE VERTICAL.
C
      IF (JP .EQ. 0) THEN
        JP = 1
        P(1) = PMAX
      END IF
      DO 80 JPP = 1,19
        P(JP+JPP) = (1.-.05*JPP)*P(JP)
80    CONTINUE
      P(JP+20) = .00001
      NP = JP+20

      JPCRTX = NP
      JPCRTY = NP
      DO 90 JP = 1,NP
        IF (P(JP) .LT. PCRITX) JPCRTX = MIN(JPCRTX,JP)
        IF (P(JP) .LT. PCRITY) JPCRTY = MIN(JPCRTY,JP)
90    CONTINUE

      IF (NZ .GT. NZETA) THEN
        write(LERR,*)'********'
        write(LERR,*)'STOPPING: # OF DEPTHS > ',NZETA
        write(LERR,*)'********'
        STOP
      END IF


        WRITE(LERR,*)'After 90 NZ,NP: ',NZ,NP

      return
      end
