C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine migit (NXI,NZ,NRAY1,NT,NT1,NTMAX,LNGTH,LNGTH4,nsi,ntrc,
     1                  dipmax,sinmax,ppmax,sqrf,trigs1,trigs2,trigs3,
     2                  trigs4,uc,p,wrk1,wrk2,coefs,xnorm,norder,initf,
     3                  beta,nzeta,iheadr,udata,zscale,ur1,ui1,
     4                  zett,jwave,jwmin,jwmax,jtim,rcritx,luin,
     5                  dx,nsamp,itr,tscale, nmax, taper,JR,ntmx,
     6                  ITRWRD, SZSMPD)

c#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer      ITRWRD, SZSMPD
      complex      uc(*)
      integer      itr(*), iheadr(ntrc,ITRWRD)
      real         tscale(0:nmax), coefs(2,32), wrk1(3), wrk2(96)
      real         sqrf(*),udata(*)
      real         taper(*)
      real         p(0:nray1)
      integer      jwave(0:nxi)
      real         trigs1(*), trigs2(*), trigs3(*), trigs4(*)
      real         zett(0:nzeta),rcritx(0:nzeta),zscale(0:nzeta)
      integer      jwmin(3,0:nzeta),jwmax(3,0:nzeta),jtim(0:nxi,0:nzeta)
      real         beta(nxi,0:nzeta)
      real         ur1(nxi,0:nmax)
      real         ui1(nxi,0:nmax)

c     logical      heap

      NT1 = min (NT,nsamp)

      call maxv (rcritx, 1, xmax, indx, nzeta)
      call minv (rcritx, 1, xmin, indx, nzeta)

      write(LERR,*)'migit ',NXI,NZ,NRAY1,NT,NTMAX,LNGTH,LNGTH4,nsi,ntrc,
     1dipmax,sinmax,ppmax,nzeta,luin,nt1,dx
      write(LERR,*)'nmax= ',nmax,' rcit max= ',xmax,' rcit min= ',xmin

C
C     READ TRACES.
C
      DO 200 JX = 1,ntrc
C
C       ZERO OUT TRACE BEFORE READ
C
        DO 20 JT = 1,10000
          UDATA(JT) = 0.
          UC(JT)    = cmplx(0.,0.)
20      CONTINUE

        call vclr (wrk1, 1, 3)
        call vclr (wrk2, 1, 96)
C
C       READ A TRACE, CONSISTING OF
C       (1) TRACE HEADER -- 128 INTEGER   WORDS
C       (2) TRACE DATA: NTP2 REAL*4 WORDS
C

        NBYTES = 0
        CALL RTAPE(luin,itr,NBYTES)
        call vmov (itr(ITRWRD+1), 1, udata, 1, nsamp)
c       write(0,*)'jx= ',jx,itr(106),itr(107)

c       call bwfilt (udata, udata, wrk1, wrk2, coefs,
c    1               xnorm, norder, nsamp, initf, 0)
c       initf = 0

c       call vrvrs (udata,  1, nsamp)
c       call bwfilt (udata, udata, wrk1, wrk2, coefs,
c    1               xnorm, norder, nsamp, initf, 0)
c       call vrvrs (udata,  1, nsamp)
C
C       STORE TRACE HEADER
C
         DO 30 JHDR = 1,ITRWRD
           IHEADR(JX      ,JHDR) = itr(JHDR)
 30      CONTINUE
        UDATA(1) = 0.
C
C       GEOMETRICAL SPREADING 'CORRECTION' COMPENSATION
C
        UR1(JX, 0) = 0.
        UI1(JX, 0) = 0.

        tap = taper(jx)
        DO 40 JT = 1,NT1
          UC(JT) = cmplx (tap * UDATA(JT)/JT, 0.) * tscale(JT)
40      CONTINUE

C
C     FFT TRACES INTO FREQUENCY DOMAIN
C
        call cfftx  (UC, 2, NT, 1, 0, TRIGS1, ierr)
        call cfftss (UC, 2, NT)

        DO 41 JT = 1,NT
          UR1(JX,JT) = real  (UC(JT))
          UI1(JX,JT) = aimag (UC(JT))
41      CONTINUE

200   CONTINUE



      DO 1420 JX = 1,ntrc
C
C       SQRT(ABS(F)) MULTIPLIER IN THE FREQUENCY DOMAIN (HALF-DERIVATIVE)
C
        DO 1380 JT = 1,NT/2
          UR1(JX,JT) = SQRF(JT)*UR1(JX,JT)
          UI1(JX,JT) = SQRF(JT)*UI1(JX,JT)
1380    CONTINUE
C
C       ZERO PAD IN THE FREQUENCY DOMAIN.
C       TRACES WILL THEN BE SAMPLED AT .002 SEC.
C
        DO 1400 JT = NT/2,NTMAX
          UR1(JX,JT) = 0.
          UI1(JX,JT) = 0.
1400    CONTINUE

C     INVERSE FFT TRACES BACK INTO TIME DOMAIN

        do  1401  JT = 1, NTMAX

            UC(JT) = cmplx (UR1(JX,JT), UI1(JX,JT))
1401    continue

        call cfftx (UC, 2, NTMAX, -1, 0, TRIGS2, ierr)

        do  1402  JT = 1, NTMAX

            UR1(JX,JT) = real  (UC(JT))
            UI1(JX,JT) = aimag (UC(JT))
1402    continue


1420  CONTINUE

C
C


C
C     FAR-FIELD APPROXIMATE HALF-DERIVATIVE.
C
      DO 1460 JX = 1,ntrc
        DO 1440 JT = 1,NTMAX
c         UR1(JX,JT) = UR1(JX,JT)-UI1(JX,JT)
c         UI1(JX,JT) = UR3(JX,JT)-UI3(JX,JT)
          tempr1     = UR1(JX,JT)-UI1(JX,JT)
          tempi1     = UR1(JX,JT)-UI1(JX,JT)
          UR1(JX,JT) = tempr1
          UI1(JX,JT) = tempi1
1440    CONTINUE
1460  CONTINUE

C
C     EXPONENTIAL TAPER AT END OF TIME SECTION.
C     REDUCES ARTIFACTS FROM TRUNCATING THE TIME SECTION.
C
      DO 1500 JX = 1,ntrc
        UR1(JX,NTMAX-3) =   .5*UR1(JX,NTMAX-3)
        UR1(JX,NTMAX-2) =  .25*UR1(JX,NTMAX-2)
        UR1(JX,NTMAX-1) = .125*UR1(JX,NTMAX-1)
        UI1(JX,NTMAX-3) =   .5*UI1(JX,NTMAX-3)
        UI1(JX,NTMAX-2) =  .25*UI1(JX,NTMAX-2)
        UI1(JX,NTMAX-1) = .125*UI1(JX,NTMAX-1)
        IF (NTMAX .lt. LNGTH4) THEN
            DO 1480 JT = NTMAX,LNGTH4
              UR1(JX,JT) = 0.
              UI1(JX,JT) = 0.
1480        CONTINUE
        ENDIF
1500  CONTINUE

      call migbet (ntrc, nz, nzeta, nxi, nmax, lngth4, dx,
     1             ur1, ui1, jtim, jwave, jwmin, jwmax,
     2             beta, zett, rcritx, ntmx)



      write(LERR,*)' '
      write(LERR,*)' WRITE OUT THE MIGRATED STACKED RECORD= ',JR
C
C     REFORMAT (SIS) AND WRITE OUT THE STACKED MIGRATED SECTION
C

C
C     INITIALIZE TRACE DATA
C
      call outmig (ntrc, nz, lngth, lngth4, nzeta, nxi, nmax,
     1             trigs3, trigs4, zscale, uc, ur1, ui1, beta)


c     write(LERR,*)' '
c     write(LERR,*)'Current memory= ',ibyttot,'  bytes'
c     write(LERR,*)' '

 
      return
      end
