C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      SUBROUTINE VFILTR(UR,UI,NTRMAX,NT,JF1,JF2,JF3,JF4,NXI)
C
C     FREQUENCY BANDLIMIT A SET OF TRACES
C     VERY RINGY, CRUDE FILTER; THE SEISMIC WAVELET USUALLY PROVIDES
C     A BETTER FILTER
C
      REAL UR(NXI          ,0:4100),UI(NXI          ,0:4100)

      DO 10 JX = 1,NTRMAX
        UR(JX,1) = 0.
        UI(JX,1) = 0.
        UR(JX,NT/2+1) = 0.
        UI(JX,NT/2+1) = 0.
10    CONTINUE

C
C     F < F1
C
      DO 40 JF = 2,JF1
        DO 30 JX = 1,NTRMAX
          UR(JX,JF) = 0.
          UI(JX,JF) = 0.
          UR(JX,NT-JF+2) = 0.
          UI(JX,NT-JF+2) = 0.
30      CONTINUE
40    CONTINUE

C
C     F1 < F < F2
C
      DO 60 JF = JF1+1,JF2
        WGT = FLOAT(JF-JF1)/(JF2-JF1)
        DO 50 JX = 1,NTRMAX
          UR(JX,JF) = WGT*UR(JX,JF)
          UI(JX,JF) = WGT*UI(JX,JF)
          UR(JX,NT-JF+2) = WGT*UR(JX,NT-JF+2)
          UI(JX,NT-JF+2) = WGT*UI(JX,NT-JF+2)
50      CONTINUE
60    CONTINUE

C
C     F2 < F < F3
C
      DO 80 JF = JF2+1,JF3
        WGT = 1.
        DO 70 JX = 1,NTRMAX
          UR(JX,JF) = WGT*UR(JX,JF)
          UI(JX,JF) = WGT*UI(JX,JF)
          UR(JX,NT-JF+2) = WGT*UR(JX,NT-JF+2)
          UI(JX,NT-JF+2) = WGT*UI(JX,NT-JF+2)
70      CONTINUE
80    CONTINUE

C
C     F3 < F < F4
C
      DO 100 JF = JF3+1,JF4
        WGT = FLOAT(JF-JF4)/(JF3-JF4)
        DO 90 JX = 1,NTRMAX
          UR(JX,JF) = WGT*UR(JX,JF)
          UI(JX,JF) = WGT*UI(JX,JF)
          UR(JX,NT-JF+2) = WGT*UR(JX,NT-JF+2)
          UI(JX,NT-JF+2) = WGT*UI(JX,NT-JF+2)
90      CONTINUE
100   CONTINUE

C
C     F4 < F
C
      DO 120 JF = JF4+1,NT/2
        DO 110 JX = 1,NTRMAX
          UR(JX,JF) = 0.
          UI(JX,JF) = 0.
          UR(JX,NT-JF+2) = 0.
          UI(JX,NT-JF+2) = 0.
110     CONTINUE
120   CONTINUE
      RETURN
      END


