C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c Read a usp dataset, insert li and di into trace header       
c also insert them as floating point numbers into a 2 trace header
c locations as chosen by the user
c buildhdr.F
c
c Mary Ann Thornton           v: 1.0         March 16, 1995    
c************************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
      integer     lhed (SZLNHD)
      integer * 2 itr  (SZLNHD)
      real        head (SZLNHD)

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin, luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne
      integer     li1, di1, li, di, limax, dimax, liorder, diorder
      real        dy1,dy2,dx1,dx2,xli,xdi 
      character*6 lihw,dihw

      character   ntap  * 100, otap * 100, name*8, version*4
      logical     verbos, hlp, query
      integer     argis
      equivalence (itr( 1), lhed (1), head(1))
      data lbytes/ 0 /,nbytes/ 0 /,name/'BUILDHDR'/,version/' 1.0'/ 
 
c-----
c     read program parameters from command line card image file
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query .or. hlp )then
            call help()
            stop
      endif
c-----
c     open printout
#include <f77/mbsopen.h>
c-----
c     read command line arguments
      call gcmdln(ntap,otap,ns,ne,irs,ire,li1,dy1,dy2,liorder,lihw,
     &            di1,dx1,dx2,dihw,diorder,verbos)
c-----
c     open input and output files
      call getln(luin , ntap ,'r', 0)
      call getln(luout, otap ,'w', 1)
c-----
      lbytes = 0
      call rtape(luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'buildhdr: no line header read from unit ',luin
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
c------
c     save values from input line header
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'Dx1000', idx,   LINHED)
      call saver(itr, 'Dz1000', idz,   LINHED)
      dx = idx/1000.
      dz = idz/1000.
c------
c     print line header into printer listing
      call hlhprt(itr, lbytes, name, 6, LERR)
c-----
c     check validity of these arguments
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
c     check validity of these arguments (li1,di1,dy1,dy2,dx1,dx2)
      if(liorder.ge.1)then
         limax =     ((nrecc-1)*dy1/dy2) + li1 
      else
         limax = li1 -((nrecc-1)*dy1/dy2)
      endif
      if(diorder.ge.1)then
         dimax =       ((jtr-1)*dx1/dx2) + di1
      else
         dimax = di1 - ((jtr-1)*dx1/dx2)
      endif
      write(LER,*)'The first line index is  ',li1
      write(LER,*)'The last line index is   ',limax
      write(LER,*)'The first depth index is ',di1
      write(LER,*)'The last depth index is  ',dimax
      iflag = 0
      if(limax.gt.32767 .or. dimax.gt.32767) then
        iflag = 1
      endif
      if(limax.lt.(-32768).or. dimax.lt.(-32768))then
        iflag = 1
      endif
      if(iflag.ge.1)then
         write(LER,*)'The maximum value which can be entered into '
         write(LER,*)'a trace header location is 32767, and the '
         write(LER,*)'minimum value is -32768.'
         write(LER,*)'JOB TERMINATED ABNORMALLY'
         stop 100
      endif
c----------------------
c     determine obytes as the number of bytes in output trace
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------
c     save command line arguments in the historical part of line header
      call savhlh(itr,lbytes,lbyout)
c----------------------
c     write the output line header
      call wrtape(luout, itr, lbyout )
 
c----
      if( verbos ) then
         call verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,otap,ns,ne,irs,ire,
     &               dx,dz,li1,dy1,dy2,lihw,liorder,
     &               di1,dx1,dx2,dihw,diorder,verbos)
      endif

c-----
c--------------------------------------------------
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------

c-----skip unwanted records
      call recskp(1,irs-1,luin ,ntrc,itr)

c-----LOOP ON RECORDS
      do 1000 jj = irs, ire
         call trcskp(jj,1,ns-1,luin ,ntrc,itr)
         if(liorder.ge.1)then
            li = ((jj-1)*dy1/dy2) + li1
         else
            li = li1 - ((jj-1)*dy1/dy2)
         endif
c--------LOOP ON TRACES
         do 1003  nn = ns, ne
c           read the traces into itr
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:',luin
               write(LERR,*)'  rec= ',jj,'  trace= ',nn
               go to 999
            endif
            if(diorder.ge.1)then
               di = ((nn-1)*dx1/dx2) + di1
            else
               di = di1 - ((nn-1)*dx1/dx2) 
            endif
            call savew(itr, 'LinInd', li, TRCHED)
            call savew(itr, 'DphInd', di, TRCHED)
            xdi = di
            xli = li
            if(lihw.ne.' ')then
               call putfp(itr, lihw, xli, TRCHED)
            endif
            if(dihw.ne.' ')then
               call putfp(itr, dihw, xdi, TRCHED)
            endif
cmat        write(LER,*)' rec, trac, li, xli, di, xdi = ',
cmat &                    jj,nn,li,xli,di,xdi
            call wrtape (luout, itr, obytes)
 1003    continue
c-----
c        skip to end of record
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 1000 continue

c--------------------------------------------------
c--------------------------------------------------
c-----
c     END PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------
 
  999 continue
 
c-----
c     close data files
      call lbclos(luin)
      call lbclos(luout)
c-----
      write(LERR,*)'end of buildhdr, processed ',nrec,' record(s)',
     &               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
       write(LER,*)
     :'***************************************************************'
      write(LER,*) ' '
      write(LER,*)'buildhdr reads a usp dataset, and inserts a line '
      write(LER,*)'  index and depth index into each trace header.'
      write(LER,*)'  The indices are also inserted in user selected'
      write(LER,*)'  trace header words as floating point numbers.'
      write(LER,*)'  The beginning line index and increment and '  
      write(LER,*)'  beginning depth index and increment are supplied'
      write(LER,*)'  by command line arguments.'
#ifdef CRAYSYSTEM
      write(LER,*)'See manual pages by typing:   tman buildhdr '
#else
      write(LER,*)'See manual pages by typing:   man buildhdr ',
     &            'or:   mman buildhdr'
#endif
      write(LER,*)'See pattern file by typing:   catpat buildhdr'
      write(LER,*)'Build an executable script by typing: ',
     &            '     catpat buildhdr > buildhdr.job'
      write(LER,*)' '
      write(LER,*)'Execute buildhdr by typing buildhdr and the ',
     &            'program parameters.'
      write(LER,*)'Note that each parameter is proceeded by -a ',
     &            'where "a" is a character(s) corresponding ',
     &            'to some parameter.'
      write(LER,*)' '
      write(LER,*)'-N[ntap]     :input dataset'    
      write(LER,*)'-O[otap]     :output dataset'  
      write(LER,*)'-ns[ns]      :start trace number        (default=1)'    
      write(LER,*)'-ne[ne]      :end trace number        (default=all)'
      write(LER,*)'-rs[irs]     :start record number       (default=1)'
      write(LER,*)'-re[ire]     :end record number       (default=all)'
      write(LER,*)'-li1[li1]    :start line index "LinInd" (default=1)'
      write(LER,*)'-dy1[dy1]    :distance between consecutive records '
      write(LER,*)'-dy2[dy2]    :distance between sequential li indices'
      write(LER,*)'-lihw[lihw]  :1st of 2 trace header locations for '
      write(LER,*)'              storing li as a floating point number'
      write(LER,*)'-liorder[ord]:ascending = 1; descending < 1'
      write(LER,*)'-di1[di1]    :start depth index "DphInd" (default=1)'
      write(LER,*)'-dx1[dx1]    :distance between consecutive traces  '
      write(LER,*)'-dx2[dx2]    :distance between sequential di indices'
      write(LER,*)'-dihw[dihw]  :1st of 2 trace header locations for '
      write(LER,*)'              storing di as a floating point number'
      write(LER,*)'-diorder[ord]:ascending = 1; descending < 1'
      write(LER,*)'-V           :for verbose printout'
      write(LER,*)' '
      write(LER,*)'usage:  '
      write(LER,*)'buildhdr -N[] -O[] -ns[] -ne[] -rs[] -re[] '
      write(LER,*)'         -li1[] -dy1[] -dy2[] -lihw[] -liorder[]'
      write(LER,*)'         -di1[] -dx1[] -dx2[] -dihw[] -diorder[]'
      write(LER,*)'          [-V] '
      write(LER,*)' '
      write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,li1,dy1,dy2,liorder,
     &                  lihw,di1,dx1,dx2,dihw,diorder,verbos)
c-----
c     get command arguments
c
c     ntap    - C*100    input file name velocity
c     otap    - C*100    output file name
c     ns      - int      starting trace index
c     ne      - int      ending trace index
c     irs     - int      starting record index
c     ire     - int      ending record index
c     li1     - int      starting line index
c     dy1     - real     distance between 2 consecutive records
c     dy2     - real     distance between 2 sequential Li indices
c     liorder - int      ascending or descending
c     lihw    - C*6      trace header word for storing floating point li
c     di1     - int      starting depth index 
c     dx1     - real     distance between two consecutive traces
c     dx2     - real     distance between two sequential Di indices
c     diorder - int      ascending or descending
c     dihw    - C*6      trace header word for storing floating point di
c     verbos  - L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      character*6 lihw, dihw
      integer     ns, ne, irs, ire
      logical     verbos
      integer     argis
      integer     li1,di1,liorder,diorder
      real        dy1,dy2,dx1,dx2
 
c-------
c     last 2 arguments are values used when:
c     (1) if ONLY the key is present (no value attached to it)
c     (2) if NO key & no value are present
c-------
            call argstr('-N'      , ntap, ' ', ' ')
            call argstr('-O'      , otap, ' ', ' ')
            call argi4 ('-ns'     , ns,     1,   1)
            call argi4 ('-ne'     , ne,     0,   0)
            call argi4 ('-rs'     , irs,    1,   1)
            call argi4 ('-re'     , ire,    0,   0)
            call argi4 ('-li1'    , li1,    1,   1)
            call argr4 ('-dy1'    , dy1,    1,   1)
            call argr4 ('-dy2'    , dy2,    1,   1)
            call argstr('-lihw'   , lihw, ' ', ' ')
            call argi4 ('-liorder', liorder,1,   1)
            call argi4 ('-di1'    , di1,    1,   1)
            call argr4 ('-dx1'    , dx1,    1,   1)
            call argr4 ('-dx2'    , dx2,    1,   1)
            call argstr('-dihw'   , dihw, ' ', ' ')
            call argi4 ('-diorder', diorder,1,   1)
            verbos =   (argis('-V') .gt. 0)
c-------
      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,otap,ns,ne,irs,ire,
     &               dx,dz,li1,dy1,dy2,lihw,liorder,
     &               di1,dx1,dx2,dihw,diorder,verbos)
c-----
c     verbose output of processing parameters
c
c     nsamp   - I*4     number of samples in trace
c     nsi     - I*4     sample interval in ms
c     ntrc    - I*4     traces per record
c     nrec    - I*4     number of records per line
c     iform   - I*4     format of data
c     ntap    - C*100   input file name velocity
c     otap    - C*100   output file name
c     ns      - Int     starting record
c     ne      - Int     ending record
c     irs     - Int     starting trace
c     ire     - Int     ending trace
c     dx      - Real    dx from the line header
c     dz      - Real    dz from the line header
c     li1     - int     starting line index
c     dy1     - real    distance between 2 consecutive records
c     dy2     - real    distance between 2 sequential Li indices
c     liorder - int     ascending or descending
c     lihw    - C*6     trace header word for storing floating point li
c     di1     - int     starting depth index
c     dx1     - real    distance between two consecutive traces
c     dx2     - real    distance between two sequential Di indices
c     diorder - int     ascending or descending
c     dihw    - C*6     trace header word for storing floating point di
c     verbos  - L       verbose output or not

c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec,ns,ne,irs,ire
      integer     li1,liorder,di1,diorder
      real        dx,dx1,dx2,dy1,dy2,dz
      character   ntap*100, otap*100, lihw*6, dihw*6
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*)' # of samples/trace                     = ', nsamp
      write(LERR,*)' sample interval                        = ', nsi
      write(LERR,*)' traces per record                      = ', ntrc
      write(LERR,*)' records per line                       = ', nrec
      write(LERR,*)' format of data                         = ', iform
      write(LERR,*)' input dataset                          = ', ntap
      write(LERR,*)' output dataset                         = ', otap
      write(LERR,*)' starting record                        = ', irs
      write(LERR,*)' ending record                          = ', ire
      write(LERR,*)' starting trace                         = ', ns
      write(LERR,*)' ending trace                           = ', ne
      write(LERR,*)' dx from the line header                = ', dx 
      write(LERR,*)' dz from the line header                = ', dz 
      write(LERR,*)' starting line index                    = ', li1
      write(LERR,*)' distance between consecutive records   = ', dy1
      write(LERR,*)' distance between sequential Li indices = ', dy2
      write(LERR,*)' distance between consecutive traces    = ', dx1
      write(LERR,*)' distance between sequential Di indices = ', dx2
      if(lihw.ne.' ')then
      write(LERR,*)' keyword for storing floating point li  = ', lihw
      else
      write(LERR,*)' no keyword given for storing floating point li'
      endif
      if(dihw.ne.' ')then
      write(LERR,*)' keyword for storing floating point di  = ', dihw
      else
      write(LERR,*)' no keyword given for storing floating point di'
      endif
      if(liorder.ge.1)then
      write(LERR,*)' li order is ascending'
      else
      write(LERR,*)' li order is descending'
      endif
      if(diorder.ge.1)then
      write(LERR,*)' di order is ascending'
      else
      write(LERR,*)' di order is descending'
      endif
      write(LERR,*)' '
 
      return
      end
 
