C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3PUTPAR   PUT PARAMETERS                                      *
C***********************************************************************

      subroutine c3putpar( lu_ddout, fn_ddout, fn_image, fn_zeta,
     &                     nzbar, nkx, kx0, dkx, nky, ky0, dky,
     &                     nt, nx, ny, dzgrid, zmax, dtgrid, tmax,
     &                     axis3, verbos, debug )

      implicit none

c input parameters:       

      character axis3*2         ! third axis name
      integer   debug           ! debug output flag
      real      dkx             ! delta kx
      real      dky             ! delta ky
      real      dtgrid          ! delta t
      real      dzgrid          ! delta z
      character fn_ddout*100    ! name of output data dictionary file
      character fn_image*100    ! name of output image file
      character fn_zeta*100     ! name of output zeta file
      real      kx0             ! kx origin
      real      ky0             ! ky origin
      integer   lu_ddout        ! logical unit of output data dictionary
      integer   nkx             ! number of x wave numbers
      integer   nky             ! number of y wave numbers
      integer   nt              ! original number of time samples/trace
      integer   nx              ! original number of x's
      integer   ny              ! original number of y's
      integer   nzbar           ! number of z's (irregular grid)
      real      tmax            ! maximum time for migration
      logical   verbos          ! verbose output flag
      real      zmax            ! maximum depth for migration

c local variables:

      integer   rank            ! rank of input data

c-----------------------------------------------------------------------

      open( unit=lu_ddout, file=fn_ddout, status='unknown' )

      write( lu_ddout, '(6hzeta= , a100)' ) fn_zeta
      write( lu_ddout, '(6hdata= , a100)' ) fn_image
      write( lu_ddout, '(11hformat= usp)' )
      write( lu_ddout, '(20hdata_type= complex*8)' )

      if     ( axis3 .eq. '  ' ) then
         write( lu_ddout, '(13haxis= zbar kx)' )
         write( lu_ddout, '(5hsize=, 2i5)' ) nzbar, nkx
         write( lu_ddout, '(13hdelta=   -1.0, e18.8)' ) dkx
         write( lu_ddout, '(13horigin=  -1.0, e18.8)' ) kx0
      else
         write( lu_ddout, '(14haxis= zbar kx ,a2)' ) axis3
         write( lu_ddout, '(5hsize=, 3i5)' ) nzbar, nkx, nky
         write( lu_ddout, '(13hdelta=   -1.0, 2e18.8)' ) dkx, dky
         write( lu_ddout, '(13horigin=  -1.0, 2e18.8)' ) kx0, ky0
      endif

      write( lu_ddout, '(9htxy_size=, 3i5)' ) nt, nx, ny
      write( lu_ddout, '(5hzmax=, f10.3)' ) zmax
      write( lu_ddout, '(5htmax=, f10.3)' ) tmax
      write( lu_ddout, '(3hdz=, f12.3)' ) dzgrid
      write( lu_ddout, '(3hdt=, f12.3)' ) dtgrid

      close( lu_ddout )
      return
      end
